/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPickManager;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickAction
extends DumbAwareAction {
    public VcsCherryPickAction() {
        super(DvcsBundle.messagePointer((String)"cherry.pick.action.text", (Object[])new Object[0]), DvcsBundle.messagePointer((String)"cherry.pick.action.description", (Object[])new Object[0]), DvcsImplIcons.CherryPick);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsCherryPickAction.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsCherryPickManager.getInstance(project).cherryPick(log);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsCherryPickAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        e.getPresentation().setVisible(true);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsCherryPickManager cherryPickManager = VcsCherryPickManager.getInstance(project);
        List<VcsCherryPicker> cherryPickers = VcsCherryPickAction.getActiveCherryPickersForProject(project);
        if (log == null || cherryPickers.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = ContainerUtil.getFirstItems((List)log.getSelectedCommits(), (int)1000);
        if (commits.isEmpty() || cherryPickManager.isCherryPickAlreadyStartedFor(commits)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Map<VirtualFile, List<Hash>> groupedByRoot = VcsCherryPickAction.groupByRoot(commits);
        VcsCherryPicker activeCherryPicker = VcsCherryPickAction.getActiveCherryPicker(cherryPickers, groupedByRoot.keySet());
        e.getPresentation().setEnabled(activeCherryPicker != null);
        e.getPresentation().setText(activeCherryPicker == null ? VcsCherryPickAction.concatActionNamesForAllAvailable(cherryPickers) : activeCherryPicker.getActionTitle());
        e.getPresentation().setDescription(activeCherryPicker != null ? "" : DvcsBundle.message((String)"cherry.pick.action.description", (Object[])new Object[0]));
    }

    @Nullable
    private static VcsCherryPicker getActiveCherryPicker(@NotNull List<VcsCherryPicker> cherryPickers, @NotNull Collection<VirtualFile> roots) {
        if (cherryPickers == null) {
            VcsCherryPickAction.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VcsCherryPickAction.$$$reportNull$$$0(3);
        }
        return (VcsCherryPicker)ContainerUtil.find(cherryPickers, picker -> picker.canHandleForRoots(roots));
    }

    @NotNull
    private static Map<VirtualFile, List<Hash>> groupByRoot(@NotNull List<CommitId> details) {
        if (details == null) {
            VcsCherryPickAction.$$$reportNull$$$0(4);
        }
        HashMap<VirtualFile, List<Hash>> result2 = new HashMap<VirtualFile, List<Hash>>();
        for (CommitId commit2 : details) {
            ArrayList<Hash> hashes = (ArrayList<Hash>)result2.get(commit2.getRoot());
            if (hashes == null) {
                hashes = new ArrayList<Hash>();
                result2.put(commit2.getRoot(), hashes);
            }
            hashes.add(commit2.getHash());
        }
        HashMap<VirtualFile, List<Hash>> hashMap = result2;
        if (hashMap == null) {
            VcsCherryPickAction.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @Nls
    @NotNull
    private static String concatActionNamesForAllAvailable(@NotNull List<VcsCherryPicker> pickers) {
        if (pickers == null) {
            VcsCherryPickAction.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join(pickers, VcsCherryPicker::getActionTitle, (String)"/");
        if (string == null) {
            VcsCherryPickAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<VcsCherryPicker> getActiveCherryPickersForProject(@Nullable Project project) {
        if (project != null) {
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            Object[] vcss = projectLevelVcsManager.getAllActiveVcss();
            List list2 = ContainerUtil.mapNotNull((Object[])vcss, vcs -> vcs != null ? VcsCherryPickManager.getInstance(project).getCherryPickerFor(vcs.getKeyInstanceMethod()) : null);
            if (list2 == null) {
                VcsCherryPickAction.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            VcsCherryPickAction.$$$reportNull$$$0(9);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cherryPickers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/cherrypick/VcsCherryPickAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pickers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "concatActionNamesForAllAvailable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveCherryPickersForProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActiveCherryPicker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "concatActionNamesForAllAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

