/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Font;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryNode
extends CheckedTreeNode
implements EditableTreeNode,
Comparable<RepositoryNode> {
    @NotNull
    protected final AtomicBoolean myLoading;
    @NotNull
    private final CheckBoxModel myCheckBoxModel;
    @NotNull
    private final RepositoryWithBranchPanel myRepositoryPanel;
    @Nullable
    private Future<AtomicReference<OutgoingResult>> myFuture;

    public RepositoryNode(@NotNull RepositoryWithBranchPanel repositoryPanel, @NotNull CheckBoxModel model2, boolean enabled) {
        if (repositoryPanel == null) {
            RepositoryNode.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            RepositoryNode.$$$reportNull$$$0(1);
        }
        super((Object)repositoryPanel);
        this.myLoading = new AtomicBoolean();
        this.myCheckBoxModel = model2;
        this.setChecked(false);
        this.setEnabled(enabled);
        this.myRepositoryPanel = repositoryPanel;
    }

    public boolean isChecked() {
        return this.myCheckBoxModel.isChecked();
    }

    public void setChecked(boolean checked) {
        this.myCheckBoxModel.setChecked(checked);
    }

    public boolean isCheckboxVisible() {
        return true;
    }

    public void forceUpdateUiModelWithTypedText(@NotNull String forceText) {
        if (forceText == null) {
            RepositoryNode.$$$reportNull$$$0(2);
        }
        this.myRepositoryPanel.getTargetPanel().forceUpdateEditableUiModel(forceText);
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer2) {
        if (renderer2 == null) {
            RepositoryNode.$$$reportNull$$$0(3);
        }
        this.render(renderer2, null);
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer2, @Nullable @Nls String syncEditingText) {
        if (renderer2 == null) {
            RepositoryNode.$$$reportNull$$$0(4);
        }
        int repoFixedWidth = 120;
        SimpleTextAttributes repositoryDetailsTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer2, SimpleTextAttributes.REGULAR_ATTRIBUTES, this.isChecked());
        renderer2.append(this.getRepoName(renderer2, repoFixedWidth), repositoryDetailsTextAttributes);
        renderer2.appendTextPadding(repoFixedWidth);
        renderer2.append(this.myRepositoryPanel.getSourceName(), repositoryDetailsTextAttributes);
        renderer2.append(this.myRepositoryPanel.getArrow(), repositoryDetailsTextAttributes);
        PushTargetPanel pushTargetPanel = this.myRepositoryPanel.getTargetPanel();
        pushTargetPanel.render(renderer2, renderer2.getTree().isPathSelected(TreeUtil.getPathFromRoot((TreeNode)((Object)this))), this.isChecked(), syncEditingText);
    }

    @Nls
    @NotNull
    private String getRepoName(@NotNull ColoredTreeCellRenderer renderer2, int maxWidth) {
        String name;
        if (renderer2 == null) {
            RepositoryNode.$$$reportNull$$$0(5);
        }
        Object object = GraphicsUtil.stringWidth((String)(name = this.getRepositoryName()), (Font)renderer2.getFont()) > maxWidth - 10 ? name + "  " : name;
        if (object == null) {
            RepositoryNode.$$$reportNull$$$0(6);
        }
        return object;
    }

    public Object getUserObject() {
        return this.myRepositoryPanel;
    }

    @Override
    public void fireOnChange() {
        this.myRepositoryPanel.fireOnChange();
    }

    @Override
    public void fireOnCancel() {
        this.myRepositoryPanel.fireOnCancel();
    }

    @Override
    public void fireOnSelectionChange(boolean isSelected) {
        this.myRepositoryPanel.fireOnSelectionChange(isSelected);
    }

    @Override
    public void cancelLoading() {
        if (this.myFuture != null && !this.myFuture.isDone()) {
            this.myFuture.cancel(true);
        }
    }

    @Override
    public void startLoading(@NotNull JTree tree, @NotNull Future<AtomicReference<OutgoingResult>> future2, boolean initial) {
        if (tree == null) {
            RepositoryNode.$$$reportNull$$$0(7);
        }
        if (future2 == null) {
            RepositoryNode.$$$reportNull$$$0(8);
        }
        this.myFuture = future2;
        this.myLoading.set(true);
    }

    @Override
    public boolean isEditableNow() {
        return this.myRepositoryPanel.isEditable();
    }

    @Override
    public int compareTo(@NotNull RepositoryNode repositoryNode) {
        if (repositoryNode == null) {
            RepositoryNode.$$$reportNull$$$0(9);
        }
        String name = this.myRepositoryPanel.getRepositoryName();
        RepositoryWithBranchPanel panel2 = (RepositoryWithBranchPanel)((Object)repositoryNode.getUserObject());
        return name.compareTo(panel2.getRepositoryName());
    }

    public void stopLoading() {
        this.myLoading.set(false);
    }

    public boolean isLoading() {
        return this.myLoading.get();
    }

    @Nls
    @NotNull
    String getRepositoryName() {
        String string = this.myRepositoryPanel.getRepositoryName();
        if (string == null) {
            RepositoryNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String toString() {
        return this.getRepositoryName() + " " + this.getRepositoryPresentationDetails();
    }

    @NotNull
    protected String getRepositoryPresentationDetails() {
        PushTarget targetValue = this.myRepositoryPanel.getTargetPanel().getValue();
        String string = this.myRepositoryPanel.getSourceName() + (String)(targetValue != null ? this.myRepositoryPanel.getArrow() + targetValue : "");
        if (string == null) {
            RepositoryNode.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forceText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/RepositoryNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/RepositoryNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPresentationDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateUiModelWithTypedText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepoName";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startLoading";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

