/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesDialog;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    protected EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;
    protected final Map<String, String> myParentDefaults = new LinkedHashMap<String, String>();
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
                EnvironmentVariablesTextFieldWithBrowseButton.this.createDialog().show();
            }
        });
        this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!StringUtil.equals((CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.this.stringifyEnvs(EnvironmentVariablesTextFieldWithBrowseButton.this.myData), (CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.this.getText())) {
                    Map textEnvs = EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.myData = EnvironmentVariablesTextFieldWithBrowseButton.this.myData.with(textEnvs);
                    EnvironmentVariablesTextFieldWithBrowseButton.this.fireStateChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton$2", "textChanged"));
            }
        });
    }

    @NotNull
    protected EnvironmentVariablesDialog createDialog() {
        return new EnvironmentVariablesDialog(this);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myData.getEnvs();
        if (map2 == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(1);
        }
        this.setData(this.myData.with(envs));
    }

    @NotNull
    public EnvironmentVariablesData getData() {
        EnvironmentVariablesData environmentVariablesData = this.myData;
        if (environmentVariablesData == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        return environmentVariablesData;
    }

    public void setData(@NotNull EnvironmentVariablesData data2) {
        if (data2 == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data2;
        this.setText(this.stringifyEnvs(data2));
        if (!oldData.equals(data2)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon2 = AllIcons.General.InlineVariables;
        if (icon2 == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        Icon icon2 = AllIcons.General.InlineVariablesHover;
        if (icon2 == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @NotNull
    protected String stringifyEnvs(@NotNull EnvironmentVariablesData evd) {
        if (evd == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(6);
        }
        if (evd.getEnvs().isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry2 : evd.getEnvs().entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(StringUtil.escapeChar((String)entry2.getKey(), (char)';')).append("=").append(StringUtil.escapeChar((String)entry2.getValue(), (char)';'));
        }
        String string = buf.toString();
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.setData(this.myData.with(passParentEnvs));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(8);
        }
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(9);
        }
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener2 : this.myListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    protected static List<EnvironmentVariable> convertToVariables(Map<String, String> map2, final boolean readOnly) {
        return ContainerUtil.map(map2.entrySet(), entry2 -> new EnvironmentVariable((String)entry2.getKey(), (String)entry2.getValue(), readOnly){

            public boolean getNameIsWriteable() {
                return !readOnly;
            }
        });
    }

    @NotNull
    @NlsContexts.Tooltip
    protected String getIconTooltip() {
        String string = ExecutionBundle.message((String)"specify.environment.variables.tooltip", (Object[])new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 64)) + ")";
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean isModifiedSysEnv(@NotNull EnvironmentVariable v) {
        if (v == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(11);
        }
        return !v.getNameIsWriteable() && !Objects.equals(v.getValue(), this.myParentDefaults.get(v.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evd";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyEnvs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stringifyEnvs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedSysEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

