/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleEncodingComboBox;
import com.intellij.execution.console.ConsoleFoldingSettings;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingReference;
import com.intellij.ui.AddEditDeleteListPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(ConsoleConfigurable.class);
    private JPanel myMainComponent;
    private JCheckBox myCbUseSoftWrapsAtConsole;
    private JTextField myCommandsHistoryLimitField;
    private JCheckBox myCbOverrideConsoleCycleBufferSize;
    private ConsoleEncodingComboBox myEncodingComboBox;
    private JTextField myConsoleCycleBufferSizeField;
    private JLabel myConsoleBufferSizeWarningLabel;
    private MyAddDeleteListPanel myPositivePanel;
    private MyAddDeleteListPanel myNegativePanel;
    private final ConsoleFoldingSettings mySettings = ConsoleFoldingSettings.getSettings();

    public JComponent createComponent() {
        if (this.myMainComponent == null) {
            this.myMainComponent = new JPanel(new BorderLayout());
            this.myCbUseSoftWrapsAtConsole = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.soft.wraps.at.console", (Object[])new Object[0]), false);
            this.myCommandsHistoryLimitField = new JTextField(4);
            this.myCbOverrideConsoleCycleBufferSize = new JCheckBox(ApplicationBundle.message((String)"checkbox.override.console.cycle.buffer.size", (Object[])new Object[]{String.valueOf(ConsoleBuffer.getLegacyCycleBufferSize() / 1024)}), false);
            this.myCbOverrideConsoleCycleBufferSize.addChangeListener(e -> {
                this.myConsoleCycleBufferSizeField.setEnabled(this.myCbOverrideConsoleCycleBufferSize.isSelected());
                this.myConsoleBufferSizeWarningLabel.setVisible(this.myCbOverrideConsoleCycleBufferSize.isSelected());
            });
            this.myConsoleCycleBufferSizeField = new JTextField(4);
            this.myConsoleBufferSizeWarningLabel = new JLabel();
            this.myConsoleBufferSizeWarningLabel.setForeground((Color)JBColor.red);
            this.myConsoleCycleBufferSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ConsoleConfigurable.this.updateWarningLabel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/ConsoleConfigurable$1", "textChanged"));
                }
            });
            this.myEncodingComboBox = new ConsoleEncodingComboBox();
            JPanel northPanel = new JPanel(new GridBagLayout());
            GridBag gridBag = new GridBag();
            gridBag.anchor(17).setDefaultAnchor(17);
            northPanel.add((Component)this.myCbUseSoftWrapsAtConsole, gridBag.nextLine().next());
            northPanel.add(Box.createHorizontalGlue(), gridBag.next().coverLine());
            JLabel label2 = new JLabel(ApplicationBundle.message((String)"editbox.console.history.limit", (Object[])new Object[0]));
            label2.setLabelFor(this.myCommandsHistoryLimitField);
            northPanel.add((Component)label2, gridBag.nextLine().next());
            northPanel.add((Component)this.myCommandsHistoryLimitField, gridBag.next());
            if (ConsoleBuffer.useCycleBuffer()) {
                northPanel.add((Component)this.myCbOverrideConsoleCycleBufferSize, gridBag.nextLine().next());
                northPanel.add((Component)this.myConsoleCycleBufferSizeField, gridBag.next());
                northPanel.add((Component)new JLabel(ExecutionBundle.message((String)"settings.console.kb", (Object[])new Object[0])), gridBag.next());
                northPanel.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag.next());
                northPanel.add((Component)this.myConsoleBufferSizeWarningLabel, gridBag.next());
            }
            northPanel.add((Component)new JLabel(ApplicationBundle.message((String)"combobox.console.default.encoding.label", (Object[])new Object[0])), gridBag.nextLine().next());
            northPanel.add((Component)((Object)this.myEncodingComboBox), gridBag.next().coverLine());
            if (!this.editFoldingsOnly()) {
                JPanel wrapper2 = new JPanel(new BorderLayout());
                wrapper2.add((Component)northPanel, "West");
                this.myMainComponent.add((Component)wrapper2, "North");
            }
            Splitter splitter = new Splitter(true);
            this.myMainComponent.add((Component)splitter, "Center");
            this.myPositivePanel = new MyAddDeleteListPanel(ApplicationBundle.message((String)"console.fold.console.lines", (Object[])new Object[0]), ApplicationBundle.message((String)"console.enter.substring.folded", (Object[])new Object[0]));
            this.myNegativePanel = new MyAddDeleteListPanel(ApplicationBundle.message((String)"console.fold.exceptions", (Object[])new Object[0]), ApplicationBundle.message((String)"console.enter.substring.dont.fold:", (Object[])new Object[0]));
            splitter.setFirstComponent((JComponent)((Object)this.myPositivePanel));
            splitter.setSecondComponent((JComponent)((Object)this.myNegativePanel));
            this.myPositivePanel.getEmptyText().setText(ApplicationBundle.message((String)"console.fold.nothing", (Object[])new Object[0]));
            this.myNegativePanel.getEmptyText().setText(ApplicationBundle.message((String)"console.no.exceptions", (Object[])new Object[0]));
        }
        return this.myMainComponent;
    }

    private void updateWarningLabel() {
        try {
            int value2 = Integer.parseInt(this.myConsoleCycleBufferSizeField.getText().trim());
            if (value2 <= 0) {
                this.myConsoleBufferSizeWarningLabel.setText(ApplicationBundle.message((String)"checkbox.override.console.cycle.buffer.size.warning.unlimited", (Object[])new Object[0]));
                return;
            }
            if (value2 > FileUtilRt.LARGE_FOR_CONTENT_LOADING / 1024) {
                this.myConsoleBufferSizeWarningLabel.setText(ApplicationBundle.message((String)"checkbox.override.console.cycle.buffer.size.warning.too.large", (Object[])new Object[0]));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myConsoleBufferSizeWarningLabel.setText("");
    }

    protected boolean editFoldingsOnly() {
        return false;
    }

    public void addRule(@NotNull String rule) {
        if (rule == null) {
            ConsoleConfigurable.$$$reportNull$$$0(0);
        }
        this.myPositivePanel.addRule(rule);
    }

    public boolean isModified() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        boolean isModified = !ContainerUtil.newHashSet((Object[])this.myNegativePanel.getListItems()).equals(new HashSet<String>(this.mySettings.getNegativePatterns()));
        isModified |= !ContainerUtil.newHashSet((Object[])this.myPositivePanel.getListItems()).equals(new HashSet<String>(this.mySettings.getPositivePatterns()));
        isModified |= this.isModified(this.myCbUseSoftWrapsAtConsole, editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        UISettings uiSettings = UISettings.getInstance();
        isModified |= ConsoleConfigurable.isModified(this.myCommandsHistoryLimitField, uiSettings.getConsoleCommandHistoryLimit());
        if (ConsoleBuffer.useCycleBuffer()) {
            isModified |= this.isModified(this.myCbOverrideConsoleCycleBufferSize, uiSettings.getOverrideConsoleCycleBufferSize());
            isModified |= ConsoleConfigurable.isModified(this.myConsoleCycleBufferSizeField, uiSettings.getConsoleCycleBufferSizeKb());
        }
        return isModified |= this.isEncodingModified();
    }

    private static boolean isModified(JTextField textField2, int value2) {
        try {
            int fieldValue = Integer.parseInt(textField2.getText().trim());
            return fieldValue != value2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isEncodingModified() {
        EncodingReference consoleEncoding;
        EncodingManager encodingManager = EncodingManager.getInstance();
        EncodingReference defaultEncoding = EncodingReference.DEFAULT;
        if (encodingManager instanceof EncodingManagerImpl) {
            defaultEncoding = ((EncodingManagerImpl)encodingManager).getDefaultConsoleEncodingReference();
        }
        return !defaultEncoding.equals((Object)(consoleEncoding = this.myEncodingComboBox.getSelectedEncodingReference()));
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        UISettings settingsManager = UISettings.getInstance();
        UISettingsState uiSettings = settingsManager.getState();
        EncodingManager encodingManager = EncodingManager.getInstance();
        editorSettings.setUseSoftWraps(this.myCbUseSoftWrapsAtConsole.isSelected(), SoftWrapAppliancePlaces.CONSOLE);
        boolean uiSettingsChanged = false;
        if (ConsoleConfigurable.isModified(this.myCommandsHistoryLimitField, uiSettings.getConsoleCommandHistoryLimit())) {
            uiSettings.setConsoleCommandHistoryLimit(Math.max(0, Math.min(1000, Integer.parseInt(this.myCommandsHistoryLimitField.getText().trim()))));
            uiSettingsChanged = true;
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            if (this.isModified(this.myCbOverrideConsoleCycleBufferSize, uiSettings.getOverrideConsoleCycleBufferSize())) {
                uiSettings.setOverrideConsoleCycleBufferSize(this.myCbOverrideConsoleCycleBufferSize.isSelected());
                uiSettingsChanged = true;
            }
            if (ConsoleConfigurable.isModified(this.myConsoleCycleBufferSizeField, uiSettings.getConsoleCycleBufferSizeKb())) {
                uiSettings.setConsoleCycleBufferSizeKb(Math.max(0, Integer.parseInt(this.myConsoleCycleBufferSizeField.getText().trim())));
                uiSettingsChanged = true;
            }
        }
        if (uiSettingsChanged) {
            settingsManager.fireUISettingsChanged();
        }
        if (this.isEncodingModified() && encodingManager instanceof EncodingManagerImpl) {
            ((EncodingManagerImpl)encodingManager).setDefaultConsoleEncodingReference(this.myEncodingComboBox.getSelectedEncodingReference());
        }
        this.myNegativePanel.applyTo(this.mySettings.getNegativePatterns());
        this.myPositivePanel.applyTo(this.mySettings.getPositivePatterns());
    }

    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        UISettingsState uiSettings = UISettings.getInstance().getState();
        EncodingManager encodingManager = EncodingManager.getInstance();
        this.myCbUseSoftWrapsAtConsole.setSelected(editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        this.myCommandsHistoryLimitField.setText(Integer.toString(uiSettings.getConsoleCommandHistoryLimit()));
        this.myCbOverrideConsoleCycleBufferSize.setEnabled(ConsoleBuffer.useCycleBuffer());
        this.myCbOverrideConsoleCycleBufferSize.setSelected(uiSettings.getOverrideConsoleCycleBufferSize());
        this.myConsoleCycleBufferSizeField.setEnabled(ConsoleBuffer.useCycleBuffer() && uiSettings.getOverrideConsoleCycleBufferSize());
        this.myConsoleCycleBufferSizeField.setText(Integer.toString(uiSettings.getConsoleCycleBufferSizeKb()));
        EncodingReference encodingReference = EncodingReference.DEFAULT;
        if (encodingManager instanceof EncodingManagerImpl) {
            encodingReference = ((EncodingManagerImpl)encodingManager).getDefaultConsoleEncodingReference();
        } else {
            LOG.warn("Expected EncodingManagerImpl but got " + encodingManager.getClass().getName());
        }
        this.myEncodingComboBox.reset(encodingReference);
        this.myNegativePanel.resetFrom(this.mySettings.getNegativePatterns());
        this.myPositivePanel.resetFrom(this.mySettings.getPositivePatterns());
    }

    public void disposeUIResources() {
        this.myMainComponent = null;
        this.myNegativePanel = null;
        this.myPositivePanel = null;
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            ConsoleConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"configurable.ConsoleConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.idesettings.console.folding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/ConsoleConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/ConsoleConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAddDeleteListPanel
    extends AddEditDeleteListPanel<String> {
        private final @NlsContexts.DialogMessage String myQuery;

        MyAddDeleteListPanel(@NlsContexts.Label String title2, @NlsContexts.DialogMessage String query2) {
            super(title2, new ArrayList());
            this.myQuery = query2;
            new ListSpeedSearch(this.myList);
        }

        @Nullable
        protected String findItemToAdd() {
            return this.showEditDialog("");
        }

        @Nullable
        private String showEditDialog(String initialValue) {
            return Messages.showInputDialog((Component)((Object)this), (String)this.myQuery, (String)ExecutionBundle.message((String)"dialog.title.folding.pattern", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initialValue, (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                @NlsContexts.DetailedDescription
                @Nullable
                public String getErrorText(String inputString) {
                    if (!this.checkInput(inputString)) {
                        return ExecutionBundle.message((String)"message.console.folding.rule.string.cannot.be.empty", (Object[])new Object[0]);
                    }
                    return null;
                }
            });
        }

        void resetFrom(List<String> patterns) {
            this.myListModel.clear();
            patterns.stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(this.myListModel::addElement);
        }

        void applyTo(List<? super String> patterns) {
            patterns.clear();
            for (Object o : this.getListItems()) {
                patterns.add((String)o);
            }
        }

        public void addRule(String rule) {
            this.addElement(rule);
        }

        protected String editSelectedItem(String item) {
            return this.showEditDialog(item);
        }
    }
}

