/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance(AsyncFilterRunner.class);
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Console Filters");
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private final Queue<HighlighterJob> myQueue;
    @NotNull
    private List<FilterResult> myResults;

    AsyncFilterRunner(@NotNull EditorHyperlinkSupport hyperlinks, @NotNull Editor editor) {
        if (hyperlinks == null) {
            AsyncFilterRunner.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AsyncFilterRunner.$$$reportNull$$$0(1);
        }
        this.myQueue = new ConcurrentLinkedQueue<HighlighterJob>();
        this.myResults = new ArrayList<FilterResult>();
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    void highlightHyperlinks(@NotNull Project project, @NotNull Filter customFilter, int startLine, int endLine) {
        if (project == null) {
            AsyncFilterRunner.$$$reportNull$$$0(2);
        }
        if (customFilter == null) {
            AsyncFilterRunner.$$$reportNull$$$0(3);
        }
        if (endLine < 0) {
            return;
        }
        this.myQueue.offer(new HighlighterJob(project, customFilter, startLine, endLine, this.myEditor.getDocument()));
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.runTasks();
            this.highlightAvailableResults();
            return;
        }
        CancellablePromise promise = ReadAction.nonBlocking(this::runTasks).submit((Executor)ourExecutor);
        if (AsyncFilterRunner.isQuick(promise)) {
            this.highlightAvailableResults();
        } else {
            promise.onSuccess(__ -> {
                if (this.hasResults()) {
                    ApplicationManager.getApplication().invokeLater(this::highlightAvailableResults, ModalityState.any());
                }
            });
        }
    }

    private static boolean isQuick(Promise<?> future2) {
        try {
            future2.blockingGet(5, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void highlightAvailableResults() {
        for (FilterResult result2 : this.takeAvailableResults()) {
            result2.applyHighlights();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResults() {
        Queue<HighlighterJob> queue2 = this.myQueue;
        synchronized (queue2) {
            return !this.myResults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<FilterResult> takeAvailableResults() {
        Queue<HighlighterJob> queue2 = this.myQueue;
        // MONITORENTER : queue2
        List<FilterResult> results = this.myResults;
        this.myResults = new ArrayList<FilterResult>();
        List<FilterResult> list2 = results;
        // MONITOREXIT : queue2
        if (list2 != null) return list2;
        AsyncFilterRunner.$$$reportNull$$$0(4);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLineResult(@Nullable FilterResult result2) {
        if (result2 == null) {
            return;
        }
        Queue<HighlighterJob> queue2 = this.myQueue;
        synchronized (queue2) {
            this.myResults.add(result2);
        }
    }

    boolean waitForPendingFilters(long timeoutMs) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long started = System.currentTimeMillis();
        while (true) {
            if (this.myQueue.isEmpty()) {
                this.highlightAvailableResults();
                return true;
            }
            if (this.hasResults()) {
                this.highlightAvailableResults();
                continue;
            }
            if (System.currentTimeMillis() - started > timeoutMs) {
                return false;
            }
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void runTasks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myEditor.isDisposed()) {
            return;
        }
        while (!this.myQueue.isEmpty()) {
            HighlighterJob highlighter = this.myQueue.peek();
            if (!DumbService.isDumbAware((Object)highlighter.filter) && DumbService.isDumb((Project)highlighter.myProject)) {
                return;
            }
            while (highlighter.hasUnprocessedLines()) {
                ProgressManager.checkCanceled();
                this.addLineResult(highlighter.analyzeNextLine());
            }
            LOG.assertTrue(highlighter == this.myQueue.remove());
        }
    }

    private static Filter.Result checkRange(Filter filter, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start2 = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start2 && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start2 + "; end=" + end + "; max=" + endOffset + "; filter=" + filter);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/AsyncFilterRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/AsyncFilterRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "takeAvailableResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeltaTracker {
        private final int initialMarkerOffset;
        private final RangeMarker endMarker;

        DeltaTracker(Document document, int offset) {
            this.initialMarkerOffset = offset;
            this.endMarker = document.createRangeMarker(this.initialMarkerOffset, this.initialMarkerOffset);
        }

        boolean isOutdated() {
            return !this.endMarker.isValid() || this.endMarker.getEndOffset() == 0;
        }

        int getOffsetDelta() {
            return this.endMarker.getStartOffset() - this.initialMarkerOffset;
        }
    }

    private class HighlighterJob {
        @NotNull
        private final Project myProject;
        private final AtomicInteger startLine;
        private final int endLine;
        private final DeltaTracker delta;
        @NotNull
        private final Filter filter;
        @NotNull
        private final Document snapshot;

        HighlighterJob(@NotNull Project project, Filter filter, int startLine, @NotNull int endLine, Document document) {
            if (project == null) {
                HighlighterJob.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                HighlighterJob.$$$reportNull$$$0(1);
            }
            if (document == null) {
                HighlighterJob.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.startLine = new AtomicInteger(startLine);
            this.endLine = endLine;
            this.filter = filter;
            this.delta = new DeltaTracker(document, document.getLineEndOffset(endLine));
            this.snapshot = ((DocumentImpl)document).freeze();
        }

        boolean hasUnprocessedLines() {
            return !this.delta.isOutdated() && this.startLine.get() <= this.endLine;
        }

        @Nullable
        private FilterResult analyzeNextLine() {
            int line = this.startLine.get();
            Filter.Result result2 = this.analyzeLine(line);
            LOG.assertTrue(line == this.startLine.getAndIncrement());
            return result2 == null ? null : new FilterResult(this.delta, result2);
        }

        private Filter.Result analyzeLine(int line) {
            int lineStart = this.snapshot.getLineStartOffset(line);
            if (lineStart + this.delta.getOffsetDelta() < 0) {
                return null;
            }
            String lineText = EditorHyperlinkSupport.getLineText(this.snapshot, line, true);
            int endOffset = lineStart + lineText.length();
            return AsyncFilterRunner.checkRange(this.filter, endOffset, this.filter.applyFilter(lineText, endOffset));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/AsyncFilterRunner$HighlighterJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FilterResult {
        private final DeltaTracker myDelta;
        private final Filter.Result myResult;

        FilterResult(DeltaTracker delta, Filter.Result result2) {
            this.myDelta = delta;
            this.myResult = result2;
        }

        void applyHighlights() {
            if (!this.myDelta.isOutdated()) {
                AsyncFilterRunner.this.myHyperlinks.highlightHyperlinks(this.myResult, this.myDelta.getOffsetDelta());
            }
        }
    }
}

