/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;

public class NameGeneratingListenerDecorator
implements RefactoringElementListener,
UndoRefactoringElementListener {
    private final LocatableConfiguration myConfiguration;
    private final RefactoringElementListener myListener;

    public NameGeneratingListenerDecorator(LocatableConfiguration configuration2, RefactoringElementListener listener2) {
        this.myConfiguration = configuration2;
        this.myListener = listener2;
    }

    public void elementMoved(@NotNull PsiElement newElement) {
        if (newElement == null) {
            NameGeneratingListenerDecorator.$$$reportNull$$$0(0);
        }
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementMoved(newElement);
        if (hasGeneratedName) {
            this.updateSuggestedName();
        }
    }

    public void elementRenamed(@NotNull PsiElement newElement) {
        if (newElement == null) {
            NameGeneratingListenerDecorator.$$$reportNull$$$0(1);
        }
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementRenamed(newElement);
        if (hasGeneratedName) {
            this.updateSuggestedName();
        }
    }

    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        if (newElement == null) {
            NameGeneratingListenerDecorator.$$$reportNull$$$0(2);
        }
        if (oldQualifiedName == null) {
            NameGeneratingListenerDecorator.$$$reportNull$$$0(3);
        }
        if (this.myListener instanceof UndoRefactoringElementListener) {
            boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
            ((UndoRefactoringElementListener)this.myListener).undoElementMovedOrRenamed(newElement, oldQualifiedName);
            if (hasGeneratedName) {
                this.updateSuggestedName();
            }
        }
    }

    private void updateSuggestedName() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myConfiguration.getProject());
        this.myConfiguration.setName(this.myConfiguration.suggestedName());
        RunnerAndConfigurationSettingsImpl settings2 = runManager.getSettings((RunConfiguration)this.myConfiguration);
        if (settings2 != null) {
            runManager.addConfiguration(settings2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldQualifiedName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/impl/NameGeneratingListenerDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "elementRenamed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undoElementMovedOrRenamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

