/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.PersistentAwareRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationLevel;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImplKt;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014*\u0002\u0011\u001b\u0018\u0000 b2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u00052\u00020\u0006:\u0003bcdB/\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J\u0011\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0096\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0016J\u001b\u0010)\u001a\u0004\u0018\u00010*2\u000e\b\u0004\u0010+\u001a\b\u0012\u0004\u0012\u00020 0,H\u0082\bJ\b\u0010-\u001a\u00020\nH\u0016J\u0016\u0010.\u001a\u0004\u0018\u00010/2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0016J\r\u00102\u001a\u000703\u00a2\u0006\u0002\b4H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u00106\u001a\u00020\u0014H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0014H\u0016J'\u00108\u001a\u0004\u0018\u0001H9\"\b\b\u0000\u00109*\u00020:2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H901H\u0016\u00a2\u0006\u0002\u0010;J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\r\u0010>\u001a\u00070?\u00a2\u0006\u0002\b@H\u0016J\b\u0010A\u001a\u00020\u0014H\u0016J\u0012\u0010B\u001a\u00020 2\n\u00100\u001a\u0006\u0012\u0002\b\u000301J2\u0010C\u001a\u00020 \"\u0004\b\u0000\u001092\u0010\u0010D\u001a\f\u0012\u0004\u0012\u0002H90ER\u00020\u00002\u0010\u0010F\u001a\f\u0012\u0004\u0012\u0002H90ER\u00020\u0000H\u0002J\u0015\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bIJ\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010J\u001a\u00020\fH\u0016J\b\u0010K\u001a\u00020\fH\u0016J\b\u0010L\u001a\u00020\fH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010M\u001a\u00020\fH\u0016J\u0006\u0010N\u001a\u00020\fJ\u0016\u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020Q2\u0006\u0010K\u001a\u00020\fJ\u0010\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\fH\u0016J\u0010\u0010T\u001a\u00020 2\b\u0010U\u001a\u0004\u0018\u00010\nJ\u0010\u0010V\u001a\u00020 2\u0006\u0010S\u001a\u00020\fH\u0016J\u0012\u0010W\u001a\u00020 2\b\u0010S\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010X\u001a\u00020 2\u0006\u0010Y\u001a\u00020\u0014H\u0016J\u0010\u0010Z\u001a\u00020 2\u0006\u0010S\u001a\u00020\fH\u0016J\u0010\u0010[\u001a\u00020 2\u0006\u0010\\\u001a\u00020\u0014H\u0016J\b\u0010]\u001a\u00020 H\u0016J\b\u0010^\u001a\u00020 H\u0016J\b\u0010_\u001a\u00020\u0014H\u0016J\u000e\u0010`\u001a\u00020 2\u0006\u0010P\u001a\u00020QJ\b\u0010a\u001a\u00020QH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "", "", "Lcom/intellij/configurationStore/SerializableScheme;", "Lcom/intellij/openapi/options/Scheme;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "_configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isTemplate", "", "level", "Lcom/intellij/execution/impl/RunConfigurationLevel;", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZLcom/intellij/execution/impl/RunConfigurationLevel;)V", "configurationPerRunnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1;", "folderName", "", "isActivateToolWindowBeforeRun", "isEditBeforeRun", "getManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "pathIfStoredInArbitraryFile", "runnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1;", "uniqueId", "wasSingletonSpecifiedExplicitly", "checkSettings", "", "executor", "Lcom/intellij/execution/Executor;", "clone", "compareTo", "", "other", "createFactory", "Lcom/intellij/openapi/util/Factory;", "doCheck", "Lcom/intellij/execution/configurations/RuntimeConfigurationWarning;", "check", "Lkotlin/Function0;", "getConfiguration", "getConfigurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "getFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lorg/jetbrains/annotations/Nullable;", "getFolderName", "getName", "getPathIfStoredInArbitraryFileInProject", "getRunnerSettings", "T", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/runners/ProgramRunner;)Lcom/intellij/execution/configurations/RunnerSettings;", "getSchemeState", "Lcom/intellij/openapi/options/SchemeState;", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "Lorg/jetbrains/annotations/NotNull;", "getUniqueID", "handleRunnerRemoved", "importFromTemplate", "templateItem", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "item", "importRunnerAndConfigurationSettings", "template", "importRunnerAndConfigurationSettings$intellij_platform_execution_impl", "isStoredInArbitraryFileInProject", "isStoredInDotIdeaFolder", "isStoredInLocalWorkspace", "isTemporary", "needsToBeMigrated", "readExternal", "element", "Lorg/jdom/Element;", "setActivateToolWindowBeforeRun", "value", "setConfiguration", "configuration", "setEditBeforeRun", "setFolderName", "setName", "name", "setTemporary", "storeInArbitraryFileInProject", "filePath", "storeInDotIdeaFolder", "storeInLocalWorkspace", "toString", "writeExternal", "writeScheme", "Companion", "InfoProvider", "RunnerItem", "intellij.platform.execution.impl"})
public final class RunnerAndConfigurationSettingsImpl
implements Cloneable,
RunnerAndConfigurationSettings,
Comparable<Object>,
SerializableScheme,
Scheme {
    private final runnerSettings.1 runnerSettings;
    private final configurationPerRunnerSettings.1 configurationPerRunnerSettings;
    private String pathIfStoredInArbitraryFile;
    private boolean isEditBeforeRun;
    private boolean isActivateToolWindowBeforeRun;
    private boolean wasSingletonSpecifiedExplicitly;
    private String folderName;
    private String uniqueId;
    @NotNull
    private final RunManagerImpl manager;
    private RunConfiguration _configuration;
    private boolean isTemplate;
    private RunConfigurationLevel level;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getFactory() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null || (runConfiguration = runConfiguration.getFactory()) == null) {
            runConfiguration = (ConfigurationFactory)UnknownConfigurationType.getInstance();
        }
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"_configuration?.factory \u2026urationType.getInstance()");
        return runConfiguration;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isTemporary() {
        return this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void setTemporary(boolean value2) {
        this.level = value2 ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE;
        this.pathIfStoredInArbitraryFile = null;
    }

    public void storeInLocalWorkspace() {
        if (this.level != RunConfigurationLevel.TEMPORARY) {
            this.level = RunConfigurationLevel.WORKSPACE;
        }
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInLocalWorkspace() {
        return this.level == RunConfigurationLevel.WORKSPACE || this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void storeInDotIdeaFolder() {
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInDotIdeaFolder() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile == null;
    }

    public void storeInArbitraryFileInProject(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = filePath;
    }

    public boolean isStoredInArbitraryFileInProject() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile != null;
    }

    @Nullable
    public String getPathIfStoredInArbitraryFileInProject() {
        return this.pathIfStoredInArbitraryFile;
    }

    @NotNull
    public RunConfiguration getConfiguration() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            RunConfiguration runConfiguration2 = UnknownConfigurationType.getInstance().createTemplateConfiguration(this.manager.getProject());
            runConfiguration = runConfiguration2;
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"UnknownConfigurationType\u2026guration(manager.project)");
        }
        return runConfiguration;
    }

    public final void setConfiguration(@Nullable RunConfiguration configuration2) {
        this._configuration = configuration2;
    }

    @NotNull
    public Factory<RunnerAndConfigurationSettings> createFactory() {
        return new Factory(this){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            public final RunnerAndConfigurationSettings create() {
                RunConfiguration configuration2 = this.this$0.getConfiguration();
                RunManagerImpl runManagerImpl = this.this$0.getManager();
                ConfigurationFactory configurationFactory = configuration2.getFactory();
                Intrinsics.checkNotNull((Object)configurationFactory);
                return new RunnerAndConfigurationSettingsImpl(runManagerImpl, configurationFactory.createConfiguration(ExecutionBundle.message((String)"default.run.configuration.name", (Object[])new Object[0]), configuration2), false, null, 12, null);
            }
            {
                this.this$0 = runnerAndConfigurationSettingsImpl;
            }
        };
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean existing = this.uniqueId != null && this.manager.getConfigurationById(this.getUniqueID()) != null;
        this.uniqueId = null;
        this.getConfiguration().setName(name);
        if (existing) {
            this.manager.addConfiguration(this);
        }
    }

    @NotNull
    public String getName() {
        RunConfiguration configuration2 = this.getConfiguration();
        if (this.isTemplate) {
            return "<template> of " + this.getFactory().getId();
        }
        String string = configuration2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.name");
        return string;
    }

    @NotNull
    public String getUniqueID() {
        String result2;
        block3: {
            block2: {
                result2 = this.uniqueId;
                if (result2 == null) break block2;
                CharSequence charSequence = result2;
                String string = this.getConfiguration().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.name");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) break block3;
            }
            RunConfiguration configuration2 = this.getConfiguration();
            this.uniqueId = result2 = Companion.getUniqueIdFor(configuration2);
        }
        return result2;
    }

    public void setEditBeforeRun(boolean value2) {
        this.isEditBeforeRun = value2;
    }

    public boolean isEditBeforeRun() {
        return this.isEditBeforeRun;
    }

    public void setActivateToolWindowBeforeRun(boolean value2) {
        this.isActivateToolWindowBeforeRun = value2;
    }

    public boolean isActivateToolWindowBeforeRun() {
        return this.isActivateToolWindowBeforeRun;
    }

    public void setFolderName(@Nullable String value2) {
        this.folderName = value2;
    }

    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    /*
     * Unable to fully structure code
     */
    public final void readExternal(@NotNull Element element, boolean isStoredInDotIdeaFolder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.isTemplate = JdomKt.getAttributeBooleanValue((Element)element, (String)"default");
        this.level = isStoredInDotIdeaFolder != false ? RunConfigurationLevel.PROJECT : (JdomKt.getAttributeBooleanValue((Element)element, (String)"temporary") != false || Intrinsics.areEqual((Object)"tempConfiguration", (Object)element.getName()) != false ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE);
        this.isEditBeforeRun = JdomKt.getAttributeBooleanValue((Element)element, (String)"editBeforeRun");
        value = element.getAttributeValue("activateToolWindowBeforeRun");
        if (value == null) ** GOTO lbl-1000
        var4_4 = value;
        var5_5 = false;
        if (Boolean.parseBoolean(var4_4)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.isActivateToolWindowBeforeRun = v0;
        this.folderName = element.getAttributeValue("folderName");
        v1 = this.manager.getFactory(element.getAttributeValue("type"), element.getAttributeValue("factoryName"), this.isTemplate == false);
        if (v1 == null) {
            return;
        }
        factory = v1;
        v2 = factory.createTemplateConfiguration(this.manager.getProject(), (RunManager)this.manager);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"factory.createTemplateCo\u2026manager.project, manager)");
        configuration = v2;
        if (!this.isTemplate) {
            v3 = element.getAttributeValue("name");
            if (v3 == null) {
                return;
            }
            configuration.setName(v3);
        }
        this._configuration = configuration;
        this.uniqueId = null;
        PathMacroManager.getInstance((ComponentManager)configuration.getProject()).expandPaths(element);
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            v4 = element.getChild("module");
            v5 = moduleName = v4 != null ? v4.getAttributeValue("name") : null;
            if (moduleName != null) {
                v6 = ((ModuleBasedConfiguration)configuration).getConfigurationModule().findModule(moduleName);
                if (v6 != null) {
                    var7_8 = v6;
                    var8_9 = false;
                    var9_10 = false;
                    it = var7_8;
                    $i$a$-let-RunnerAndConfigurationSettingsImpl$readExternal$1 = false;
                    PathMacroManager.getInstance((ComponentManager)it).expandPaths(element);
                }
            }
        }
        RunnerAndConfigurationSettingsImplKt.deserializeConfigurationFrom(configuration, element, this.isTemplate);
        this.wasSingletonSpecifiedExplicitly = false;
        singletonStr = element.getAttributeValue("singleton");
        var7_8 = singletonStr;
        var8_9 = false;
        var9_10 = false;
        if (var7_8 == null || var7_8.length() == 0) {
            configuration.setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        } else {
            this.wasSingletonSpecifiedExplicitly = true;
            var7_8 = singletonStr;
            var8_9 = false;
            configuration.setAllowRunningInParallel(Boolean.parseBoolean((String)var7_8) == false);
        }
        this.runnerSettings.loadState(element);
        this.configurationPerRunnerSettings.loadState(element);
        this.manager.readBeforeRunTasks(element.getChild("method"), this, configuration);
    }

    public final void writeExternal(@NotNull Element element2) {
        String string;
        boolean bl;
        char c;
        ConfigurationFactory factory2;
        CharSequence it;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        RunConfiguration configuration2 = this.getConfiguration();
        ConfigurationType configurationType = configuration2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
        if (configurationType.isManaged()) {
            if (this.isTemplate) {
                element2.setAttribute("default", "true");
            } else {
                if (!RunnerAndConfigurationSettingsImplKt.access$isNewSerializationAllowed$p(this)) {
                    element2.setAttribute("default", "false");
                }
                String string2 = StringKt.nullize$default((String)configuration2.getName(), (boolean)false, (int)1, null);
                if (string2 != null) {
                    String string3 = string2;
                    bl3 = false;
                    bl2 = false;
                    it = string3;
                    boolean bl4 = false;
                    element2.setAttribute("name", (String)it);
                }
            }
            factory2 = this.getFactory();
            ConfigurationType configurationType2 = factory2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType2, (String)"factory.type");
            element2.setAttribute("type", configurationType2.getId());
            if (!(factory2.getType() instanceof SimpleConfigurationType)) {
                element2.setAttribute("factoryName", factory2.getId());
            }
            if (this.folderName != null) {
                String string4 = this.folderName;
                Intrinsics.checkNotNull((Object)string4);
                element2.setAttribute("folderName", string4);
            }
            if (this.isEditBeforeRun) {
                element2.setAttribute("editBeforeRun", "true");
            }
            if (!this.isActivateToolWindowBeforeRun) {
                element2.setAttribute("activateToolWindowBeforeRun", "false");
            }
            if (this.wasSingletonSpecifiedExplicitly || configuration2.isAllowRunningInParallel() != factory2.getSingletonPolicy().isAllowRunningInParallel()) {
                element2.setAttribute("singleton", String.valueOf(!configuration2.isAllowRunningInParallel()));
            }
            if (this.isTemporary()) {
                element2.setAttribute("temporary", "true");
            }
        }
        RunnerAndConfigurationSettingsImplKt.serializeConfigurationInto(configuration2, element2);
        ConfigurationType configurationType3 = configuration2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType3, (String)"configuration.type");
        if (configurationType3.isManaged()) {
            this.runnerSettings.getState(element2);
            this.configurationPerRunnerSettings.getState(element2);
        }
        ConfigurationType configurationType4 = configuration2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType4, (String)"configuration.type");
        if (configurationType4.isManaged()) {
            Element element3 = this.manager.writeBeforeRunTasks(configuration2);
            if (element3 != null) {
                factory2 = element3;
                bl3 = false;
                bl2 = false;
                it = factory2;
                boolean bl5 = false;
                element2.addContent((Element)it);
            }
        }
        if (configuration2 instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration2).isModuleDirMacroSupported()) {
            RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)configuration2).getConfigurationModule();
            Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"configuration.configurationModule");
            Module module = runConfigurationModule.getModule();
            if (module != null) {
                factory2 = module;
                bl3 = false;
                bl2 = false;
                it = factory2;
                boolean bl6 = false;
                PathMacroManager.getInstance((ComponentManager)it).collapsePathsRecursively(element2);
            }
        }
        Project project = configuration2.getProject();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
        PathMacroManager macroManager = pathMacroManager;
        Project project2 = project;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String string5 = project2.getBasePath();
        if (string5 != null) {
            it = string5;
            c = '\u0000';
            bl = false;
            String it2 = it;
            boolean bl7 = false;
            string = PathUtilRt.getParentPath((String)it2);
        } else {
            string = null;
        }
        String projectParentPath = string;
        it = projectParentPath;
        c = '\u0000';
        bl = false;
        if (!(it == null || it.length() == 0)) {
            ReplacePathToMacroMap replacePathMap;
            PathMacroManager pathMacroManager2 = macroManager;
            if (!(pathMacroManager2 instanceof ProjectPathMacroManager)) {
                pathMacroManager2 = null;
            }
            ProjectPathMacroManager projectPathMacroManager2 = (ProjectPathMacroManager)pathMacroManager2;
            ReplacePathToMacroMap replacePathToMacroMap = replacePathMap = projectPathMacroManager2 != null ? projectPathMacroManager2.getReplacePathMap() : null;
            if (replacePathMap != null) {
                c = '$';
                String string6 = "PROJECT_DIR";
                boolean bl8 = false;
                replacePathMap.addReplacement(projectParentPath, String.valueOf(c) + string6 + "$/..", true);
                PathMacroManager.collapsePaths(element2, true, replacePathMap);
                return;
            }
        }
        PathMacroManager.getInstance((ComponentManager)project).collapsePathsRecursively(element2);
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element2 = new Element("configuration");
        this.writeExternal(element2);
        return element2;
    }

    /*
     * WARNING - void declaration
     */
    public void checkSettings(@Nullable Executor executor) {
        void $this$mapNotNullTo$iv$iv22;
        ProgramRunner it$iv$iv;
        ProgramRunner programRunner;
        boolean bl;
        boolean bl2;
        String it;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void warning;
        RunConfiguration configuration2 = this.getConfiguration();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ReadAction.nonBlocking((Runnable)new Runnable(configuration2, (Ref.ObjectRef)warning){
            final /* synthetic */ RunConfiguration $configuration;
            final /* synthetic */ Ref.ObjectRef $warning;

            public final void run() {
                try {
                    this.$configuration.checkConfiguration();
                }
                catch (RuntimeConfigurationException e) {
                    this.$warning.element = e;
                }
            }
            {
                this.$configuration = runConfiguration;
                this.$warning = objectRef;
            }
        }).executeSynchronously();
        if (!(configuration2 instanceof RunConfigurationBase)) {
            if ((RuntimeConfigurationException)((Object)warning.element) != null) {
                RuntimeConfigurationException runtimeConfigurationException = (RuntimeConfigurationException)((Object)warning.element);
                if (runtimeConfigurationException == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.configurations.RuntimeConfigurationException");
                }
                throw (Throwable)runtimeConfigurationException;
            }
            return;
        }
        HashSet<ProgramRunner> runners = new HashSet<ProgramRunner>();
        Iterable iterable = this.runnerSettings.getSettings().keySet();
        HashSet<ProgramRunner> hashSet = runners;
        boolean bl3 = false;
        void var7_13 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        ProgramRunner $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            it = (String)element$iv$iv;
            boolean bl5 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl2 = false;
            bl = false;
            it$iv$iv = programRunner;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        hashSet.addAll(list2);
        $this$mapNotNull$iv = this.configurationPerRunnerSettings.getSettings().keySet();
        hashSet = runners;
        boolean bl7 = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl8 = false;
            it = (String)element$iv$iv;
            boolean bl6 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl2 = false;
            bl = false;
            it$iv$iv = programRunner;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        hashSet.addAll(list2);
        Executor executor2 = executor;
        if (executor2 != null) {
            $this$mapNotNull$iv = executor2;
            boolean bl10 = false;
            boolean $this$mapNotNullTo$iv$iv22 = false;
            Iterable it2 = $this$mapNotNull$iv;
            boolean bl72 = false;
            ProgramRunner programRunner2 = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)configuration2));
            if (programRunner2 != null) {
                $this$forEach$iv$iv$iv = programRunner2;
                $i$f$forEach = false;
                boolean bl11 = false;
                ProgramRunner it3 = $this$forEach$iv$iv$iv;
                boolean bl9 = false;
                runners.add(it3);
            }
        }
        boolean runnerFound = false;
        for (ProgramRunner programRunner3 : runners) {
            RuntimeConfigurationWarning runnerWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning;
            if (executor != null && !programRunner3.canRun(executor.getId(), (RunProfile)configuration2)) continue;
            RunnerAndConfigurationSettingsImpl this_$iv = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl10 = false;
                RunConfigurationBase runConfigurationBase = (RunConfigurationBase)configuration2;
                Map map2 = this.runnerSettings.getSettings();
                ProgramRunner programRunner4 = programRunner3;
                Intrinsics.checkNotNullExpressionValue((Object)programRunner4, (String)"runner");
                runConfigurationBase.checkRunnerSettings(programRunner3, (RunnerSettings)map2.get(programRunner4.getRunnerId()), (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getSettings().get(programRunner3.getRunnerId()));
                runtimeConfigurationWarning = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning = runnerWarning = ex$iv;
            }
            if (runnerWarning != null) {
                if ((RuntimeConfigurationException)((Object)warning.element) != null) continue;
                warning.element = (RuntimeConfigurationException)((Object)runnerWarning);
                continue;
            }
            runnerFound = true;
        }
        if (executor != null && Intrinsics.areEqual((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance()) ^ true && !runnerFound) {
            throw (Throwable)new RuntimeConfigurationError(ExecutionBundle.message((String)"dialog.message.no.runners.for.configuration", (Object[])new Object[]{executor.getId(), configuration2}));
        }
        if (executor != null) {
            RuntimeConfigurationWarning runtimeConfigurationWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning2;
            RunnerAndConfigurationSettingsImpl this_$iv = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl11 = false;
                ((RunConfigurationBase)configuration2).checkSettingsBeforeRun();
                runtimeConfigurationWarning2 = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning2 = runtimeConfigurationWarning = ex$iv;
            }
            if ((RuntimeConfigurationException)((Object)warning.element) == null && runtimeConfigurationWarning != null) {
                warning.element = (RuntimeConfigurationException)((Object)runtimeConfigurationWarning);
            }
        }
        if ((RuntimeConfigurationException)((Object)warning.element) != null) {
            RuntimeConfigurationException runtimeConfigurationException = (RuntimeConfigurationException)((Object)warning.element);
            if (runtimeConfigurationException == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.configurations.RuntimeConfigurationException");
            }
            throw (Throwable)runtimeConfigurationException;
        }
    }

    private final RuntimeConfigurationWarning doCheck(Function0<Unit> check2) {
        int $i$f$doCheck = 0;
        try {
            check2.invoke();
            return null;
        }
        catch (RuntimeConfigurationWarning ex) {
            return ex;
        }
    }

    @Nullable
    public <T extends RunnerSettings> T getRunnerSettings(@NotNull ProgramRunner<T> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return (T)((RunnerSettings)this.runnerSettings.getOrCreateSettings(runner));
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getOrCreateSettings(runner);
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.getFactory().getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"factory.type");
        return configurationType;
    }

    @NotNull
    public RunnerAndConfigurationSettingsImpl clone() {
        RunConfiguration runConfiguration = this._configuration;
        Intrinsics.checkNotNull((Object)runConfiguration);
        RunnerAndConfigurationSettingsImpl copy2 = new RunnerAndConfigurationSettingsImpl(this.manager, runConfiguration.clone(), false, null, 12, null);
        copy2.importRunnerAndConfigurationSettings$intellij_platform_execution_impl(this);
        copy2.level = this.level;
        copy2.pathIfStoredInArbitraryFile = this.pathIfStoredInArbitraryFile;
        return copy2;
    }

    public final void importRunnerAndConfigurationSettings$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        this.importFromTemplate(template.runnerSettings, this.runnerSettings);
        this.importFromTemplate(template.configurationPerRunnerSettings, this.configurationPerRunnerSettings);
        this.isEditBeforeRun = template.isEditBeforeRun;
        this.isActivateToolWindowBeforeRun = template.isActivateToolWindowBeforeRun;
    }

    private final <T> void importFromTemplate(RunnerItem<T> templateItem, RunnerItem<T> item) {
        for (String runnerId : templateItem.getSettings().keySet()) {
            ProgramRunner runner;
            if (ProgramRunner.findRunnerById((String)runnerId) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)runner, (String)"ProgramRunner.findRunnerById(runnerId) ?: continue");
            T data2 = item.createSettings(runner);
            item.getSettings().put(runnerId, data2);
            if (data2 == null) continue;
            Element temp = new Element("dummy");
            if (templateItem.getSettings().get(runnerId) == null) {
                continue;
            }
            try {
                T templateSettings;
                T t = templateSettings;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.JDOMExternalizable");
                }
                ((JDOMExternalizable)t).writeExternal(temp);
                ((JDOMExternalizable)data2).readExternal(temp);
            }
            catch (WriteExternalException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
            catch (InvalidDataException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
        }
    }

    public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        this.runnerSettings.handleRunnerRemoved(runner);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof RunnerAndConfigurationSettings) {
            String string = this.getName();
            String string2 = ((RunnerAndConfigurationSettings)other).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"other.name");
            n = string.compareTo(string2);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return this.getType().getDisplayName() + ": " + (this.isTemplate ? "<template>" : this.getName()) + " (level: " + (Object)((Object)this.level) + ')';
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        SchemeState schemeState;
        RunConfiguration configuration2 = this._configuration;
        if (configuration2 == null) {
            schemeState = SchemeState.UNCHANGED;
        } else if (configuration2 instanceof UnknownRunConfiguration) {
            schemeState = ((UnknownRunConfiguration)configuration2).isDoNotStore() ? SchemeState.NON_PERSISTENT : SchemeState.UNCHANGED;
        } else {
            ConfigurationType configurationType = configuration2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
            schemeState = !configurationType.isManaged() ? SchemeState.NON_PERSISTENT : null;
        }
        return schemeState;
    }

    public final boolean needsToBeMigrated() {
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        return persistentAwareRunConfiguration != null ? persistentAwareRunConfiguration.needsToBeMigrated() : false;
    }

    @NotNull
    public final RunManagerImpl getManager() {
        return this.manager;
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager2, @Nullable RunConfiguration _configuration, boolean isTemplate, @NotNull RunConfigurationLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager2), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.manager = manager2;
        this._configuration = _configuration;
        this.isTemplate = isTemplate;
        this.level = level;
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        if (persistentAwareRunConfiguration != null) {
            persistentAwareRunConfiguration.setTemplate(this.isTemplate);
        }
        this.runnerSettings = new RunnerItem<RunnerSettings>(this, "RunnerSettings"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public RunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                return runner.createConfigurationData((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.configurationPerRunnerSettings = new RunnerItem<ConfigurationPerRunnerSettings>(this, "ConfigurationWrapper"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public ConfigurationPerRunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                return this.this$0.getConfiguration().createRunnerSettings((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.isActivateToolWindowBeforeRun = true;
    }

    public /* synthetic */ RunnerAndConfigurationSettingsImpl(RunManagerImpl runManagerImpl, RunConfiguration runConfiguration, boolean bl, RunConfigurationLevel runConfigurationLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            runConfiguration = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            runConfigurationLevel = RunConfigurationLevel.WORKSPACE;
        }
        this(runManagerImpl, runConfiguration, bl, runConfigurationLevel);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager2, @Nullable RunConfiguration _configuration, boolean isTemplate) {
        this(manager2, _configuration, isTemplate, null, 8, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager2, @Nullable RunConfiguration _configuration) {
        this(manager2, _configuration, false, null, 12, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager2) {
        this(manager2, null, false, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final String getUniqueIdFor(@NotNull RunConfiguration configuration2) {
        return Companion.getUniqueIdFor(configuration2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$InfoProvider;", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Lcom/intellij/execution/runners/ProgramRunner;)V", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getConfigurationSettings", "()Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getRunner", "()Lcom/intellij/execution/runners/ProgramRunner;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getRunnerSettings", "()Lcom/intellij/execution/configurations/RunnerSettings;", "intellij.platform.execution.impl"})
    private final class InfoProvider
    implements ConfigurationInfoProvider {
        @NotNull
        private final ProgramRunner<?> runner;

        @NotNull
        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.getConfiguration();
        }

        @Nullable
        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.getRunner());
        }

        @Nullable
        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.getRunner());
        }

        @NotNull
        public ProgramRunner<?> getRunner() {
            return this.runner;
        }

        public InfoProvider(ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            this.runner = runner;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H&\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0019\u0010\u001b\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000fJ\u0012\u0010\u001e\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0007j\b\u0012\u0004\u0012\u00020\u0004`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "T", "", "childTagName", "", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Ljava/lang/String;)V", "loadedIds", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "settings", "", "getSettings", "()Ljava/util/Map;", "unloadedSettings", "", "Lorg/jdom/Element;", "add", "", "state", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "data", "(Lorg/jdom/Element;Lcom/intellij/execution/runners/ProgramRunner;Ljava/lang/Object;)V", "createSettings", "(Lcom/intellij/execution/runners/ProgramRunner;)Ljava/lang/Object;", "findRunner", "runnerId", "getOrCreateSettings", "getState", "element", "handleRunnerRemoved", "loadState", "intellij.platform.execution.impl"})
    private abstract class RunnerItem<T> {
        @NotNull
        private final Map<String, T> settings;
        private List<Element> unloadedSettings;
        private final HashSet<String> loadedIds;
        private final String childTagName;

        @NotNull
        public final Map<String, T> getSettings() {
            return this.settings;
        }

        public final void loadState(@NotNull Element element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            this.settings.clear();
            if (this.unloadedSettings != null) {
                List<Element> list2 = this.unloadedSettings;
                Intrinsics.checkNotNull(list2);
                list2.clear();
            }
            this.loadedIds.clear();
            Iterator iterator2 = element2.getChildren(this.childTagName).iterator();
            while (iterator2.hasNext()) {
                ProgramRunner<?> runner;
                ProgramRunner<?> programRunner;
                Element state = (Element)iterator2.next();
                if (state.getAttributeValue("RunnerId") != null) {
                    String string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    programRunner = this.findRunner(it);
                } else {
                    programRunner = runner = null;
                }
                if (runner == null) {
                    iterator2.remove();
                }
                Element element3 = state;
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"state");
                this.add(element3, runner, runner == null ? null : (T)this.createSettings(runner));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ProgramRunner<?> findRunner(String runnerId) {
            ProgramRunner programRunner;
            void $this$filterTo$iv$iv;
            ExtensionPointName extensionPointName = ProgramRunner.PROGRAM_RUNNER_EP;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ProgramRunner.PROGRAM_RUNNER_EP");
            Iterable iterable = extensionPointName.getIterable();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"ProgramRunner.PROGRAM_RUNNER_EP.iterable");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProgramRunner it = (ProgramRunner)element$iv$iv;
                boolean bl = false;
                ProgramRunner programRunner2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)programRunner2, (String)"it");
                if (!Intrinsics.areEqual((Object)runnerId, (Object)programRunner2.getRunnerId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List runnersById = (List)destination$iv$iv;
            if (runnersById.isEmpty()) {
                programRunner = null;
            } else if (runnersById.size() == 1) {
                programRunner = (ProgramRunner)CollectionsKt.firstOrNull((List)runnersById);
            } else {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error("More than one runner found for ID: " + runnerId);
                ExtensionPointName extensionPointName2 = Executor.EXECUTOR_EXTENSION_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName2, (String)"Executor.EXECUTOR_EXTENSION_NAME");
                for (Executor executor : extensionPointName2.getExtensionList()) {
                    Object v6;
                    block7: {
                        Iterable $this$firstOrNull$iv = runnersById;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ProgramRunner it = (ProgramRunner)element$iv;
                            boolean bl = false;
                            Executor executor2 = executor;
                            Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"executor");
                            if (!it.canRun(executor2.getId(), (RunProfile)RunnerAndConfigurationSettingsImpl.this.getConfiguration())) continue;
                            v6 = element$iv;
                            break block7;
                        }
                        v6 = null;
                    }
                    ProgramRunner programRunner3 = v6;
                    if (programRunner3 == null) continue;
                    iterable2 = programRunner3;
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterable it = iterable2;
                    boolean bl3 = false;
                    return it;
                }
                programRunner = null;
            }
            return programRunner;
        }

        /*
         * WARNING - void declaration
         */
        public final void getState(@NotNull Element element2) {
            Element state;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            SmartList runnerSettings2 = new SmartList();
            for (String runnerId : this.settings.keySet()) {
                T settings2 = this.settings.get(runnerId);
                boolean wasLoaded = this.loadedIds.contains(runnerId);
                if (settings2 == null && !wasLoaded) continue;
                state = new Element(this.childTagName);
                if (settings2 != null) {
                    ((JDOMExternalizable)settings2).writeExternal(state);
                }
                if (!wasLoaded && JDOMUtil.isEmpty((Element)state)) continue;
                state.setAttribute("RunnerId", runnerId);
                runnerSettings2.add((Object)state);
            }
            List<Element> list2 = this.unloadedSettings;
            if (list2 != null) {
                Iterable $this$mapTo$iv = list2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    state = (Element)item$iv;
                    Collection collection = (Collection)runnerSettings2;
                    boolean bl = false;
                    Element element3 = it.clone();
                    collection.add(element3);
                }
                SmartList cfr_ignored_0 = (SmartList)((Collection)runnerSettings2);
            }
            CollectionsKt.sortWith((List)((List)runnerSettings2), (Comparator)getState.2.INSTANCE);
            for (Element runnerSetting : runnerSettings2) {
                element2.addContent(runnerSetting);
            }
        }

        @Nullable
        public abstract T createSettings(@NotNull ProgramRunner<?> var1);

        private final void add(Element state, ProgramRunner<?> runner, T data2) {
            if (runner == null) {
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list2 = this.unloadedSettings;
                Intrinsics.checkNotNull(list2);
                Element element2 = JDOMUtil.internElement((Element)state);
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"JDOMUtil.internElement(state)");
                list2.add(element2);
                return;
            }
            if (data2 != null) {
                ((JDOMExternalizable)data2).readExternal(state);
            }
            String string = runner.getRunnerId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runner.runnerId");
            this.settings.put(string, data2);
            this.loadedIds.add(runner.getRunnerId());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final T getOrCreateSettings(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            try {
                Object object;
                void $this$getOrPut$iv;
                Map<String, T> map2 = this.settings;
                String string = runner.getRunnerId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runner.runnerId");
                String key$iv = string;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    T answer$iv = this.createSettings(runner);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (T)object;
            }
            catch (AbstractMethodError e) {
                Logger logger = RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl();
                StringBuilder stringBuilder = new StringBuilder().append("Update failed for: ");
                ConfigurationType configurationType = RunnerAndConfigurationSettingsImpl.this.getConfiguration().getType();
                Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
                PluginException.logPluginError((Logger)logger, (String)stringBuilder.append(configurationType.getDisplayName()).append(", runner: ").append(runner.getRunnerId()).toString(), (Throwable)e, runner.getClass());
                return null;
            }
        }

        public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            RunnerSettings runnerSettings2 = (RunnerSettings)this.settings.get(runner.getRunnerId());
            if (runnerSettings2 != null) {
                this.settings.remove(runner.getRunnerId());
                Element element2 = new Element(this.childTagName);
                runnerSettings2.writeExternal(element2);
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list2 = this.unloadedSettings;
                Intrinsics.checkNotNull(list2);
                Element element3 = JDOMUtil.internElement((Element)element2);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"JDOMUtil.internElement(element)");
                list2.add(element3);
                this.loadedIds.remove(runner.getRunnerId());
            }
        }

        public RunnerItem(String childTagName) {
            Intrinsics.checkNotNullParameter((Object)childTagName, (String)"childTagName");
            this.childTagName = childTagName;
            this.settings = new HashMap();
            this.loadedIds = new HashSet();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$Companion;", "", "()V", "getUniqueIdFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getUniqueIdFor(@NotNull RunConfiguration configuration2) {
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            ConfigurationType configurationType = configuration2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
            ConfigurationType type = configurationType;
            if (!type.isManaged()) {
                String string = configuration2.getId();
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    String string3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                    return string3;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            ConfigurationType configurationType2 = configuration2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType2, (String)"configuration.type");
            StringBuilder stringBuilder2 = stringBuilder.append(configurationType2.getDisplayName()).append('.').append(configuration2.getName());
            RunConfiguration runConfiguration = configuration2;
            if (!(runConfiguration instanceof UnknownRunConfiguration)) {
                runConfiguration = null;
            }
            UnknownRunConfiguration unknownRunConfiguration = (UnknownRunConfiguration)runConfiguration;
            return stringBuilder2.append(unknownRunConfiguration != null ? Integer.valueOf(unknownRunConfiguration.getUniqueID()) : "").toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

