/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.segmentedRunDebugWidget;

import com.intellij.application.Topics;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.segmentedRunDebugWidget.StateWidgetManager;
import com.intellij.execution.stateExecutionWidget.StateWidgetProcess;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u0000 52\u00020\u0001:\u000256B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u0007J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fJ\u0010\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u000bJ\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020\u000bJ\b\u0010*\u001a\u00020\u001aH\u0002J=\u0010+\u001a\u00020\u001a\"\u0004\b\u0000\u0010,2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u0002H,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u00062\u0006\u0010.\u001a\u0002H,2\u0006\u0010/\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u001aH\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/StateWidgetManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activeProcessByConfiguration", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "", "Lcom/intellij/execution/stateExecutionWidget/StateWidgetProcess;", "executionByConfiguration", "", "executions", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "executionsByExecutorId", "", "processByExecutorId", "processById", "processIdByExecutionId", "processes", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "terminatedBeforeStart", "", "collect", "", "process", "executorId", "env", "getActiveExecutionEnvironments", "", "getActiveProcesses", "getActiveProcessesBySettings", "configuration", "getActiveProcessesIDs", "getExecutionByExecutionId", "executionId", "getExecutionBySettings", "getExecutionsCount", "", "getProcessByExecutionId", "logging", "remove", "K", "map", "key", "id", "(Ljava/util/Map;Ljava/lang/Object;J)V", "start", "stop", "update", "updateRunningConfiguration", "Companion", "StateWidgetManagerListener", "intellij.platform.execution.impl"})
public final class StateWidgetManager {
    private final Map<String, StateWidgetProcess> processById;
    private final Map<String, StateWidgetProcess> processByExecutorId;
    private final Map<Long, ExecutionEnvironment> executions;
    private final Map<Long, String> processIdByExecutionId;
    private final Map<String, Set<Long>> executionsByExecutorId;
    private final Map<RunnerAndConfigurationSettings, Set<StateWidgetProcess>> activeProcessByConfiguration;
    private final Map<RunnerAndConfigurationSettings, Set<Long>> executionByConfiguration;
    private final List<StateWidgetProcess> processes;
    private final List<Long> terminatedBeforeStart;
    @NotNull
    private final Project project;
    private static final Logger LOGGER;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Topic<StateWidgetManagerListener> TOPIC;
    @NotNull
    public static final Companion Companion;

    private final void start(String executorId, ExecutionEnvironment env) {
        Executor executor = env.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
        ExecutorGroup executorGroup = ExecutorGroup.Companion.getGroupIfProxy(executor);
        if (executorGroup != null) {
            ExecutorGroup executorGroup2 = executorGroup;
            boolean bl = false;
            boolean bl2 = false;
            ExecutorGroup executorGroup3 = executorGroup2;
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.processes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateWidgetProcess process2 = (StateWidgetProcess)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)process2.getExecutorId(), (Object)executorGroup3.getId())) continue;
                this.collect(process2, executorId, env);
                return;
            }
            return;
        }
        Iterable $this$forEach$iv = this.processes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateWidgetProcess process3 = (StateWidgetProcess)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)process3.getExecutorId(), (Object)executorId)) continue;
            this.collect(process3, executorId, env);
            return;
        }
    }

    private final void stop(String executorId, ExecutionEnvironment env) {
        this.executions.remove(env.getExecutionId());
        this.processIdByExecutionId.remove(env.getExecutionId());
        this.remove(this.executionsByExecutorId, executorId, env.getExecutionId());
        this.remove(this.executionByConfiguration, env.getRunnerAndConfigurationSettings(), env.getExecutionId());
        this.update();
    }

    private final <K> void remove(Map<K, Set<Long>> map2, K key, long id2) {
        block1: {
            Set<Long> set2 = map2.get(key);
            if (set2 == null) break block1;
            Set<Long> set3 = set2;
            boolean bl = false;
            boolean bl2 = false;
            Set<Long> it = set3;
            boolean bl3 = false;
            it.remove(id2);
            if (it.isEmpty()) {
                map2.remove(key);
            }
        }
    }

    private final void collect(StateWidgetProcess process2, String executorId, ExecutionEnvironment env) {
        this.executions.put(env.getExecutionId(), env);
        this.executionsByExecutorId.computeIfAbsent(executorId, collect.1.INSTANCE).add(env.getExecutionId());
        this.processIdByExecutionId.put(env.getExecutionId(), process2.getID());
        this.processByExecutorId.put(executorId, process2);
        this.executionByConfiguration.computeIfAbsent(env.getRunnerAndConfigurationSettings(), collect.2.INSTANCE).add(env.getExecutionId());
        this.update();
    }

    private final void update() {
        this.updateRunningConfiguration();
        StateWidgetManager.Companion.fireConfigurationChanged();
        this.logging();
    }

    private final void logging() {
        if (LOGGER.isTraceEnabled()) {
            Map.Entry<Long, ExecutionEnvironment> entry2;
            Map.Entry<Long, ExecutionEnvironment> it;
            Map.Entry<Long, ExecutionEnvironment> element$iv;
            LOGGER.trace("executions:" + (this.executions.isEmpty() ? "empty" : ""));
            Map<Object, Object> $this$forEach$iv = this.executions;
            boolean $i$f$forEach = false;
            Map<Long, ExecutionEnvironment> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<Long, ExecutionEnvironment>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder().append("       ");
                Executor executor = it.getValue().getExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"it.value.executor");
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = it.getValue().getRunnerAndConfigurationSettings();
                LOGGER.trace(stringBuilder.append(executor.getActionName()).append(": settings ").append(runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getName() : null).append(", id: ").append(((Number)it.getKey()).longValue()).toString());
            }
            LOGGER.trace("processIdByExecutionId:" + (this.processIdByExecutionId.isEmpty() ? "empty" : ""));
            $this$forEach$iv = this.processIdByExecutionId;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl = false;
            iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl3 = false;
                LOGGER.trace("       " + ((Number)it.getKey()).longValue() + ": " + (String)it.getValue());
            }
            LOGGER.trace("executionsByExecutorId:" + (this.executionsByExecutorId.isEmpty() ? "empty" : ""));
            $this$forEach$iv = this.executionsByExecutorId;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl = false;
            iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry2 = element$iv = iterator2.next();
                boolean bl4 = false;
                LOGGER.trace("       " + (String)((Object)entry2.getKey()) + ": " + CollectionsKt.joinToString$default((Iterable)((Iterable)entry2.getValue()), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
            }
            LOGGER.trace("activeProcessByConfiguration:" + (this.activeProcessByConfiguration.isEmpty() ? "empty" : ""));
            $this$forEach$iv = this.activeProcessByConfiguration;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl = false;
            iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry2 = element$iv = iterator2.next();
                boolean bl5 = false;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)entry2.getKey();
                LOGGER.trace("       " + (runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getName() : null) + ": " + CollectionsKt.joinToString$default((Iterable)((Iterable)entry2.getValue()), (CharSequence)"|", null, null, (int)0, null, (Function1)logging.4.1.INSTANCE, (int)30, null));
            }
            LOGGER.trace("executionByConfiguration:" + (this.executionByConfiguration.isEmpty() ? "empty" : ""));
            $this$forEach$iv = this.executionByConfiguration;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl = false;
            iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry2 = element$iv = iterator2.next();
                boolean bl6 = false;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)entry2.getKey();
                LOGGER.trace("       " + (runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getName() : null) + ": " + CollectionsKt.joinToString$default((Iterable)((Iterable)entry2.getValue()), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    private final void updateRunningConfiguration() {
        this.activeProcessByConfiguration.clear();
        Iterable $this$forEach$iv = this.executions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateWidgetProcess stateWidgetProcess;
            ExecutionEnvironment env = (ExecutionEnvironment)element$iv;
            boolean bl = false;
            Executor executor = env.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
            if (this.processByExecutorId.get(executor.getId()) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            StateWidgetProcess process2 = stateWidgetProcess;
            boolean bl4 = false;
            this.activeProcessByConfiguration.computeIfAbsent(env.getRunnerAndConfigurationSettings(), updateRunningConfiguration.1.1.1.INSTANCE).add(process2);
        }
    }

    public final int getExecutionsCount() {
        Map<Long, ExecutionEnvironment> map2 = this.executions;
        boolean bl = false;
        return map2.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getActiveProcessesIDs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getActiveProcesses();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StateWidgetProcess stateWidgetProcess = (StateWidgetProcess)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getID();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<StateWidgetProcess> getActiveProcesses() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.executionsByExecutorId.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            StateWidgetProcess stateWidgetProcess;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.processByExecutorId.get(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            StateWidgetProcess it$iv$iv = stateWidgetProcess;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final Set<StateWidgetProcess> getActiveProcessesBySettings(@NotNull RunnerAndConfigurationSettings configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return this.activeProcessByConfiguration.get(configuration2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Set<ExecutionEnvironment> getExecutionBySettings(@NotNull RunnerAndConfigurationSettings configuration2) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Set<Long> set3 = this.executionByConfiguration.get(configuration2);
        if (set3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = set3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ExecutionEnvironment executionEnvironment;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                long it = ((Number)element$iv$iv).longValue();
                boolean bl2 = false;
                if (this.executions.get(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ExecutionEnvironment it$iv$iv = executionEnvironment;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set2 = null;
        }
        return set2;
    }

    @Nullable
    public final ExecutionEnvironment getExecutionByExecutionId(long executionId) {
        return this.executions.get(executionId);
    }

    @Nullable
    public final StateWidgetProcess getProcessByExecutionId(long executionId) {
        StateWidgetProcess stateWidgetProcess;
        String string = this.processIdByExecutionId.get(executionId);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            stateWidgetProcess = this.processById.get(it);
        } else {
            stateWidgetProcess = null;
        }
        return stateWidgetProcess;
    }

    @NotNull
    public final Set<ExecutionEnvironment> getActiveExecutionEnvironments() {
        return CollectionsKt.toSet((Iterable)this.executions.values());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public StateWidgetManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        this.processById = new LinkedHashMap();
        bl = false;
        this.processByExecutorId = new LinkedHashMap();
        bl = false;
        this.executions = new LinkedHashMap();
        bl = false;
        this.processIdByExecutionId = new LinkedHashMap();
        bl = false;
        this.executionsByExecutorId = new LinkedHashMap();
        bl = false;
        this.activeProcessByConfiguration = new LinkedHashMap();
        bl = false;
        this.executionByConfiguration = new LinkedHashMap();
        this.processes = StateWidgetProcess.Companion.getProcesses();
        bl = false;
        this.terminatedBeforeStart = new ArrayList();
        Iterable $this$forEach$iv = this.processes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateWidgetProcess it = (StateWidgetProcess)element$iv;
            boolean bl2 = false;
            this.processById.put(it.getID(), it);
        }
        if (StateWidgetProcess.Companion.isAvailable()) {
            Topics.subscribe((Topic)ExecutionManager.EXECUTION_TOPIC, (Disposable)((Disposable)this.project), (Object)new ExecutionListener(){

                public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env, executorId, handler2){
                        final /* synthetic */ 2 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;
                        final /* synthetic */ String $executorId;
                        final /* synthetic */ ProcessHandler $handler;

                        public final void run() {
                            if (StateWidgetManager.access$getLOGGER$cp().isTraceEnabled()) {
                                StateWidgetManager.access$getLOGGER$cp().trace("=============Execution started: " + this.$env.getExecutionId() + " executor: " + this.$executorId + (this.$handler.isProcessTerminated() ? "terminated" : (this.$handler.isProcessTerminating() ? " terminating" : "")) + ' ');
                            }
                            if (StateWidgetManager.access$getTerminatedBeforeStart$p(this.this$0.this).contains(this.$env.getExecutionId())) {
                                StateWidgetManager.access$getLOGGER$cp().warn("processStarted notification for a process that has already been terminated. " + this.$env.getExecutionId() + " executor: " + this.$executorId);
                                return;
                            }
                            StateWidgetManager.access$start(this.this$0.this, this.$executorId, this.$env);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                            this.$executorId = string;
                            this.$handler = processHandler2;
                        }
                    });
                }

                public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env, executorId, exitCode, handler2){
                        final /* synthetic */ 2 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;
                        final /* synthetic */ String $executorId;
                        final /* synthetic */ int $exitCode;
                        final /* synthetic */ ProcessHandler $handler;

                        public final void run() {
                            if (StateWidgetManager.access$getLOGGER$cp().isTraceEnabled()) {
                                StateWidgetManager.access$getLOGGER$cp().trace("=============Execution stopped: " + this.$env.getExecutionId() + ", " + "executor: " + this.$executorId + ", " + "exitCode: " + this.$exitCode + ", " + (this.$handler.isProcessTerminated() ? "terminated" : (this.$handler.isProcessTerminating() ? " terminating" : "")) + ' ');
                            }
                            if (StateWidgetManager.access$getExecutions$p(this.this$0.this).get(this.$env.getExecutionId()) == null) {
                                StateWidgetManager.access$getTerminatedBeforeStart$p(this.this$0.this).add(this.$env.getExecutionId());
                                StateWidgetManager.access$getLOGGER$cp().warn("processTerminated notification before processStarted notification. " + this.$env.getExecutionId() + " executor: " + this.$executorId);
                                return;
                            }
                            StateWidgetManager.access$stop(this.this$0.this, this.$executorId, this.$env);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                            this.$executorId = string;
                            this.$exitCode = n;
                            this.$handler = processHandler2;
                        }
                    });
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(StateWidgetManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(StateWidgetManager::class.java)");
        LOGGER = logger;
        TOPIC = new Topic(StateWidgetManagerListener.class, Topic.BroadcastDirection.NONE);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ List access$getTerminatedBeforeStart$p(StateWidgetManager $this) {
        return $this.terminatedBeforeStart;
    }

    public static final /* synthetic */ void access$start(StateWidgetManager $this, String executorId, ExecutionEnvironment env) {
        $this.start(executorId, env);
    }

    public static final /* synthetic */ Map access$getExecutions$p(StateWidgetManager $this) {
        return $this.executions;
    }

    public static final /* synthetic */ void access$stop(StateWidgetManager $this, String executorId, ExecutionEnvironment env) {
        $this.stop(executorId, env);
    }

    @JvmStatic
    @NotNull
    public static final StateWidgetManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    private static final void fireConfigurationChanged() {
        StateWidgetManager.Companion.fireConfigurationChanged();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/StateWidgetManager$StateWidgetManagerListener;", "", "configurationChanged", "", "intellij.platform.execution.impl"})
    @ApiStatus.Internal
    public static interface StateWidgetManagerListener {
        public void configurationChanged();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/StateWidgetManager$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/execution/segmentedRunDebugWidget/StateWidgetManager$StateWidgetManagerListener;", "kotlin.jvm.PlatformType", "fireConfigurationChanged", "", "getInstance", "Lcom/intellij/execution/segmentedRunDebugWidget/StateWidgetManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final StateWidgetManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(StateWidgetManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (StateWidgetManager)object;
        }

        @JvmStatic
        private final void fireConfigurationChanged() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((StateWidgetManagerListener)application.getMessageBus().syncPublisher(TOPIC)).configurationChanged();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

