/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TargetCounterUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("run.target.events", 1);
    private static final EventId1<String> TARGET_CREATION_BEGAN_EVENT;
    private static final EventId2<String, Integer> TARGET_CREATION_CANCELLED_EVENT;
    private static final EventId1<String> TARGET_CREATION_SUCCEEDED_EVENT;

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void reportTargetCreationBegan(@NotNull Project project, @NotNull String typeId) {
        if (project == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(0);
        }
        if (typeId == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(1);
        }
        TARGET_CREATION_BEGAN_EVENT.log(project, (Object)typeId);
    }

    public static void reportTargetCreationCancelled(@NotNull Project project, @NotNull String typeId, int currentStep) {
        if (project == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(2);
        }
        if (typeId == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(3);
        }
        TARGET_CREATION_CANCELLED_EVENT.log(project, (Object)typeId, (Object)currentStep);
    }

    public static void reportTargetCreationSucceeded(@NotNull Project project, @NotNull String typeId) {
        if (project == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(4);
        }
        if (typeId == null) {
            TargetCounterUsagesCollector.$$$reportNull$$$0(5);
        }
        TARGET_CREATION_SUCCEEDED_EVENT.log(project, (Object)typeId);
    }

    static {
        StringEventField targetTypeField = EventFields.StringValidatedByCustomRule((String)"type", (String)"run_target");
        TARGET_CREATION_BEGAN_EVENT = GROUP.registerEvent("creation.began", (EventField)targetTypeField);
        TARGET_CREATION_CANCELLED_EVENT = GROUP.registerEvent("creation.cancelled", (EventField)targetTypeField, (EventField)EventFields.Int((String)"step_number"));
        TARGET_CREATION_SUCCEEDED_EVENT = GROUP.registerEvent("creation.succeeded", (EventField)targetTypeField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/target/TargetCounterUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportTargetCreationBegan";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportTargetCreationCancelled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportTargetCreationSucceeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

