/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;

public final class LvcsHelper {
    private static final Color RED = new JBColor(new Color(250, 220, 220), new Color(104, 67, 67));
    private static final Color GREEN = new JBColor(new Color(220, 250, 220), new Color(44, 66, 60));

    public static void addLabel(TestFrameworkRunningModel model2) {
        String name;
        int color;
        AbstractTestProxy root = model2.getRoot();
        if (root.isInterrupted()) {
            return;
        }
        TestConsoleProperties consoleProperties = model2.getProperties();
        String configName = consoleProperties.getConfiguration().getName();
        if (root.isPassed() || root.isIgnored()) {
            color = GREEN.getRGB();
            name = ExecutionBundle.message((String)"junit.running.info.tests.passed.with.test.name.label", (Object[])new Object[]{configName});
        } else {
            color = RED.getRGB();
            name = ExecutionBundle.message((String)"junit.running.info.tests.failed.with.test.name.label", (Object[])new Object[]{configName});
        }
        Project project = consoleProperties.getProject();
        if (project.isDisposed()) {
            return;
        }
        LocalHistory.getInstance().putSystemLabel(project, name, color);
    }
}

