/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.reference.SoftReference;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerRunDashboardCustomizer
extends RunDashboardCustomizer {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED_TEXT);
    private static final Key<NodeUpdaterEventsListener> EVENTS_LISTENER_KEY = Key.create((String)"TestResultsEventsListener");

    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings2, @Nullable RunContentDescriptor descriptor2) {
        if (settings2 == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return descriptor2 != null && descriptor2.getExecutionConsole() instanceof SMTRunnerConsoleView;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation2, @NotNull RunDashboardRunConfigurationNode node2) {
        RunContentDescriptor descriptor2;
        if (presentation2 == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (node2 == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(2);
        }
        if ((descriptor2 = node2.getDescriptor()) == null) {
            return false;
        }
        ExecutionConsole executionConsole = descriptor2.getExecutionConsole();
        if (!(executionConsole instanceof SMTRunnerConsoleView)) {
            return false;
        }
        SMTestRunnerResultsForm resultsViewer = ((SMTRunnerConsoleView)executionConsole).getResultsViewer();
        Content content2 = node2.getContent();
        if (content2 != null && node2 instanceof AbstractTreeNode) {
            NodeUpdaterEventsListener eventsListener = (NodeUpdaterEventsListener)content2.getUserData(EVENTS_LISTENER_KEY);
            if (eventsListener == null) {
                eventsListener = new NodeUpdaterEventsListener();
                resultsViewer.addEventsListener(eventsListener);
                content2.putUserData(EVENTS_LISTENER_KEY, (Object)eventsListener);
                NodeUpdaterEventsListener listener2 = eventsListener;
                Disposer.register((Disposable)resultsViewer, () -> {
                    if (content2.getUserData(EVENTS_LISTENER_KEY) == listener2) {
                        content2.putUserData(EVENTS_LISTENER_KEY, null);
                    }
                });
            }
            eventsListener.setNode((AbstractTreeNode)node2);
        }
        SMTestProxy.SMRootTestProxy rootNode = resultsViewer.getTestsRootNode();
        TestTreeRenderer renderer2 = new TestTreeRenderer(resultsViewer.getProperties());
        if (rootNode.isLeaf()) {
            TestsPresentationUtil.formatRootNodeWithoutChildren(rootNode, renderer2);
        } else {
            TestsPresentationUtil.formatRootNodeWithChildren(rootNode, renderer2);
        }
        if (renderer2.getIcon() != null) {
            presentation2.setIcon(renderer2.getIcon());
        }
        SMTRunnerRunDashboardCustomizer.addTestSummary(presentation2, rootNode);
        return true;
    }

    private static void addTestSummary(@NotNull PresentationData presentation2, @NotNull SMTestProxy.SMRootTestProxy rootNode) {
        if (presentation2 == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(3);
        }
        if (rootNode == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(4);
        }
        if (rootNode.isLeaf()) {
            return;
        }
        TestsUIUtil.TestResultPresentation testResultPresentation = new TestsUIUtil.TestResultPresentation(rootNode).getPresentation();
        int failed = testResultPresentation.getFailedCount();
        int ignored = testResultPresentation.getIgnoredCount();
        int passed = testResultPresentation.getPassedCount();
        int total = passed + failed + testResultPresentation.getNotStartedCount();
        if (total == 0) {
            return;
        }
        presentation2.addText(" [", SimpleTextAttributes.GRAY_ATTRIBUTES);
        boolean addSeparator = false;
        if (failed > 0) {
            presentation2.addText(TestRunnerBundle.message("tests.result.failed.count", failed), ERROR_ATTRIBUTES);
            addSeparator = true;
        }
        if (passed > 0 || ignored + failed == 0) {
            if (addSeparator) {
                presentation2.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation2.addText(TestRunnerBundle.message("tests.result.passed.count", passed), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            addSeparator = true;
        }
        if (ignored > 0) {
            if (addSeparator) {
                presentation2.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation2.addText(TestRunnerBundle.message("tests.result.ignored.count", ignored), IGNORE_ATTRIBUTES);
        }
        presentation2.addText(TestRunnerBundle.message("tests.result.total.count", total) + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTRunnerRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestSummary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodeUpdaterEventsListener
    implements TestResultsViewer.EventsListener {
        private WeakReference<AbstractTreeNode<?>> myNodeReference;

        private NodeUpdaterEventsListener() {
        }

        @Override
        public void onTestingFinished(@NotNull TestResultsViewer sender) {
            if (sender == null) {
                NodeUpdaterEventsListener.$$$reportNull$$$0(0);
            }
            this.update();
        }

        @Override
        public void onTestNodeAdded(@NotNull TestResultsViewer sender, @NotNull SMTestProxy test) {
            if (sender == null) {
                NodeUpdaterEventsListener.$$$reportNull$$$0(1);
            }
            if (test == null) {
                NodeUpdaterEventsListener.$$$reportNull$$$0(2);
            }
            this.update();
        }

        void setNode(AbstractTreeNode<?> node2) {
            this.myNodeReference = new WeakReference(node2);
        }

        private void update() {
            AbstractTreeNode node2 = (AbstractTreeNode)SoftReference.dereference(this.myNodeReference);
            if (node2 != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)node2.getProject())).submit(() -> ((AbstractTreeNode)node2).update());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sender";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "test";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTRunnerRunDashboardCustomizer$NodeUpdaterEventsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTestingFinished";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTestNodeAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

