/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/testframework/sm/runner/Shortener;", "", "attributes", "", "", "currentLength", "", "margin", "minValueLengthToCut", "(Ljava/util/Map;III)V", "getCurrentLength", "()I", "setCurrentLength", "(I)V", "shortened", "", "shortenAttribute", "", "attribute", "intellij.platform.smRunner"})
final class Shortener {
    private final Set<String> shortened;
    private final Map<String, String> attributes;
    private int currentLength;
    private final int margin;
    private final int minValueLengthToCut;

    public final void shortenAttribute(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (this.shortened.contains(attribute)) {
            return;
        }
        String string = this.attributes.get(attribute);
        if (string == null) {
            return;
        }
        String value2 = string;
        if (value2.length() <= this.minValueLengthToCut) {
            return;
        }
        int lenBefore = value2.length();
        String string2 = new StringBuilder(value2).replace(this.margin, value2.length() - this.margin, "<...>").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(value).rep\u2026gin, ELLIPSIS).toString()");
        String newValue2 = string2;
        this.currentLength -= lenBefore - newValue2.length();
        this.attributes.put(attribute, newValue2);
        this.shortened.add(attribute);
    }

    public final int getCurrentLength() {
        return this.currentLength;
    }

    public final void setCurrentLength(int n) {
        this.currentLength = n;
    }

    public Shortener(@NotNull Map<String, String> attributes2, int currentLength, int margin, int minValueLengthToCut) {
        Intrinsics.checkNotNullParameter(attributes2, (String)"attributes");
        this.attributes = attributes2;
        this.currentLength = currentLength;
        this.margin = margin;
        this.minValueLengthToCut = minValueLengthToCut;
        boolean bl = false;
        this.shortened = new LinkedHashSet();
    }
}

