/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import javax.swing.Icon;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractImportTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AbstractImportTestsAction.class);
    public static final String TEST_HISTORY_SIZE = "test_history_size";

    public AbstractImportTestsAction(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description2, @Nullable Icon icon2) {
        super(text2, description2, icon2);
    }

    public static int getHistorySize() {
        int historySize;
        try {
            historySize = Math.max(0, Integer.parseInt(PropertiesComponent.getInstance().getValue(TEST_HISTORY_SIZE, "10")));
        }
        catch (NumberFormatException e) {
            historySize = 10;
        }
        return historySize;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractImportTestsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    @Nullable
    protected abstract VirtualFile getFile(@NotNull Project var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractImportTestsAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        VirtualFile file2 = this.getFile(project);
        if (file2 == null) {
            return;
        }
        AbstractImportTestsAction.doImport(project, file2, null);
    }

    public static void doImport(Project project, VirtualFile file2, Long executionId) {
        try {
            RunConfiguration initialConfiguration;
            ProgramRunner runner;
            ImportRunProfile profile = new ImportRunProfile(file2, project);
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)profile);
            ExecutionTarget target2 = profile.getTarget();
            if (target2 != null) {
                builder2 = builder2.target(target2);
            }
            if (executionId != null) {
                builder2 = builder2.executionId(executionId.longValue());
            }
            ProgramRunner programRunner = runner = (initialConfiguration = profile.getInitialConfiguration()) != null ? ProgramRunner.getRunner((String)executor.getId(), (RunProfile)initialConfiguration) : null;
            if (runner != null) {
                builder2.runner(runner);
            }
            builder2.buildAndExecute();
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)SmRunnerBundle.message("sm.test.runner.abstract.import.test.error.title", new Object[0]));
        }
    }

    public static void adjustHistory(Project project) {
        int historySize = AbstractImportTestsAction.getHistorySize();
        File[] files2 = TestStateStorage.getTestHistoryRoot(project).listFiles((dir, name) -> name.endsWith(".xml"));
        if (files2 != null && files2.length >= historySize + 1) {
            Arrays.sort(files2, (o1, o2) -> {
                long l2;
                long l1 = o1.lastModified();
                if (l1 == (l2 = o2.lastModified())) {
                    return FileUtil.compareFiles((File)o1, (File)o2);
                }
                return l1 < l2 ? -1 : 1;
            });
            FileUtil.delete((File)files2[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ImportRunProfile
    implements RunProfile {
        private final VirtualFile myFile;
        private final Project myProject;
        private RunConfiguration myConfiguration;
        private boolean myImported;
        private String myTargetId;

        public ImportRunProfile(VirtualFile file2, final Project project) {
            class TerminateParsingException
            extends SAXException {
                TerminateParsingException() {
                }
            }
            this.myFile = file2;
            this.myProject = project;
            try (BufferedInputStream inputStream22 = new BufferedInputStream(new FileInputStream(VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile)));){
                SAXParserFactory factory2 = SAXParserFactory.newInstance();
                factory2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory2.newSAXParser().parse((InputStream)inputStream22, new DefaultHandler(){
                    boolean isConfigContent = false;
                    final StringBuilder builder = new StringBuilder();

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes2) throws SAXException {
                        if (qName.equals("root")) {
                            throw new TerminateParsingException();
                        }
                        if (qName.equals("config")) {
                            this.isConfigContent = true;
                        }
                        if (this.isConfigContent) {
                            this.builder.append("<").append(qName);
                            for (int i2 = 0; i2 < attributes2.getLength(); ++i2) {
                                this.builder.append(" ").append(attributes2.getQName(i2)).append("=\"").append(JDOMUtil.escapeText((String)attributes2.getValue(i2))).append("\"");
                            }
                            this.builder.append(">");
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start2, int length) {
                        if (this.isConfigContent) {
                            this.builder.append(ch, start2, length);
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.isConfigContent) {
                            this.builder.append("</").append(qName).append(">");
                        }
                        if (qName.equals("config")) {
                            this.isConfigContent = false;
                            try {
                                ConfigurationType configurationType;
                                Element config2 = JDOMUtil.load((Reader)new StringReader(this.builder.toString()));
                                String configTypeId = config2.getAttributeValue("configId");
                                if (configTypeId != null && (configurationType = ConfigurationTypeUtil.findConfigurationType((String)configTypeId)) != null) {
                                    myConfiguration = configurationType.getConfigurationFactories()[0].createTemplateConfiguration(project);
                                    myConfiguration.setName(config2.getAttributeValue("name"));
                                    myConfiguration.readExternal(config2);
                                    RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(myProject);
                                    runManager.readBeforeRunTasks(config2.getChild("method"), new RunnerAndConfigurationSettingsImpl(runManager), myConfiguration);
                                }
                                myTargetId = config2.getAttributeValue("target");
                            }
                            catch (Exception e) {
                                LOG.debug((Throwable)e);
                            }
                            throw new TerminateParsingException();
                        }
                    }
                });
            }
            catch (TerminateParsingException inputStream22) {
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }

        public ExecutionTarget getTarget() {
            if (this.myTargetId != null) {
                if (DefaultExecutionTarget.INSTANCE.getId().equals(this.myTargetId)) {
                    return DefaultExecutionTarget.INSTANCE;
                }
                for (ExecutionTargetProvider provider2 : ExecutionTargetProvider.EXTENSION_NAME.getExtensionList()) {
                    for (ExecutionTarget target2 : provider2.getTargets(this.myProject, this.myConfiguration)) {
                        if (!this.myTargetId.equals(target2.getId())) continue;
                        return target2;
                    }
                }
                return null;
            }
            return DefaultExecutionTarget.INSTANCE;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment2) throws ExecutionException {
            if (executor == null) {
                ImportRunProfile.$$$reportNull$$$0(0);
            }
            if (environment2 == null) {
                ImportRunProfile.$$$reportNull$$$0(1);
            }
            if (!this.myImported) {
                this.myImported = true;
                return new ImportedTestRunnableState(this, VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            }
            if (this.myConfiguration != null) {
                try {
                    return this.myConfiguration.getState(executor, environment2);
                }
                catch (Throwable e) {
                    if (this.myTargetId != null && this.getTarget() == null) {
                        throw new ExecutionException(SmRunnerBundle.message("dialog.message.target.does.not.exist", this.myTargetId));
                    }
                    LOG.info(e);
                    throw new ExecutionException(SmRunnerBundle.message("dialog.message.unable.to.run.configuration.settings.are.corrupted", new Object[0]));
                }
            }
            throw new ExecutionException(SmRunnerBundle.message("dialog.message.unable.to.run.configuration.failed.to.detect.test.framework", new Object[0]));
        }

        @NotNull
        public String getName() {
            String string = this.myImported && this.myConfiguration != null ? this.myConfiguration.getName() : this.myFile.getNameWithoutExtension();
            if (string == null) {
                ImportRunProfile.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myConfiguration != null ? this.myConfiguration.getIcon() : null;
        }

        public RunConfiguration getInitialConfiguration() {
            return this.myConfiguration;
        }

        public Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

