/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.ui;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0018B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/wsl/ui/WslDistributionComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/wsl/WSLDistribution;", "initial", "setPreferredSizeToShowLongMessagesFully", "", "(Lcom/intellij/execution/wsl/WSLDistribution;Z)V", "allInstalledDistributions", "", "isSelectedValid", "()Z", "model", "Lcom/intellij/ui/CollectionComboBoxModel;", "value", "selected", "getSelected", "()Lcom/intellij/execution/wsl/WSLDistribution;", "setSelected", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "tryAdd", "", "distribution", "distributions", "", "WslDistributionRenderer", "intellij.platform.ide.impl"})
public final class WslDistributionComboBox
extends ComboBox<WSLDistribution> {
    private final CollectionComboBoxModel<WSLDistribution> model = new CollectionComboBoxModel();
    private List<? extends WSLDistribution> allInstalledDistributions;

    @Nullable
    public final WSLDistribution getSelected() {
        return (WSLDistribution)this.model.getSelected();
    }

    public final void setSelected(@Nullable WSLDistribution value2) {
        if (this.model.getElementIndex((Object)value2) < 0) {
            this.model.add((Object)value2);
        }
        this.setSelectedItem(value2);
    }

    public final boolean isSelectedValid() {
        WSLDistribution selectedDistribution = this.getSelected();
        List<? extends WSLDistribution> installedDistributions = this.allInstalledDistributions;
        return selectedDistribution != null && (installedDistributions == null || installedDistributions.contains(selectedDistribution));
    }

    private final void tryAdd(WSLDistribution distribution2, List<WSLDistribution> distributions) {
        if (distribution2 != null && !distributions.contains(distribution2)) {
            distributions.add(distribution2);
        }
    }

    public WslDistributionComboBox(@Nullable WSLDistribution initial, boolean setPreferredSizeToShowLongMessagesFully) {
        this.setModel((ComboBoxModel)this.model);
        this.renderer = (ListCellRenderer)((Object)new WslDistributionRenderer());
        if (initial != null) {
            this.model.add((Object)initial);
            this.model.setSelectedItem((Object)initial);
        } else if (setPreferredSizeToShowLongMessagesFully) {
            this.allInstalledDistributions = CollectionsKt.emptyList();
            this.model.add(null);
            this.setPreferredSize(this.getPreferredSize());
            this.model.removeAll();
            this.allInstalledDistributions = null;
        }
        WslDistributionManager wslDistributionManager = WslDistributionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wslDistributionManager, (String)"WslDistributionManager.getInstance()");
        wslDistributionManager.getInstalledDistributionsFuture().thenAccept(new Consumer(){

            public final void accept(final @NotNull List<? extends WSLDistribution> installedDistributions) {
                Intrinsics.checkNotNullParameter(installedDistributions, (String)"installedDistributions");
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        allInstalledDistributions = installedDistributions;
                        List newDistributions = new ArrayList(installedDistributions);
                        WSLDistribution selected2 = (WSLDistribution)model.getSelected();
                        this.tryAdd(selected2, newDistributions);
                        model.removeAll();
                        model.addAll(0, newDistributions);
                        if (selected2 == null) {
                            selected2 = (WSLDistribution)ContainerUtil.getFirstItem((List)model.getItems());
                        }
                        model.setSelectedItem((Object)selected2);
                    }
                }, ModalityState.any());
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/wsl/ui/WslDistributionComboBox$WslDistributionRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/ui/WslDistributionComboBox;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.platform.ide.impl"})
    private final class WslDistributionRenderer
    extends ColoredListCellRenderer<WSLDistribution> {
        protected void customizeCellRenderer(@NotNull JList<? extends WSLDistribution> list2, @Nullable WSLDistribution value2, int index2, boolean selected2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            List installedList = WslDistributionComboBox.this.allInstalledDistributions;
            if (value2 == null) {
                if (installedList != null) {
                    this.append(IdeBundle.message((String)"wsl.no.installed.distributions", (Object[])new Object[0]));
                } else {
                    this.append(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
                }
            } else if (installedList != null && !installedList.contains(value2)) {
                this.append(IdeBundle.message((String)"wsl.not.installed.distribution", (Object[])new Object[]{value2.getMsId()}));
            } else {
                this.append(value2.getMsId());
            }
        }
    }
}

