/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.impl.livePreview.ReplacementView;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreview
implements SearchResults.SearchResultsListener,
SelectionListener,
DocumentListener,
EditorColorsListener {
    private static final Key<RangeHighlighter> IN_SELECTION_KEY = Key.create((String)"LivePreview.IN_SELECTION_KEY");
    private final Disposable myDisposable;
    private boolean mySuppressedUpdate;
    private static final Key<Boolean> MARKER_USED = Key.create((String)"LivePreview.MARKER_USED");
    private static final Key<Boolean> SEARCH_MARKER = Key.create((String)"LivePreview.SEARCH_MARKER");
    public static PrintStream ourTestOutput;
    private String myReplacementPreviewText;
    private static boolean NotFound;
    private final List<RangeHighlighter> myHighlighters;
    private RangeHighlighter myCursorHighlighter;
    private VisibleAreaListener myVisibleAreaListener;
    private Delegate myDelegate;
    private final SearchResults mySearchResults;
    private Balloon myReplacementBalloon;

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            LivePreview.$$$reportNull$$$0(0);
        }
        this.updateInSelectionHighlighters();
    }

    public static void processNotFound() {
        NotFound = true;
    }

    @Override
    public void searchResultsUpdated(@NotNull SearchResults sr) {
        if (sr == null) {
            LivePreview.$$$reportNull$$$0(1);
        }
        if (this.mySuppressedUpdate) {
            this.mySuppressedUpdate = false;
            return;
        }
        this.highlightUsages();
        this.updateCursorHighlighting();
    }

    private void dumpState() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTestOutput != null) {
            this.dumpEditorMarkupAndSelection(ourTestOutput);
        }
    }

    private void dumpEditorMarkupAndSelection(PrintStream dumpStream) {
        dumpStream.println(this.mySearchResults.getFindModel());
        if (this.myReplacementPreviewText != null) {
            dumpStream.println("--");
            dumpStream.println("Replacement Preview: " + this.myReplacementPreviewText);
        }
        dumpStream.println("--");
        Editor editor = this.mySearchResults.getEditor();
        RangeHighlighter[] highlighters = editor.getMarkupModel().getAllHighlighters();
        Arrays.sort(highlighters, Segment.BY_START_OFFSET_THEN_END_OFFSET);
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        for (RangeHighlighter highlighter : highlighters) {
            ranges.add(new Pair((Object)highlighter.getStartOffset(), (Object)Character.valueOf('[')));
            ranges.add(new Pair((Object)highlighter.getEndOffset(), (Object)Character.valueOf(']')));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.getSelectionStart() != selectionModel.getSelectionEnd()) {
            ranges.add(new Pair((Object)selectionModel.getSelectionStart(), (Object)Character.valueOf('<')));
            ranges.add(new Pair((Object)selectionModel.getSelectionEnd(), (Object)Character.valueOf('>')));
        }
        ranges.add(new Pair((Object)-1, (Object)Character.valueOf('\n')));
        ranges.add(new Pair((Object)(editor.getDocument().getTextLength() + 1), (Object)Character.valueOf('\n')));
        ContainerUtil.sort(ranges, (pair, pair2) -> {
            int res2 = (Integer)pair.first - (Integer)pair2.first;
            if (res2 == 0) {
                Character c1 = (Character)pair.second;
                Character c2 = (Character)pair2.second;
                if (c1.charValue() == '<' && c2.charValue() == '[') {
                    return 1;
                }
                if (c1.charValue() == '[' && c2.charValue() == '<') {
                    return -1;
                }
                return c1.compareTo(c2);
            }
            return res2;
        });
        Document document = editor.getDocument();
        for (int i2 = 0; i2 < ranges.size() - 1; ++i2) {
            Pair pair3 = (Pair)ranges.get(i2);
            Pair pair1 = (Pair)ranges.get(i2 + 1);
            dumpStream.print(pair3.second + document.getText(TextRange.create((int)Math.max((Integer)pair3.first, 0), (int)Math.min((Integer)pair1.first, document.getTextLength()))));
        }
        dumpStream.println("\n--");
        if (NotFound) {
            dumpStream.println("Not Found");
            dumpStream.println("--");
            NotFound = false;
        }
        for (RangeHighlighter highlighter : highlighters) {
            dumpStream.println(highlighter + " : " + highlighter.getTextAttributes(editor.getColorsScheme()));
        }
        dumpStream.println("------------");
    }

    private void clearUnusedHighlighters() {
        this.myHighlighters.removeIf(h -> {
            if (h.getUserData(MARKER_USED) == null) {
                this.removeHighlighterWithDependent((RangeHighlighter)h);
                return true;
            }
            h.putUserData(MARKER_USED, null);
            return false;
        });
    }

    private void removeHighlighterWithDependent(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            LivePreview.$$$reportNull$$$0(2);
        }
        this.removeHighlighter(highlighter);
        RangeHighlighter additionalHighlighter = (RangeHighlighter)highlighter.getUserData(IN_SELECTION_KEY);
        if (additionalHighlighter != null) {
            this.removeHighlighter(additionalHighlighter);
        }
    }

    @Override
    public void cursorMoved() {
        this.updateInSelectionHighlighters();
        this.updateCursorHighlighting();
    }

    @Override
    public void updateFinished() {
        this.dumpState();
    }

    private void updateCursorHighlighting() {
        this.hideBalloon();
        if (this.myCursorHighlighter != null) {
            this.removeHighlighter(this.myCursorHighlighter);
            this.myCursorHighlighter = null;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor = this.mySearchResults.getEditor();
        if (cursor != null && cursor.getEndOffset() <= editor.getDocument().getTextLength()) {
            Color color = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            this.myCursorHighlighter = this.addHighlighter(cursor.getStartOffset(), cursor.getEndOffset(), new TextAttributes(null, null, color, EffectType.ROUNDED_BOX, 0));
            editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showReplacementPreview());
        }
    }

    public LivePreview(@NotNull SearchResults searchResults) {
        if (searchResults == null) {
            LivePreview.$$$reportNull$$$0(3);
        }
        this.myDisposable = Disposer.newDisposable((String)"livePreview");
        this.mySuppressedUpdate = false;
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.mySearchResults = searchResults;
        this.searchResultsUpdated(searchResults);
        searchResults.addListener(this);
        EditorUtil.addBulkSelectionListener(this.mySearchResults.getEditor(), this, this.myDisposable);
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(EditorColorsManager.TOPIC, (Object)this);
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate2) {
        this.myDelegate = delegate2;
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme2) {
        this.highlightUsages();
        this.updateCursorHighlighting();
    }

    public void dispose() {
        this.hideBalloon();
        for (RangeHighlighter h : this.myHighlighters) {
            this.removeHighlighterWithDependent(h);
        }
        this.myHighlighters.clear();
        if (this.myCursorHighlighter != null) {
            this.removeHighlighter(this.myCursorHighlighter);
        }
        this.myCursorHighlighter = null;
        Disposer.dispose((Disposable)this.myDisposable);
        this.mySearchResults.removeListener(this);
    }

    private void highlightUsages() {
        List<Object> newHighlighters = this.mySearchResults.getMatchesCount() < this.mySearchResults.getMatchesLimit() ? this.addNewHighlighters() : Collections.emptyList();
        this.clearUnusedHighlighters();
        this.myHighlighters.addAll(newHighlighters);
        this.updateInSelectionHighlighters();
    }

    private List<RangeHighlighter> addNewHighlighters() {
        List<FindResult> occurrences = this.mySearchResults.getOccurrences();
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>(occurrences.size());
        for (FindResult range2 : occurrences) {
            if (range2.getEndOffset() > this.mySearchResults.getEditor().getDocument().getTextLength()) continue;
            TextAttributes attributes2 = this.createAttributes(range2);
            RangeHighlighter existingHighlighter = this.findExistingHighlighter(range2.getStartOffset(), range2.getEndOffset(), attributes2);
            if (existingHighlighter == null) {
                RangeHighlighter highlighter = this.addHighlighter(range2.getStartOffset(), range2.getEndOffset(), attributes2);
                if (highlighter == null) continue;
                highlighter.putUserData(SEARCH_MARKER, (Object)Boolean.TRUE);
                newHighlighters.add(highlighter);
                continue;
            }
            existingHighlighter.putUserData(MARKER_USED, (Object)Boolean.TRUE);
        }
        return newHighlighters;
    }

    private TextAttributes createAttributes(FindResult range2) {
        EditorColorsScheme colorsScheme = this.mySearchResults.getEditor().getColorsScheme();
        if (this.mySearchResults.isExcluded(range2)) {
            return new TextAttributes(null, null, colorsScheme.getDefaultForeground(), EffectType.STRIKEOUT, 0);
        }
        TextAttributes attributes2 = colorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        if (range2.getLength() == 0) {
            attributes2 = attributes2.clone();
            attributes2.setEffectType(EffectType.BOXED);
            attributes2.setEffectColor(attributes2.getBackgroundColor());
        }
        return attributes2;
    }

    private RangeHighlighter findExistingHighlighter(int startOffset, int endOffset, TextAttributes attributes2) {
        MarkupModelEx markupModel = (MarkupModelEx)this.mySearchResults.getEditor().getMarkupModel();
        RangeHighlighter[] existing = new RangeHighlighter[1];
        markupModel.processRangeHighlightersOverlappingWith(startOffset, startOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            if (highlighter.getUserData(SEARCH_MARKER) != null && highlighter.getStartOffset() == startOffset && highlighter.getEndOffset() == endOffset && Objects.equals(highlighter.getTextAttributes(this.mySearchResults.getEditor().getColorsScheme()), attributes2)) {
                existing[0] = highlighter;
                return false;
            }
            return true;
        }));
        return existing[0];
    }

    private void updateInSelectionHighlighters() {
        SelectionModel selectionModel = this.mySearchResults.getEditor().getSelectionModel();
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            RangeHighlighter inSelectionHighlighter;
            if (!highlighter.isValid()) continue;
            boolean needsAdditionalHighlighting = false;
            FindResult cursor = this.mySearchResults.getCursor();
            if (cursor == null || highlighter.getStartOffset() != cursor.getStartOffset() || highlighter.getEndOffset() != cursor.getEndOffset()) {
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    TextRange selectionRange = new TextRange(starts[i2], ends[i2]);
                    boolean bl = needsAdditionalHighlighting = selectionRange.intersects(highlighter.getStartOffset(), highlighter.getEndOffset()) && selectionRange.getEndOffset() != highlighter.getStartOffset() && highlighter.getEndOffset() != selectionRange.getStartOffset();
                    if (needsAdditionalHighlighting) break;
                }
            }
            if ((inSelectionHighlighter = (RangeHighlighter)highlighter.getUserData(IN_SELECTION_KEY)) != null) {
                if (needsAdditionalHighlighting) continue;
                this.removeHighlighter(inSelectionHighlighter);
                continue;
            }
            if (!needsAdditionalHighlighting) continue;
            RangeHighlighter additionalHighlighter = this.addHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), new TextAttributes(null, null, Color.WHITE, EffectType.ROUNDED_BOX, 0));
            highlighter.putUserData(IN_SELECTION_KEY, (Object)additionalHighlighter);
        }
    }

    private void showReplacementPreview() {
        this.hideBalloon();
        if (!this.mySearchResults.isUpToDate()) {
            return;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor = this.mySearchResults.getEditor();
        FindModel findModel = this.mySearchResults.getFindModel();
        if (this.myDelegate != null && cursor != null && findModel.isReplaceState() && findModel.isRegularExpressions()) {
            String replacementPreviewText;
            try {
                replacementPreviewText = this.myDelegate.getStringToReplace(editor, cursor);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                return;
            }
            if (replacementPreviewText == null) {
                return;
            }
            if (Registry.is((String)"ide.find.show.replacement.hint.for.simple.regexp")) {
                this.showBalloon(editor, (String)(replacementPreviewText.isEmpty() ? "<" + FindBundle.message("live.preview.empty.string", new Object[0]) + ">" : replacementPreviewText));
            } else if (!replacementPreviewText.equals(findModel.getStringToReplace())) {
                this.showBalloon(editor, replacementPreviewText);
            }
        }
    }

    private void showBalloon(Editor editor, @Nls String replacementPreviewText) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = replacementPreviewText;
            return;
        }
        ReplacementView replacementView = new ReplacementView(replacementPreviewText);
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)replacementView);
        balloonBuilder.setFadeoutTime(0L);
        balloonBuilder.setFillColor(IdeTooltipManager.GRAPHITE_COLOR);
        balloonBuilder.setAnimationCycle(0);
        balloonBuilder.setHideOnClickOutside(false);
        balloonBuilder.setHideOnKeyOutside(false);
        balloonBuilder.setHideOnAction(false);
        balloonBuilder.setCloseButtonEnabled(true);
        this.myReplacementBalloon = balloonBuilder.createBalloon();
        EditorUtil.disposeWithEditor(editor, (Disposable)this.myReplacementBalloon);
        this.myReplacementBalloon.show((PositionTracker)new ReplacementBalloonPositionTracker(editor), Balloon.Position.below);
    }

    private void hideBalloon() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = null;
            return;
        }
        if (this.myReplacementBalloon != null) {
            this.myReplacementBalloon.hide();
            this.myReplacementBalloon = null;
        }
        this.removeVisibleAreaListener();
    }

    private void removeVisibleAreaListener() {
        if (this.myVisibleAreaListener != null) {
            this.mySearchResults.getEditor().getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
            this.myVisibleAreaListener = null;
        }
    }

    private RangeHighlighter addHighlighter(int startOffset, int endOffset, @NotNull TextAttributes attributes2) {
        Project project;
        if (attributes2 == null) {
            LivePreview.$$$reportNull$$$0(4);
        }
        if ((project = this.mySearchResults.getProject()) == null || project.isDisposed()) {
            return null;
        }
        ArrayList sink = new ArrayList();
        HighlightManager.getInstance((Project)project).addRangeHighlight(this.mySearchResults.getEditor(), startOffset, endOffset, attributes2, false, sink);
        RangeHighlighter result2 = (RangeHighlighter)ContainerUtil.getFirstItem(sink);
        if (result2 instanceof RangeHighlighterEx) {
            ((RangeHighlighterEx)result2).setVisibleIfFolded(true);
        }
        return result2;
    }

    private void removeHighlighter(@NotNull RangeHighlighter highlighter) {
        Project project;
        if (highlighter == null) {
            LivePreview.$$$reportNull$$$0(5);
        }
        if ((project = this.mySearchResults.getProject()) == null || project.isDisposed()) {
            return;
        }
        HighlightManager.getInstance((Project)project).removeSegmentHighlighter(this.mySearchResults.getEditor(), highlighter);
    }

    private static void requestBalloonHiding(Balloon object) {
        ApplicationManager.getApplication().invokeLater(() -> object.hide());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sr";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/impl/livePreview/LivePreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "searchResultsUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlighterWithDependent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlighter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReplacementBalloonPositionTracker
    extends PositionTracker<Balloon> {
        private final Editor myEditor;

        ReplacementBalloonPositionTracker(Editor editor) {
            super((Component)editor.getContentComponent());
            this.myEditor = editor;
        }

        public RelativePoint recalculateLocation(@NotNull Balloon object) {
            FindResult cursor;
            if (object == null) {
                ReplacementBalloonPositionTracker.$$$reportNull$$$0(0);
            }
            if ((cursor = LivePreview.this.mySearchResults.getCursor()) == null) {
                return null;
            }
            FindResult cur = cursor;
            int startOffset = cur.getStartOffset();
            int endOffset = cur.getEndOffset();
            if (endOffset > this.myEditor.getDocument().getTextLength()) {
                if (!object.isDisposed()) {
                    LivePreview.requestBalloonHiding(object);
                }
                return null;
            }
            if (!SearchResults.insideVisibleArea(this.myEditor, (TextRange)cur)) {
                LivePreview.requestBalloonHiding(object);
                LivePreview.this.removeVisibleAreaListener();
                LivePreview.this.myVisibleAreaListener = new VisibleAreaListener((TextRange)cur){
                    final /* synthetic */ TextRange val$cur;
                    {
                        this.val$cur = textRange;
                    }

                    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (SearchResults.insideVisibleArea(ReplacementBalloonPositionTracker.this.myEditor, this.val$cur)) {
                            LivePreview.this.showReplacementPreview();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/livePreview/LivePreview$ReplacementBalloonPositionTracker$1", "visibleAreaChanged"));
                    }
                };
                this.myEditor.getScrollingModel().addVisibleAreaListener(LivePreview.this.myVisibleAreaListener);
            }
            Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
            Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
            Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
            return new RelativePoint((Component)this.myEditor.getContentComponent(), point);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/find/impl/livePreview/LivePreview$ReplacementBalloonPositionTracker", "recalculateLocation"));
        }
    }

    public static interface Delegate {
        @NlsSafe
        @Nullable
        public String getStringToReplace(@NotNull Editor var1, @Nullable FindResult var2) throws FindManager.MalformedReplacementStringException;
    }
}

