/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ExternalFormatProcessorAdapter
implements FormattingService {
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.of(FormattingService.Feature.AD_HOC_FORMATTING, FormattingService.Feature.FORMAT_FRAGMENTS);

    public boolean canFormat(@NotNull PsiFile file2) {
        if (file2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(0);
        }
        return ExternalFormatProcessor.useExternalFormatter((PsiFile)file2);
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set2 = FEATURES;
        if (set2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element2, boolean canChangeWhiteSpacesOnly) {
        if (element2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = ExternalFormatProcessor.formatElement((PsiElement)element2, (TextRange)element2.getTextRange(), (boolean)canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element2, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        if (element2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(4);
        }
        if (range2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = ExternalFormatProcessor.formatElement((PsiElement)element2, (TextRange)range2, (boolean)canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void formatRanges(@NotNull PsiFile file2, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file2 == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(7);
        }
        List<CoreCodeStyleUtil.RangeFormatInfo> infos = CoreCodeStyleUtil.getRangeFormatInfoList(file2, rangesInfo);
        CoreCodeStyleUtil.postProcessRanges(file2, infos, range2 -> ExternalFormatProcessor.formatRangeInFile((PsiFile)file2, (TextRange)range2, (boolean)false, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/ExternalFormatProcessorAdapter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/ExternalFormatProcessorAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

