/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;

class ValidExcludeListItem
extends ExcludeListItem {
    private final VirtualFile myFile;
    private final FrameworkType myFrameworkType;

    ValidExcludeListItem(FrameworkType frameworkType, VirtualFile file2) {
        this.myFrameworkType = frameworkType;
        this.myFile = file2;
    }

    @Override
    public String getFrameworkTypeId() {
        return this.myFrameworkType != null ? this.myFrameworkType.getId() : null;
    }

    @Override
    public String getFileUrl() {
        return this.myFile != null ? this.myFile.getUrl() : null;
    }

    @Override
    public void renderItem(ColoredListCellRenderer renderer2) {
        if (this.myFrameworkType != null) {
            renderer2.setIcon(this.myFrameworkType.getIcon());
            renderer2.append(this.myFrameworkType.getPresentableName());
            if (this.myFile != null) {
                renderer2.append(ProjectBundle.message((String)"framework.detection.in.0", (Object[])new Object[]{this.myFile.getName()}));
                renderer2.append(" (" + this.myFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else {
            renderer2.setIcon(VirtualFilePresentation.getIcon(this.myFile));
            renderer2.append(this.myFile.getName());
            renderer2.append(" (" + this.myFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Override
    public String getPresentableFrameworkName() {
        return this.myFrameworkType != null ? this.myFrameworkType.getPresentableName() : null;
    }
}

