/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChangedNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.changed.notification.panel");

    public FileChangedNotificationProvider() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(FrameStateListener.TOPIC, (Object)new FrameStateListener(){

            public void onFrameActivated() {
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    return;
                }
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    if (project.isDisposed()) continue;
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project);
                    for (VirtualFile file2 : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                        notifications.updateNotifications(file2);
                    }
                }
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    return;
                }
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    if (project.isDisposed()) continue;
                    List openFilePaths = ContainerUtil.map((Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles(), f -> f.getPath());
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project);
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file2;
                        String path2 = vFileEvent.getPath();
                        if (!openFilePaths.contains(path2) || (file2 = vFileEvent.getFile()) == null) continue;
                        notifications.updateNotifications(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/FileChangedNotificationProvider$2", "after"));
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        FileAttributes attributes2;
        VirtualFileSystem fs;
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!(project.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation() || !((fs = file2.getFileSystem()) instanceof LocalFileSystem) || (attributes2 = ((LocalFileSystem)fs).getAttributes(file2)) != null && file2.getTimeStamp() == attributes2.lastModified && file2.getLength() == attributes2.length)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("%s: (%s,%s) -> %s", file2, file2.getTimeStamp(), file2.getLength(), attributes2));
            }
            return FileChangedNotificationProvider.createPanel(file2, fileEditor, project);
        }
        return null;
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(4);
        }
        if (fileEditor == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(6);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        panel2.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel2.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), () -> {
            if (!project.isDisposed()) {
                file2.refresh(false, false);
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            }
        });
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(7);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

