/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.AWTEvent;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProhibitAWTEvents
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance(ProhibitAWTEvents.class);
    private static long ourUseCount;
    private final String myActivityName;
    private final Function<? super AWTEvent, String> myErrorFunction;
    private boolean myReported;

    private ProhibitAWTEvents(@NotNull String activityName, @Nullable Function<? super AWTEvent, String> errorFunction) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(0);
        }
        this.myActivityName = activityName;
        this.myErrorFunction = errorFunction;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        String message2;
        if (e == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(1);
        }
        String string = this.myReported ? null : (message2 = this.myErrorFunction == null ? "AWT events are prohibited inside " + this.myActivityName + "; got " + e : this.myErrorFunction.apply(e));
        if (message2 != null) {
            this.myReported = true;
            LOG.error(message2);
        }
        return true;
    }

    @NotNull
    public static AccessToken start(@NotNull @NonNls String activityName) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(2);
        }
        return ProhibitAWTEvents.doStart(activityName, null);
    }

    @NotNull
    public static AccessToken startFiltered(@NotNull @NonNls String activityName, @NotNull Function<? super AWTEvent, String> errorFunction) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(3);
        }
        if (errorFunction == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(4);
        }
        return ProhibitAWTEvents.doStart(activityName, errorFunction);
    }

    @NotNull
    private static AccessToken doStart(@NotNull @NonNls String activityName, @Nullable Function<? super AWTEvent, String> errorFunction) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(5);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                ProhibitAWTEvents.$$$reportNull$$$0(6);
            }
            return accessToken;
        }
        final ProhibitAWTEvents dispatcher = new ProhibitAWTEvents(activityName, errorFunction);
        IdeEventQueue.getInstance().addPostprocessor(dispatcher, null);
        ++ourUseCount;
        return new AccessToken(){

            public void finish() {
                --ourUseCount;
                IdeEventQueue.getInstance().removePostprocessor(dispatcher);
            }
        };
    }

    public static boolean areEventsProhibited() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        return ourUseCount != 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ProhibitAWTEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ProhibitAWTEvents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startFiltered";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doStart";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

