/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.MyIcon;
import com.intellij.ide.ProjectIconPalette;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.AvatarUtils;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J%\u0010\n\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tJ\u0013\u0010\f\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper;", "", "()V", "calculateIcon", "Ljavax/swing/Icon;", "path", "", "Lorg/jetbrains/annotations/SystemIndependent;", "isDark", "", "getProjectIcon", "generateFromName", "getProjectOrAppIcon", "iconTextForCommaSeparatedName", "name", "Companion", "intellij.platform.ide.impl"})
public final class RecentProjectIconHelper {
    private static final String ideaDir = ".idea";
    private static final HashMap<String, MyIcon> projectIcons;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Icon getProjectIcon(@NotNull String path2, boolean isDark, boolean generateFromName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        MyIcon icon2 = projectIcons.get(path2);
        if (icon2 != null) {
            return icon2.getIcon();
        }
        if (!RecentProjectsManagerBase.Companion.isFileSystemPath(path2)) {
            EmptyIcon emptyIcon = EmptyIcon.create((int)Companion.projectIconSize());
            Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(projectIconSize())");
            return (Icon)emptyIcon;
        }
        Icon icon3 = IconDeferrer.getInstance().deferAutoUpdatable((Icon)EmptyIcon.create((int)Companion.projectIconSize()), new Pair((Object)path2, (Object)isDark), new Function(this, generateFromName, path2){
            final /* synthetic */ RecentProjectIconHelper this$0;
            final /* synthetic */ boolean $generateFromName;
            final /* synthetic */ String $path;

            /*
             * WARNING - void declaration
             */
            public final Icon apply(Pair<String, Boolean> it) {
                Icon icon2;
                Object object = it.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                String string = (String)object;
                Object object2 = it.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second");
                Icon calculateIcon = RecentProjectIconHelper.access$calculateIcon(this.this$0, string, (Boolean)object2);
                if (calculateIcon == null && this.$generateFromName) {
                    RecentProjectsManagerBase projectManager = RecentProjectsManagerBase.Companion.getInstanceEx();
                    String displayName = projectManager.getDisplayName(this.$path);
                    String name = displayName == null ? projectManager.getProjectName(this.$path) : (StringsKt.contains$default((CharSequence)displayName, (CharSequence)",", (boolean)false, (int)2, null) ? RecentProjectIconHelper.access$iconTextForCommaSeparatedName(this.this$0, displayName) : displayName);
                    icon2 = AvatarUtils.INSTANCE.createRoundRectIcon(AvatarUtils.INSTANCE.generateColoredAvatar(name, name, (ColorPalette)ProjectIconPalette.INSTANCE), RecentProjectIconHelper.Companion.projectIconSize());
                } else {
                    void var2_2;
                    icon2 = var2_2;
                }
                return icon2;
            }
            {
                this.this$0 = recentProjectIconHelper;
                this.$generateFromName = bl;
                this.$path = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"IconDeferrer.getInstance\u2026 else calculateIcon\n    }");
        return icon3;
    }

    public static /* synthetic */ Icon getProjectIcon$default(RecentProjectIconHelper recentProjectIconHelper, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return recentProjectIconHelper.getProjectIcon(string, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final String iconTextForCommaSeparatedName(String name) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)name, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Object object;
            Collection collection;
            block4: {
                void word;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CharSequence $this$firstOrNull$iv = (CharSequence)word;
                boolean $i$f$firstOrNull = false;
                CharSequence charSequence = $this$firstOrNull$iv;
                for (int j = 0; j < charSequence.length(); ++j) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(j);
                    boolean bl2 = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    object = Character.valueOf(element$iv);
                    break block4;
                }
                object = string = null;
            }
            if (object == null) {
                string = "";
            }
            String string3 = string;
            collection.add(string3);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        return string5;
    }

    @NotNull
    public final Icon getProjectOrAppIcon(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return RecentProjectIconHelper.getProjectIcon$default(this, path2, StartupUiUtil.isUnderDarcula(), false, 4, null);
    }

    private final Icon calculateIcon(String path2, boolean isDark) {
        Path file2;
        Object v1;
        block9: {
            List lookup2 = isDark ? CollectionsKt.listOf((Object[])new String[]{"icon_dark.svg", "icon.svg", "icon_dark.png", "icon.png"}) : CollectionsKt.listOf((Object[])new String[]{"icon.svg", "icon.png"});
            Iterable $this$firstOrNull$iv = lookup2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Path path3 = Companion.getDotIdeaPath(path2).resolve(it);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getDotIdeaPath(path).resolve(it)");
                if (!PathKt.exists((Path)path3)) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) {
            return null;
        }
        String iconName = string;
        Path path4 = file2 = Companion.getDotIdeaPath(path2).resolve(iconName);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)path4);
        if (basicFileAttributes == null) {
            return null;
        }
        BasicFileAttributes fileInfo = basicFileAttributes;
        long timestamp = fileInfo.lastModifiedTime().toMillis();
        boolean recolor = isDark && !StringsKt.endsWith$default((String)PathsKt.getNameWithoutExtension((Path)file2), (String)"_dark", (boolean)false, (int)2, null);
        MyIcon iconWrapper = projectIcons.get(path2);
        if (iconWrapper != null) {
            Long l = iconWrapper.getTimestamp();
            if (l != null && l == timestamp) {
                return iconWrapper.getIcon();
            }
        }
        try {
            Icon icon2 = Companion.createIcon(file2);
            if (icon2 == null) {
                return null;
            }
            Icon icon3 = icon2;
            if (recolor) {
                Icon icon4 = IconLoader.getDarkIcon((Icon)icon3, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"IconLoader.getDarkIcon(icon, true)");
                icon3 = icon4;
            }
            iconWrapper = new MyIcon(icon3, timestamp);
            ((Map)projectIcons).put(path2, iconWrapper);
            return iconWrapper.getIcon();
        }
        catch (Exception e) {
            RecentProjectIconHelperKt.access$getLOG$p().error((Throwable)e);
            return null;
        }
    }

    static {
        Companion = new Companion(null);
        projectIcons = new HashMap();
    }

    public static final /* synthetic */ Icon access$calculateIcon(RecentProjectIconHelper $this, String path2, boolean isDark) {
        return $this.calculateIcon(path2, isDark);
    }

    public static final /* synthetic */ String access$iconTextForCommaSeparatedName(RecentProjectIconHelper $this, String name) {
        return $this.iconTextForCommaSeparatedName(name);
    }

    @JvmStatic
    @Nullable
    public static final Icon createIcon(@NotNull Path file2) {
        return Companion.createIcon(file2);
    }

    @JvmStatic
    public static final void refreshProjectIcon(@NotNull String path2) {
        Companion.refreshProjectIcon(path2);
    }

    @JvmStatic
    public static final int projectIconSize() {
        return Companion.projectIconSize();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0015\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u000f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007`\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper$Companion;", "", "()V", "ideaDir", "", "projectIcons", "Ljava/util/HashMap;", "Lcom/intellij/ide/MyIcon;", "Lkotlin/collections/HashMap;", "getProjectIcons$annotations", "createIcon", "Ljavax/swing/Icon;", "file", "Ljava/nio/file/Path;", "getDotIdeaPath", "path", "projectIconSize", "", "refreshProjectIcon", "", "Lorg/jetbrains/annotations/SystemIndependent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Path getDotIdeaPath(@NotNull Path path2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (PathKt.isDirectory((Path)path2)) {
                Path path3 = path2.resolve(RecentProjectIconHelper.ideaDir);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.resolve(ideaDir)");
                return path3;
            }
            String fileName = ((Object)path2.getFileName()).toString();
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex == -1) {
                string = fileName;
            } else {
                String string2 = fileName;
                int n = 0;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, dotIndex);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            String fileNameWithoutExt = string;
            Path path4 = path2.getParent().resolve(".idea/.idea." + fileNameWithoutExt + "/.idea");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path.parent.resolve(\"$id\u2026NameWithoutExt/$ideaDir\")");
            return path4;
        }

        @NotNull
        public final Path getDotIdeaPath(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Path path3 = Paths.get(path2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(path)");
            return this.getDotIdeaPath(path3);
        }

        @JvmStatic
        @Nullable
        public final Icon createIcon(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            try {
                String string = PathsKt.getExtension((Path)file2);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                if (Intrinsics.areEqual((Object)"svg", (Object)string3)) {
                    return IconDeferrer.getInstance().defer((Icon)EmptyIcon.create((int)this.projectIconSize()), new Pair((Object)file2.toAbsolutePath(), (Object)StartupUiUtil.isUnderDarcula()), new Function(file2){
                        final /* synthetic */ Path $file;

                        /*
                         * WARNING - void declaration
                         */
                        public final Icon apply(Pair<Path, Boolean> it) {
                            void var2_2;
                            Icon icon2 = IconLoader.findIcon((URL)this.$file.toUri().toURL(), (boolean)false);
                            if (icon2 != null) {
                                if (icon2 instanceof ScaleContextAware) {
                                    ((ScaleContextAware)icon2).updateScaleContext((UserScaleContext)ScaleContext.create());
                                }
                                int n = icon2.getIconWidth();
                                int n2 = icon2.getIconHeight();
                                boolean bl = false;
                                int iconSize = Math.max(n, n2);
                                if (iconSize == RecentProjectIconHelper.Companion.projectIconSize()) {
                                    return icon2;
                                }
                                return IconUtil.scale(icon2, null, (float)RecentProjectIconHelper.Companion.projectIconSize() / (float)iconSize);
                            }
                            return var2_2;
                        }
                        {
                            this.$file = path2;
                        }
                    });
                }
                Image image = ImageLoader.loadFromUrl((URL)file2.toUri().toURL());
                if (image == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"ImageLoader.loadFromUrl(\u2026).toURL()) ?: return null");
                Image image2 = image;
                int targetSize = UIUtil.isRetina() ? 32 : (int)JBUI.pixScale((float)16.0f);
                BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)image2), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)targetSize, (BufferedImageOp[])new BufferedImageOp[0]);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"Scalr.resize(ImageUtil.t\u2026LTRA_QUALITY, targetSize)");
                return RecentProjectIconHelperKt.access$toRetinaAwareIcon(bufferedImage);
            }
            catch (MalformedURLException e) {
                RecentProjectIconHelperKt.access$getLOG$p().debug((Throwable)e);
                return null;
            }
        }

        @JvmStatic
        private static /* synthetic */ void getProjectIcons$annotations() {
        }

        @JvmStatic
        public final void refreshProjectIcon(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            projectIcons.remove(path2);
        }

        @JvmStatic
        public final int projectIconSize() {
            return Registry.intValue((String)"ide.project.icon.size", (int)20);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

