/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AboutPopup;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Container;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0003J\b\u0010\u000e\u001a\u00020\rH\u0003J\b\u0010\u000f\u001a\u00020\rH\u0003J\b\u0010\u0010\u001a\u00020\rH\u0003J\u0006\u0010\u0011\u001a\u00020\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/AboutDialogUI;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addLicenseInfo", "", "cell", "Lcom/intellij/ui/layout/InnerCell;", "addOpenSourceLink", "buildInfo", "", "fullAppName", "jvmVersion", "runtimeVersion", "show", "intellij.platform.ide.impl"})
public final class AboutDialogUI {
    @Nullable
    private final Project project;

    public final void show() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ AboutDialogUI this$0;
            {
                this.this$0 = aboutDialogUI;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Row this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row row2 = $this$row;
                boolean isVerticalFlow$iv = true;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell(this_$iv);
                boolean bl = false;
                $this$cell.component((JComponent)new JBLabel(AppUIUtil.loadApplicationIcon(ScaleContext.create(), 100))).withLargeLeftGap();
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                this_$iv = $this$row;
                isVerticalFlow$iv = true;
                isFullWidth$iv = true;
                $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                $this$cell = new InnerCell(this_$iv);
                boolean bl2 = false;
                Cell cell2 = $this$cell;
                String string = AboutDialogUI.access$fullAppName(this.this$0);
                JBFont jBFont = JBFont.h2();
                Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"JBFont.h2()");
                Cell.label$default(cell2, string, jBFont, null, 4, null).constraints(CCFlags.pushX).withLargeLeftGap();
                Cell.label$default($this$cell, AboutDialogUI.access$buildInfo(this.this$0), null, null, false, 14, null).withLargeLeftGap();
                Cell.label$default($this$cell, "", null, null, false, 14, null);
                AboutDialogUI.access$addLicenseInfo(this.this$0, $this$cell);
                Cell.label$default($this$cell, "", null, null, false, 14, null);
                Cell.label$default($this$cell, AboutDialogUI.access$runtimeVersion(this.this$0), null, null, false, 14, null).withLargeLeftGap();
                Cell.label$default($this$cell, AboutDialogUI.access$jvmVersion(this.this$0), null, null, false, 14, null).withLargeLeftGap();
                Cell.label$default($this$cell, "", null, null, false, 14, null);
                AboutDialogUI.access$addOpenSourceLink(this.this$0, $this$cell);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }, 3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        DialogPanel ui2 = panel$iv;
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String appName = applicationNamesInfo.getFullProductName();
        DialogWrapper dialogWrapper2 = ComponentsKt.dialog$default("About " + appName, (JComponent)ui2, false, null, false, this.project, null, null, null, null, null, 2008, null);
        boolean bl2 = false;
        boolean bl3 = false;
        DialogWrapper $this$apply = dialogWrapper2;
        boolean bl4 = false;
        $this$apply.setSize(600, 400);
        dialogWrapper2.show();
    }

    private final void addOpenSourceLink(InnerCell cell2) {
        String thirdPartyLibraries = AboutPopup.loadThirdPartyLibraries();
        if (thirdPartyLibraries == null) {
            Cell cell3 = cell2;
            String string = IdeBundle.message((String)"about.box.powered.by.open.source", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"about\u2026.powered.by.open.source\")");
            Cell.label$default(cell3, StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"<hyperlink>", (String)"", (boolean)false, (int)4, null), (String)"</hyperlink>", (String)"", (boolean)false, (int)4, null), null, null, false, 14, null).withLargeLeftGap();
        }
        HyperlinkLabel label2 = new HyperlinkLabel();
        label2.setTextWithHyperlink(IdeBundle.message((String)"about.box.powered.by.open.source", (Object[])new Object[0]));
        label2.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(thirdPartyLibraries){
            final /* synthetic */ String $thirdPartyLibraries;

            protected void hyperlinkActivated(@Nullable HyperlinkEvent e) {
                String string = this.$thirdPartyLibraries;
                if (string == null) {
                    string = "";
                }
                AboutPopup.showOpenSoftwareSources(string);
            }
            {
                this.$thirdPartyLibraries = $captured_local_variable$0;
            }
        });
        cell2.component((JComponent)label2).withLargeLeftGap();
    }

    @NlsSafe
    private final String runtimeVersion() {
        Properties properties = System.getProperties();
        String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        String arch = properties.getProperty("os.arch", "");
        String string = IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"about\u2026.jre\", javaVersion, arch)");
        return string;
    }

    @NlsSafe
    private final String jvmVersion() {
        Properties properties = System.getProperties();
        String vmVersion = properties.getProperty("java.vm.name", "unknown");
        String vmVendor = properties.getProperty("java.vendor", "unknown");
        String string = IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"about\u2026vm\", vmVersion, vmVendor)");
        return string;
    }

    private final void addLicenseInfo(InnerCell cell2) {
        LicensingFacade la = LicensingFacade.getInstance();
        if (la != null) {
            String licensedTo = la.getLicensedToMessage();
            if (licensedTo != null) {
                Cell.label$default(cell2, licensedTo, null, null, true, 6, null).withLargeLeftGap();
            }
            for (String message2 : la.getLicenseRestrictionsMessages()) {
                Cell cell3 = cell2;
                String string = message2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
                Cell.label$default(cell3, string, null, null, false, 14, null).withLargeLeftGap();
            }
        }
    }

    @NlsSafe
    private final String buildInfo() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        Object[] objectArray = new Object[1];
        ApplicationInfo applicationInfo = appInfo;
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"appInfo");
        objectArray[0] = applicationInfo.getBuild().asString();
        String string = IdeBundle.message((String)"about.box.build.number", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"about\u2026appInfo.build.asString())");
        String buildInfo = string;
        Calendar calendar = appInfo.getBuildDate();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"appInfo.buildDate");
        Date date = calendar.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"appInfo.buildDate.time");
        Date timestamp = date;
        StringBuilder stringBuilder = new StringBuilder().append(buildInfo);
        BuildNumber buildNumber = appInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"appInfo.build");
        buildInfo = stringBuilder.append(buildNumber.isSnapshot() ? IdeBundle.message((String)"about.box.build.date.time", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)timestamp), new SimpleDateFormat("HH:mm").format(timestamp)}) : IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)timestamp)})).toString();
        return buildInfo;
    }

    @NlsSafe
    private final String fullAppName() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String appName = applicationInfo.getFullApplicationName();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String edition = applicationNamesInfo.getEditionName();
        if (edition != null) {
            appName = appName + " (" + edition + ')';
        }
        String string = appName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appName");
        return string;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public AboutDialogUI(@Nullable Project project) {
        this.project = project;
    }

    public static final /* synthetic */ String access$fullAppName(AboutDialogUI $this) {
        return $this.fullAppName();
    }

    public static final /* synthetic */ String access$buildInfo(AboutDialogUI $this) {
        return $this.buildInfo();
    }

    public static final /* synthetic */ void access$addLicenseInfo(AboutDialogUI $this, InnerCell cell2) {
        $this.addLicenseInfo(cell2);
    }

    public static final /* synthetic */ String access$runtimeVersion(AboutDialogUI $this) {
        return $this.runtimeVersion();
    }

    public static final /* synthetic */ String access$jvmVersion(AboutDialogUI $this) {
        return $this.jvmVersion();
    }

    public static final /* synthetic */ void access$addOpenSourceLink(AboutDialogUI $this, InnerCell cell2) {
        $this.addOpenSourceLink(cell2);
    }
}

