/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(0);
        }
        boolean showFiles = (project = e.getProject()) != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        VirtualFile toSelect2 = null;
        if (StringUtil.isNotEmpty((String)GeneralSettings.getInstance().getDefaultProjectDirectory())) {
            toSelect2 = VfsUtil.findFileByIoFile((File)new File(GeneralSettings.getInstance().getDefaultProjectDirectory()), (boolean)true);
        }
        descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, toSelect2 == null && showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)(toSelect2 != null ? toSelect2 : this.getPathToSelect()), files2 -> {
            for (VirtualFile file2 : files2) {
                if (descriptor2.isFileSelectable(file2)) continue;
                String message2 = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file2.getPresentableUrl()});
                Messages.showInfoMessage((Project)project, (String)message2, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                return;
            }
            for (VirtualFile file2 : files2) {
                OpenFileAction.doOpenFile(project, file2);
            }
        });
    }

    @Nullable
    protected VirtualFile getPathToSelect() {
        return VfsUtil.getUserHomeDir();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Actions.MenuOpen);
        }
    }

    private static void doOpenFile(@Nullable Project project, @NotNull VirtualFile file2) {
        Path filePath;
        if (file2 == null) {
            OpenFileAction.$$$reportNull$$$0(2);
        }
        if (Files.isDirectory(filePath = file2.toNioPath(), new LinkOption[0])) {
            OpenFileAction.openExistingDir(filePath, project);
            return;
        }
        if ((project == null || !file2.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2)) {
            int answer = OpenFileAction.shouldOpenNewProject(project, file2);
            if (answer == 2) {
                return;
            }
            if (answer == 0) {
                Project openedProject = ProjectUtil.openOrImport(filePath, OpenProjectTask.withProjectToClose(project));
                if (openedProject != null) {
                    FileChooserUtil.setLastOpenedFile(openedProject, filePath);
                }
                return;
            }
        }
        LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project, file2);
        FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
        if (type == null) {
            return;
        }
        if (project != null && !project.isDefault()) {
            OpenFileAction.openFile(file2, project);
        } else {
            PlatformProjectOpenProcessor.createTempProjectAndOpenFile(filePath, OpenProjectTask.withProjectToClose(project));
        }
    }

    @ApiStatus.Internal
    public static @NotNull CompletableFuture<@Nullable Project> openExistingDir(@NotNull Path file2, @Nullable Project currentProject) {
        CompletableFuture<Project> projectFuture;
        boolean preferAttach;
        if (file2 == null) {
            OpenFileAction.$$$reportNull$$$0(3);
        }
        boolean canAttach = ProjectAttachProcessor.canAttachToProject();
        boolean bl = preferAttach = currentProject != null && canAttach && (PlatformUtils.isDataGrip() && !ProjectUtil.isValidProjectPath(file2) || PlatformUtils.isPyCharmDs());
        if (preferAttach && PlatformProjectOpenProcessor.attachToProject(currentProject, file2, null)) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                OpenFileAction.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        if (canAttach) {
            OpenProjectTask options2 = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, currentProject);
            projectFuture = ProjectManagerEx.getInstanceEx().openProjectAsync(file2, options2);
        } else {
            projectFuture = ProjectUtil.openOrImportAsync(file2, OpenProjectTask.withProjectToClose(currentProject));
        }
        CompletionStage completionStage = projectFuture.thenApply(project -> {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                FileChooserUtil.setLastOpenedFile(project, file2);
            }
            return project;
        });
        if (completionStage == null) {
            OpenFileAction.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    @Messages.YesNoCancelResult
    private static int shouldOpenNewProject(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            OpenFileAction.$$$reportNull$$$0(6);
        }
        if (file2.getFileType() instanceof ProjectFileType) {
            return 0;
        }
        ProjectOpenProcessor provider2 = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        if (provider2 == null) {
            return 2;
        }
        return provider2.askConfirmationForOpeningProject(file2, project);
    }

    public static void openFile(@NotNull String filePath, @NotNull Project project) {
        VirtualFile file2;
        if (filePath == null) {
            OpenFileAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            OpenFileAction.$$$reportNull$$$0(8);
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath)) != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project);
        }
    }

    public static void openFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            OpenFileAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OpenFileAction.$$$reportNull$$$0(10);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        if (LightEdit.owns((Project)project)) {
            LightEditService.getInstance().openFile(file2);
            LightEditFeatureUsagesUtil.logFileOpen(project, LightEditFeatureUsagesUtil.OpenPlace.LightEditOpenAction);
        } else {
            PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1).navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/OpenFileAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/OpenFileAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openExistingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openExistingDir";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldOpenNewProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }

    public static class OnWelcomeScreen
    extends OpenFileAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OnWelcomeScreen.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            if (!NewWelcomeScreen.isNewWelcomeScreen(e)) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            if (FlatWelcomeFrame.USE_TABBED_WELCOME_SCREEN) {
                presentation2.setIcon(AllIcons.Welcome.Open);
                presentation2.setSelectedIcon(AllIcons.Welcome.OpenSelected);
                presentation2.setText(ActionsBundle.message((String)"action.Tabbed.WelcomeScreen.OpenProject.text", (Object[])new Object[0]));
            } else {
                presentation2.setIcon(AllIcons.Actions.MenuOpen);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction$OnWelcomeScreen", "update"));
        }
    }
}

