/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecentLocationsRenderer
extends EditorTextFieldCellRenderer.SimpleWithGutterRendererComponent
implements ListCellRenderer<RecentLocationItem> {
    private final Project myProject;
    private final RecentLocationsDataModel myModel;
    private final JBCheckBox myCheckBox;
    private final SimpleColoredComponent myTitle;
    private final ConcurrentLinkedDeque<RecentLocationItem> myItemsDeque;
    private final Map<RecentLocationItem, Couple<Highlight[]>> myItemHighlights;
    private Future<?> myHighlightingFuture;
    private RecentLocationItem myCurrentValueForPainting;
    private boolean myCurrentSelectedForPainting;

    RecentLocationsRenderer(@NotNull Project project, @NotNull RecentLocationsDataModel model2, @NotNull JBCheckBox checkBox2) {
        if (project == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(1);
        }
        if (checkBox2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(2);
        }
        super(project, null, false);
        this.myTitle = new SimpleColoredComponent();
        this.myItemsDeque = new ConcurrentLinkedDeque();
        this.myItemHighlights = new ConcurrentHashMap<RecentLocationItem, Couple<Highlight[]>>();
        this.myProject = project;
        this.myModel = model2;
        this.myCheckBox = checkBox2;
        this.myTitle.setBorder((Border)JBUI.Borders.empty((int)8, (int)6, (int)5, (int)0));
        this.getEditor().setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)6, (int)0));
        RecentLocationsRenderer.setupEditor(this.getEditor());
        this.setLayout(new BorderLayout());
        this.add(this.getEditor().getComponent(), "Center");
        this.add((Component)this.myTitle, "North");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myHighlightingFuture != null) {
            this.myHighlightingFuture.cancel(true);
            this.myHighlightingFuture = null;
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends RecentLocationItem> list2, RecentLocationItem value2, int index2, boolean selected2, boolean hasFocus) {
        this.myTitle.clear();
        if (this.myProject.isDisposed() || this.getEditor().isDisposed()) {
            return this.myTitle;
        }
        this.myCurrentValueForPainting = value2;
        this.myCurrentSelectedForPainting = selected2;
        EditorColorsScheme colorsScheme = this.getEditor().getColorsScheme();
        Color backgroundColor = RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected2);
        this.myTitle.setForeground(colorsScheme.getDefaultForeground());
        this.setForcedBackground(backgroundColor);
        this.getEditor().setBackgroundColor(backgroundColor);
        this.customizeTitleComponentText(value2.info);
        this.customizeEditorComponent(value2);
        this.setBorder((Border)(index2 == 0 ? JBUI.Borders.empty() : JBUI.Borders.customLine((Color)RecentLocationsRenderer.getSeparatorLineColor(colorsScheme), (int)1, (int)0, (int)0, (int)0)));
        return this;
    }

    @NotNull
    String getSpeedSearchText(@NotNull RecentLocationItem item) {
        if (item == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(3);
        }
        String breadcrumb = this.myModel.getBreadcrumbsMap(this.myCheckBox.isSelected()).get(item.info);
        String string = breadcrumb + " " + item.info.getFile().getName() + " " + item.text;
        if (string == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(5);
        }
        Color color = selected2 ? HintUtil.getRecentLocationsSelectionColor(colorsScheme) : colorsScheme.getDefaultBackground();
        if (color == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(6);
        }
        return color;
    }

    @NotNull
    private static Color getSeparatorLineColor(@NotNull EditorColorsScheme colorsScheme) {
        Color color;
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(7);
        }
        Color color2 = (color = colorsScheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR)) == null ? JBColor.namedColor((String)"Group.separatorColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)) : color;
        if (color2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(8);
        }
        return color2;
    }

    protected void paintComponent(Graphics g) {
        Objects.requireNonNull(this.myCurrentValueForPainting);
        JList component2 = Objects.requireNonNull((JList)UIUtil.getParentOfType(JList.class, (Component)((Object)this)));
        this.scheduleHighlightingIfNeeded(component2);
        this.applyEditorHighlighting(this.myCurrentValueForPainting);
        this.applyEditorSpeedSearchHighlighting(SpeedSearchSupply.getSupply((JComponent)component2));
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)component2, (SimpleColoredComponent)this.myTitle, (boolean)true, (boolean)this.myCurrentSelectedForPainting);
        super.paintComponent(g);
    }

    private void customizeEditorComponent(final RecentLocationItem value2) {
        this.getEditor().getCaretModel().removeSecondaryCarets();
        this.getEditor().getSelectionModel().removeSelection(true);
        this.getEditor().getMarkupModel().removeAllHighlighters();
        this.getEditor().getGutterComponentEx().setLineNumberConverter((LineNumberConverter)(value2.linesShift == 0 ? LineNumberConverter.DEFAULT : new LineNumberConverter.Increasing(){

            public Integer convert(@NotNull Editor editor, int lineNumber) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lineNumber + value2.linesShift;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/actions/RecentLocationsRenderer$1", "convert"));
            }
        }));
        this.setText(value2.text);
        this.getEditor().getGutterComponentEx().updateUI();
    }

    private void applyEditorHighlighting(RecentLocationItem value2) {
        Couple<Highlight[]> highlights = this.myItemHighlights.get(value2);
        if (highlights == null) {
            this.myItemsDeque.addFirst(value2);
        } else {
            MarkupModelEx markupModel = this.getEditor().getMarkupModel();
            for (Highlight highlight : (Highlight[])highlights.first) {
                markupModel.addRangeHighlighter(highlight.start, highlight.end, 999, highlight.attrs, HighlighterTargetArea.EXACT_RANGE);
            }
            for (Highlight highlight : (Highlight[])highlights.second) {
                markupModel.addRangeHighlighter(highlight.start, highlight.end, 1000, highlight.attrs, HighlighterTargetArea.EXACT_RANGE);
            }
        }
    }

    private static void setupEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(9);
        }
        editor.getGutterComponentEx().setPaintBackground(false);
        editor.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor.getScrollPane().setVerticalScrollBarPolicy(21);
        EditorSettings settings2 = editor.getSettings();
        settings2.setLineNumbersShown(true);
        settings2.setUseSoftWraps(false);
    }

    private void customizeTitleComponentText(@NotNull IdeDocumentHistoryImpl.PlaceInfo place) {
        if (place == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(10);
        }
        String breadcrumbs = this.myModel.getBreadcrumbsMap(this.myCheckBox.isSelected()).get(place);
        String fileName = place.getFile().getName();
        this.myTitle.append(fileName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (StringUtil.isNotEmpty((String)breadcrumbs) && !StringUtil.equals((CharSequence)breadcrumbs, (CharSequence)fileName)) {
            this.myTitle.append("  ");
            this.myTitle.append(breadcrumbs, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        Icon icon2 = IconUtil.getIcon(place.getFile(), 2, this.myProject);
        this.myTitle.setIcon(icon2);
        this.myTitle.setIconTextGap(4);
        if (!SystemInfo.isWindows) {
            this.myTitle.setFont(FontUtil.minusOne((Font)UIUtil.getLabelFont()));
        }
        long timeStamp = place.getTimeStamp();
        if (UISettings.getInstance().getShowInplaceComments() && Registry.is((String)"show.last.visited.timestamps") && timeStamp != -1L) {
            this.myTitle.append(" " + DateFormatUtil.formatPrettyDateTime((long)timeStamp), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
        }
    }

    private void applyEditorSpeedSearchHighlighting(@Nullable SpeedSearchSupply speedSearch2) {
        Iterable ranges;
        String text2 = this.getEditor().getDocument().getText();
        Iterable iterable = ranges = speedSearch2 == null ? null : speedSearch2.matchingFragments(text2);
        if (ranges != null) {
            RecentLocationsRenderer.selectSearchResultsInEditor(this.getEditor(), ranges.iterator());
        }
        if (RecentLocationsAction.getEmptyFileText().equals(text2)) {
            this.getEditor().getMarkupModel().addRangeHighlighter(0, RecentLocationsAction.getEmptyFileText().length(), 1000, SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<? extends TextRange> resultIterator) {
        if (editor == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(11);
        }
        if (resultIterator == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(12);
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            TextRange findResult = resultIterator.next();
            int caretOffset = findResult.getEndOffset();
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
            if (caretStates.size() < editor.getCaretModel().getMaxCaretCount()) continue;
            break;
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    private void scheduleHighlightingIfNeeded(@NotNull JList<?> component2) {
        if (component2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(13);
        }
        if (this.getEditor().isDisposed()) {
            return;
        }
        if (this.myHighlightingFuture != null && !this.myHighlightingFuture.isDone()) {
            return;
        }
        if (this.myItemsDeque.isEmpty()) {
            return;
        }
        this.myHighlightingFuture = ReadAction.nonBlocking(() -> {
            while (!this.myItemsDeque.isEmpty()) {
                ProgressManager.checkCanceled();
                RecentLocationItem item = this.myItemsDeque.removeFirst();
                try {
                    this.myItemHighlights.put(item, (Couple<Highlight[]>)Couple.of((Object)this.calcItemHighlights(item, true), (Object)this.calcItemHighlights(item, false)));
                }
                catch (ProcessCanceledException e) {
                    this.myItemsDeque.addFirst(item);
                    throw e;
                }
            }
        }).expireWith((Disposable)this).finishOnUiThread(ModalityState.stateForComponent((Component)((Object)this)), __ -> component2.repaint()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private Highlight @NotNull [] calcItemHighlights(@NotNull RecentLocationItem item, boolean lexerHighlights) {
        if (item == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(14);
        }
        TextRange[] ranges = item.ranges;
        IdeDocumentHistoryImpl.PlaceInfo info2 = item.info;
        EditorColorsScheme colorsScheme = this.getEditor().getColorsScheme();
        RangeMarker caretPosition = item.info.getCaretPosition();
        if (caretPosition == null || !caretPosition.isValid()) {
            if (Highlight.EMPTY_ARRAY == null) {
                RecentLocationsRenderer.$$$reportNull$$$0(15);
            }
            return Highlight.EMPTY_ARRAY;
        }
        Document fileDocument = caretPosition.getDocument();
        ArrayList<Highlight> result2 = new ArrayList<Highlight>();
        if (lexerHighlights) {
            EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(info2.getFile(), colorsScheme, this.myProject);
            editorHighlighter.setEditor((HighlighterClient)new LightHighlighterClient(fileDocument, this.myProject));
            editorHighlighter.setText((CharSequence)fileDocument.getText());
            int rangeIdx = 0;
            int rangeOffset = 0;
            HighlighterIterator iterator2 = editorHighlighter.createIterator(ranges[0].getStartOffset());
            while (!iterator2.atEnd() && rangeIdx < ranges.length) {
                TextRange range2 = ranges[rangeIdx];
                if (range2.intersects(iterator2.getStart(), iterator2.getEnd())) {
                    result2.add(new Highlight(Math.max(iterator2.getStart(), range2.getStartOffset()) - range2.getStartOffset() + rangeOffset, Math.min(iterator2.getEnd(), range2.getEndOffset()) - range2.getStartOffset() + rangeOffset, iterator2.getTextAttributes()));
                }
                if (iterator2.getEnd() < range2.getEndOffset()) {
                    iterator2.advance();
                    continue;
                }
                rangeOffset += range2.getLength() + 1;
                ++rangeIdx;
            }
        } else {
            int totalStartOffset = ranges[0].getStartOffset();
            int totalEndOffset = ranges[ranges.length - 1].getEndOffset();
            DaemonCodeAnalyzerEx.processHighlights(fileDocument, this.myProject, null, totalStartOffset, totalEndOffset, (Processor<? super HighlightInfo>)((Processor)o -> {
                if (o.getSeverity() != HighlightSeverity.INFORMATION || o.getEndOffset() <= totalStartOffset || o.getStartOffset() >= totalEndOffset) {
                    return true;
                }
                int rangeOffset = 0;
                for (int rangeIdx = 0; rangeIdx < ranges.length; ++rangeIdx) {
                    TextRange range2 = ranges[rangeIdx];
                    if (range2.intersects(o.getStartOffset(), o.getEndOffset())) {
                        TextAttributes textAttributes = o.forcedTextAttributes != null ? o.forcedTextAttributes : colorsScheme.getAttributes(o.forcedTextAttributesKey);
                        result2.add(new Highlight(Math.max(o.getActualStartOffset(), range2.getStartOffset()) - range2.getStartOffset() + rangeOffset, Math.min(o.getActualEndOffset(), range2.getEndOffset()) - range2.getStartOffset() + rangeOffset, textAttributes));
                    }
                    rangeOffset += ranges[rangeIdx].getLength() + 1;
                }
                return true;
            }));
        }
        Highlight[] highlightArray = result2.toArray(Highlight.EMPTY_ARRAY);
        if (highlightArray == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(16);
        }
        return highlightArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RecentLocationsRenderer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultIterator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RecentLocationsRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpeedSearchText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorLineColor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcItemHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpeedSearchText";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSeparatorLineColor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeTitleComponentText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectSearchResultsInEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleHighlightingIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcItemHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Highlight {
        static final Highlight[] EMPTY_ARRAY = new Highlight[0];
        final int start;
        final int end;
        final TextAttributes attrs;

        Highlight(int start2, int end, TextAttributes attrs) {
            this.start = start2;
            this.end = end;
            this.attrs = attrs;
        }
    }
}

