/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectModelSynchronizer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(0);
        }
        if (!SaveAsDirectoryBasedFormatAction.isConvertableProject(project = event.getProject()) || Messages.showOkCancelDialog((Project)project, (String)IdeBundle.message((String)"message.project.will.be.saved.and.reopened.in.new.directory.based.format", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.save.project.to.directory.based.format", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        IProjectStore store = ProjectKt.getStateStore(project);
        Path baseDir = store.getProjectFilePath().getParent();
        Path ideaDir = baseDir.resolve(".idea");
        try {
            SaveAsDirectoryBasedFormatAction.convertToDirectoryBasedFormat(project, store, baseDir, ideaDir);
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            projectManager.closeAndDispose(project);
            projectManager.openProject(ideaDir.getParent(), new OpenProjectTask());
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)String.format(IdeBundle.message((String)"dialog.message.unable.to.create.idea.directory", (Object[])new Object[]{e.getMessage()}), ideaDir), (String)IdeBundle.message((String)"dialog.title.error.saving.project", (Object[])new Object[0]));
        }
    }

    private static void convertToDirectoryBasedFormat(Project project, IProjectStore store, Path baseDir, Path ideaDir) throws IOException {
        if (Files.isDirectory(ideaDir, new LinkOption[0])) {
            LocalFileSystem.getInstance().refreshAndFindFileByNioFile(ideaDir);
        } else {
            SaveAsDirectoryBasedFormatAction.createDir(ideaDir);
        }
        store.clearStorages();
        store.setPath(baseDir);
        WriteAction.run(() -> JpsProjectModelSynchronizer.Companion.getInstance(project).convertToDirectoryBasedFormat());
    }

    @TestOnly
    public static void convertToDirectoryBasedFormat(@NotNull Project project) throws IOException {
        if (project == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(1);
        }
        IProjectStore store = ProjectKt.getStateStore(project);
        Path baseDir = store.getProjectFilePath().getParent();
        Path ideaDir = baseDir.resolve(".idea");
        SaveAsDirectoryBasedFormatAction.convertToDirectoryBasedFormat(project, store, baseDir, ideaDir);
    }

    private static VirtualFile createDir(@NotNull Path ideaDir) throws IOException {
        if (ideaDir == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(2);
        }
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> VfsUtil.createDirectoryIfMissing((String)ideaDir.toString()));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        e.getPresentation().setVisible(SaveAsDirectoryBasedFormatAction.isConvertableProject(project));
    }

    private static boolean isConvertableProject(@Nullable Project project) {
        return project != null && !project.isDefault() && !ProjectKt.isDirectoryBased(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SaveAsDirectoryBasedFormatAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToDirectoryBasedFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

