/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowMoveAction
extends DumbAwareAction
implements FusAwareAction {
    @NotNull
    private final Anchor myAnchor;

    @Nullable
    private static ToolWindowManager getToolWindowManager(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(0);
        }
        return (project = e.getProject()) == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project);
    }

    @Nullable
    private static ToolWindow getToolWindow(@NotNull AnActionEvent e) {
        ToolWindowManager manager2;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(1);
        }
        if ((manager2 = ToolWindowMoveAction.getToolWindowManager(e)) == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id2 = manager2.getActiveToolWindowId();
        return id2 == null ? null : manager2.getToolWindow(id2);
    }

    public ToolWindowMoveAction(@NotNull Anchor anchor2) {
        if (anchor2 == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(2);
        }
        super(anchor2.toString(), null, anchor2.getIcon());
        this.myAnchor = anchor2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(3);
        }
        if ((toolWindow = ToolWindowMoveAction.getToolWindow(e)) != null) {
            this.myAnchor.applyTo(toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(4);
        }
        ToolWindow toolWindow = ToolWindowMoveAction.getToolWindow(e);
        e.getPresentation().setEnabled(toolWindow != null && !this.myAnchor.isApplied(toolWindow));
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow;
        if (event == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(5);
        }
        if ((toolWindow = ToolWindowMoveAction.getToolWindow(event)) != null) {
            List<EventPair<?>> list2 = Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow.getId()));
            if (list2 == null) {
                ToolWindowMoveAction.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<EventPair<?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolWindowMoveAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public Group() {
            super(UIBundle.messagePointer((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        }

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (!this.isInitialized) {
                for (Anchor anchor2 : Anchor.values()) {
                    this.add((AnAction)new ToolWindowMoveAction(anchor2));
                }
                this.isInitialized = true;
            }
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToolWindowMoveAction$Group", "update"));
        }
    }

    public static enum Anchor {
        LeftTop,
        LeftBottom,
        BottomLeft,
        BottomRight,
        RightBottom,
        RightTop,
        TopRight,
        TopLeft;


        @Nls
        public String toString() {
            String top = UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]);
            String left = UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]);
            String bottom = UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]);
            String right = UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]);
            switch (this) {
                case LeftTop: {
                    return left + " " + top;
                }
                case LeftBottom: {
                    return left + " " + bottom;
                }
                case BottomLeft: {
                    return bottom + " " + left;
                }
                case BottomRight: {
                    return bottom + " " + right;
                }
                case RightBottom: {
                    return right + " " + bottom;
                }
                case RightTop: {
                    return right + " " + top;
                }
                case TopRight: {
                    return top + " " + right;
                }
                case TopLeft: {
                    return top + " " + left;
                }
            }
            throw new IllegalStateException("Should not be invoked");
        }

        @NotNull
        public static Anchor fromWindowInfo(@NotNull WindowInfo info2) {
            if (info2 == null) {
                Anchor.$$$reportNull$$$0(0);
            }
            if (info2.isSplit()) {
                if (info2.getAnchor() == ToolWindowAnchor.LEFT) {
                    Anchor anchor2 = LeftBottom;
                    if (anchor2 == null) {
                        Anchor.$$$reportNull$$$0(1);
                    }
                    return anchor2;
                }
                if (info2.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    Anchor anchor3 = BottomRight;
                    if (anchor3 == null) {
                        Anchor.$$$reportNull$$$0(2);
                    }
                    return anchor3;
                }
                if (info2.getAnchor() == ToolWindowAnchor.RIGHT) {
                    Anchor anchor4 = RightBottom;
                    if (anchor4 == null) {
                        Anchor.$$$reportNull$$$0(3);
                    }
                    return anchor4;
                }
                if (info2.getAnchor() == ToolWindowAnchor.TOP) {
                    Anchor anchor5 = TopRight;
                    if (anchor5 == null) {
                        Anchor.$$$reportNull$$$0(4);
                    }
                    return anchor5;
                }
            }
            if (info2.getAnchor() == ToolWindowAnchor.LEFT) {
                Anchor anchor6 = LeftTop;
                if (anchor6 == null) {
                    Anchor.$$$reportNull$$$0(5);
                }
                return anchor6;
            }
            if (info2.getAnchor() == ToolWindowAnchor.BOTTOM) {
                Anchor anchor7 = BottomLeft;
                if (anchor7 == null) {
                    Anchor.$$$reportNull$$$0(6);
                }
                return anchor7;
            }
            if (info2.getAnchor() == ToolWindowAnchor.RIGHT) {
                Anchor anchor8 = RightTop;
                if (anchor8 == null) {
                    Anchor.$$$reportNull$$$0(7);
                }
                return anchor8;
            }
            Anchor anchor9 = TopLeft;
            if (anchor9 == null) {
                Anchor.$$$reportNull$$$0(8);
            }
            return anchor9;
        }

        @NotNull
        private ToolWindowAnchor getAnchor() {
            switch (this) {
                case LeftTop: 
                case LeftBottom: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(9);
                    }
                    return toolWindowAnchor;
                }
                case BottomLeft: 
                case BottomRight: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(10);
                    }
                    return toolWindowAnchor;
                }
                case RightBottom: 
                case RightTop: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(11);
                    }
                    return toolWindowAnchor;
                }
            }
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.TOP;
            if (toolWindowAnchor == null) {
                Anchor.$$$reportNull$$$0(12);
            }
            return toolWindowAnchor;
        }

        private boolean isSplit() {
            return Arrays.asList(LeftBottom, BottomRight, RightBottom, TopRight).contains((Object)this);
        }

        @NotNull
        public Icon getIcon() {
            switch (this) {
                case LeftTop: {
                    Icon icon2 = AllIcons.Actions.MoveToLeftTop;
                    if (icon2 == null) {
                        Anchor.$$$reportNull$$$0(13);
                    }
                    return icon2;
                }
                case LeftBottom: {
                    Icon icon3 = AllIcons.Actions.MoveToLeftBottom;
                    if (icon3 == null) {
                        Anchor.$$$reportNull$$$0(14);
                    }
                    return icon3;
                }
                case BottomLeft: {
                    Icon icon4 = AllIcons.Actions.MoveToBottomLeft;
                    if (icon4 == null) {
                        Anchor.$$$reportNull$$$0(15);
                    }
                    return icon4;
                }
                case BottomRight: {
                    Icon icon5 = AllIcons.Actions.MoveToBottomRight;
                    if (icon5 == null) {
                        Anchor.$$$reportNull$$$0(16);
                    }
                    return icon5;
                }
                case RightBottom: {
                    Icon icon6 = AllIcons.Actions.MoveToRightBottom;
                    if (icon6 == null) {
                        Anchor.$$$reportNull$$$0(17);
                    }
                    return icon6;
                }
                case RightTop: {
                    Icon icon7 = AllIcons.Actions.MoveToRightTop;
                    if (icon7 == null) {
                        Anchor.$$$reportNull$$$0(18);
                    }
                    return icon7;
                }
                case TopRight: {
                    Icon icon8 = AllIcons.Actions.MoveToTopRight;
                    if (icon8 == null) {
                        Anchor.$$$reportNull$$$0(19);
                    }
                    return icon8;
                }
            }
            Icon icon9 = AllIcons.Actions.MoveToTopLeft;
            if (icon9 == null) {
                Anchor.$$$reportNull$$$0(20);
            }
            return icon9;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(21);
            }
            return this.getAnchor() == window.getAnchor() && window.isSplitMode() == this.isSplit();
        }

        public void applyTo(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(22);
            }
            window.setAnchor(this.getAnchor(), null);
            window.setSplitMode(this.isSplit(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromWindowInfo";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWindowInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplied";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "applyTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

