/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmarks.BookmarkBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import java.awt.Font;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Bookmark
implements Navigatable,
Comparable<Bookmark> {
    private OpenFileDescriptor myTarget;
    private Reference<RangeHighlighterEx> myHighlighterRef;
    private int myLine;
    private String myUrl;
    @NotNull
    @NlsSafe
    private String myDescription;
    private char myMnemonic;
    int index;

    @ApiStatus.Internal
    public Bookmark(@NotNull String url, int line, @NotNull @NlsSafe String description2) {
        if (url == null) {
            Bookmark.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            Bookmark.$$$reportNull$$$0(1);
        }
        this.myUrl = url;
        this.myLine = line;
        this.myDescription = description2;
    }

    Bookmark(@NotNull Project project, @NotNull VirtualFile file2, int line, @NotNull @NlsSafe String description2) {
        if (project == null) {
            Bookmark.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            Bookmark.$$$reportNull$$$0(3);
        }
        if (description2 == null) {
            Bookmark.$$$reportNull$$$0(4);
        }
        this.myDescription = description2;
        this.initTarget(project, file2, line);
    }

    @Nullable
    OpenFileDescriptor init(@NotNull Project project) {
        if (project == null) {
            Bookmark.$$$reportNull$$$0(5);
        }
        if (this.myTarget != null) {
            throw new IllegalStateException("Bookmark is already initialized (file=" + this.myTarget + ")");
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        if (file2 == null) {
            return null;
        }
        this.myUrl = null;
        this.initTarget(project, file2, this.myLine);
        this.myLine = -1;
        return this.myTarget;
    }

    private void initTarget(@NotNull Project project, @NotNull VirtualFile file2, int line) {
        if (project == null) {
            Bookmark.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            Bookmark.$$$reportNull$$$0(7);
        }
        this.myTarget = new OpenFileDescriptor(project, file2, line, -1, true);
        this.addHighlighter();
    }

    @NotNull
    public static Font getBookmarkFont() {
        Font font = EditorFontType.getGlobalPlainFont();
        if (font == null) {
            Bookmark.$$$reportNull$$$0(8);
        }
        return font;
    }

    @Override
    public int compareTo(@NotNull Bookmark o) {
        int i2;
        if (o == null) {
            Bookmark.$$$reportNull$$$0(9);
        }
        int n = this.myMnemonic != '\u0000' ? (o.myMnemonic != '\u0000' ? this.myMnemonic - o.myMnemonic : -1) : (i2 = o.myMnemonic != '\u0000' ? 1 : 0);
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myTarget.getProject().getName().compareTo(o.myTarget.getProject().getName());
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myTarget.getFile().getName().compareTo(o.getFile().getName());
        if (i2 != 0) {
            return i2;
        }
        return this.getTarget().compareTo(o.getTarget());
    }

    void updateHighlighter() {
        this.release();
        this.addHighlighter();
    }

    private void addHighlighter() {
        Document document = this.getCachedDocument();
        if (document != null) {
            this.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true));
        }
    }

    public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markup) {
        RangeHighlighterEx highlighter;
        int line;
        if (markup == null) {
            Bookmark.$$$reportNull$$$0(10);
        }
        if ((line = this.getLine()) >= 0) {
            highlighter = markup.addPersistentLineHighlighter(CodeInsightColors.BOOKMARKS_ATTRIBUTES, line, 5001);
            if (highlighter != null) {
                highlighter.setGutterIconRenderer(new MyGutterIconRenderer(this));
                highlighter.setErrorStripeTooltip(this.getBookmarkTooltip());
            }
        } else {
            highlighter = null;
        }
        this.myHighlighterRef = highlighter == null ? null : new WeakReference<RangeHighlighterEx>(highlighter);
        return highlighter;
    }

    @Deprecated
    @Nullable
    public Document getDocument() {
        return this.getCachedDocument();
    }

    Document getCachedDocument() {
        return FileDocumentManager.getInstance().getCachedDocument(this.getFile());
    }

    public void release() {
        int line = this.getLine();
        if (line < 0) {
            return;
        }
        Document document = this.getCachedDocument();
        if (document == null) {
            return;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        if (markupDocument.getLineCount() <= line) {
            return;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null) {
            this.myHighlighterRef = null;
            highlighter.dispose();
        }
    }

    private RangeHighlighterEx findMyHighlighter() {
        Document document = this.getCachedDocument();
        if (document == null) {
            return null;
        }
        RangeHighlighterEx result2 = (RangeHighlighterEx)SoftReference.dereference(this.myHighlighterRef);
        if (result2 != null) {
            return result2;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        boolean startOffset = false;
        int endOffset = markupDocument.getTextLength();
        Ref found = new Ref();
        markup.processRangeHighlightersOverlappingWith(0, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            GutterIconRenderer renderer2 = highlighter.getGutterIconRenderer();
            if (renderer2 instanceof MyGutterIconRenderer && ((MyGutterIconRenderer)renderer2).myBookmark == this) {
                found.set(highlighter);
                return false;
            }
            return true;
        }));
        result2 = (RangeHighlighterEx)found.get();
        this.myHighlighterRef = result2 == null ? null : new WeakReference<RangeHighlighterEx>(result2);
        return result2;
    }

    public Icon getIcon() {
        return this.getType().getIcon();
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            Bookmark.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setDescription(@NotNull @NlsSafe String description2) {
        if (description2 == null) {
            Bookmark.$$$reportNull$$$0(12);
        }
        this.myDescription = description2;
    }

    public BookmarkType getType() {
        return BookmarkType.get((char)this.getMnemonic());
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myTarget.getFile();
        if (virtualFile2 == null) {
            Bookmark.$$$reportNull$$$0(13);
        }
        return virtualFile2;
    }

    @Nullable
    String nullizeEmptyDescription() {
        return StringUtil.nullize((String)this.myDescription);
    }

    public boolean isValid() {
        if (!this.getFile().isValid()) {
            return false;
        }
        if (this.getLine() == -1) {
            return true;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        return highlighter != null && highlighter.isValid();
    }

    public boolean canNavigate() {
        return this.getTarget().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getTarget().canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        this.getTarget().navigate(requestFocus);
    }

    public int getLine() {
        int targetLine = this.myTarget.getLine();
        if (targetLine == -1) {
            return -1;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null && highlighter.isValid()) {
            Document document = highlighter.getDocument();
            return document.getLineNumber(highlighter.getStartOffset());
        }
        RangeMarker marker = this.myTarget.getRangeMarker();
        if (marker != null && marker.isValid()) {
            Document document = marker.getDocument();
            return document.getLineNumber(marker.getStartOffset());
        }
        return targetLine;
    }

    public boolean hasLine() {
        return this.myTarget.getLine() >= 0;
    }

    @NotNull
    private OpenFileDescriptor getTarget() {
        int line = this.getLine();
        if (line != this.myTarget.getLine()) {
            this.myTarget = new OpenFileDescriptor(this.myTarget.getProject(), this.myTarget.getFile(), line, -1, true);
        }
        OpenFileDescriptor openFileDescriptor = this.myTarget;
        if (openFileDescriptor == null) {
            Bookmark.$$$reportNull$$$0(14);
        }
        return openFileDescriptor;
    }

    public String toString() {
        String description2;
        StringBuilder result2 = new StringBuilder(this.myTarget == null ? this.myUrl : this.getQualifiedName());
        String text2 = this.nullizeEmptyDescription();
        String string = description2 = text2 == null ? null : StringUtil.escapeXmlEntities((String)text2);
        if (description2 != null) {
            result2.append(": ").append(description2);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getQualifiedName() {
        Object presentableUrl = this.myTarget.getFile().getPresentableUrl();
        if (this.myTarget.getFile().isDirectory()) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(15);
            }
            return string;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myTarget.getProject()).findFile(this.myTarget.getFile());
        if (psiFile == null) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(16);
            }
            return string;
        }
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            ItemPresentation presentation2;
            Object element2;
            StructureViewModel model2 = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(null);
            try {
                element2 = model2.getCurrentEditorElement();
            }
            finally {
                Disposer.dispose((Disposable)model2);
            }
            if (element2 instanceof NavigationItem && (presentation2 = ((NavigationItem)element2).getPresentation()) != null) {
                presentableUrl = ((NavigationItem)element2).getName() + " " + presentation2.getLocationString();
            }
        }
        String string = BookmarkBundle.message("bookmark.file.X.line.Y", presentableUrl, this.getLine() + 1);
        if (string == null) {
            Bookmark.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    @NlsContexts.Tooltip
    private String getBookmarkTooltip() {
        String shortcutToToggle;
        String text2;
        String description2;
        StringBuilder result2 = new StringBuilder(BookmarkBundle.message("bookmark.text", new Object[0]));
        if (this.myMnemonic != '\u0000') {
            result2.append(" ").append(this.myMnemonic);
        }
        String string = description2 = (text2 = this.nullizeEmptyDescription()) == null ? null : StringUtil.escapeXmlEntities((String)text2);
        if (description2 != null) {
            result2.append(": ").append(description2);
        }
        StringBuilder shortcutDescription = new StringBuilder();
        if (this.myMnemonic != '\u0000') {
            shortcutToToggle = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + this.myMnemonic));
            String shortcutToNavigate = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + this.myMnemonic));
            if (!shortcutToToggle.isEmpty()) {
                shortcutDescription.append(shortcutToNavigate.isEmpty() ? BookmarkBundle.message("bookmark.shortcut.to.toggle", shortcutToToggle) : BookmarkBundle.message("bookmark.shortcut.to.toggle.and.jump", shortcutToToggle, shortcutToNavigate));
            } else if (!shortcutToNavigate.isEmpty()) {
                shortcutDescription.append(BookmarkBundle.message("bookmark.shortcut.to.jump", shortcutToNavigate));
            }
        }
        if (shortcutDescription.length() == 0 && (shortcutToToggle = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark")).length() > 0) {
            shortcutDescription.append(BookmarkBundle.message("bookmark.shortcut.to.toggle", shortcutToToggle));
        }
        if (shortcutDescription.length() > 0) {
            result2.append(" (").append((CharSequence)shortcutDescription).append(")");
        }
        String string2 = result2.toString();
        if (string2 == null) {
            Bookmark.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    @NlsSafe
    public static String toString(char mnemonic, boolean point) {
        StringBuilder sb = new StringBuilder().append(mnemonic);
        if (point) {
            sb.append('.');
        }
        String string = sb.toString();
        if (string == null) {
            Bookmark.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkFont";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkTooltip";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTarget";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Bookmark myBookmark;

        MyGutterIconRenderer(@NotNull Bookmark bookmark) {
            if (bookmark == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.myBookmark = bookmark;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return alignment;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myBookmark.getType().getGutterIcon();
            if (icon2 == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return icon2;
        }

        @NotNull
        public String getTooltipText() {
            String string = this.myBookmark.getBookmarkTooltip();
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public GutterDraggableObject getDraggableObject() {
            return new GutterDraggableObject(){

                public boolean copy(int line, VirtualFile file2, int actionId) {
                    myBookmark.myTarget = new OpenFileDescriptor(myBookmark.myTarget.getProject(), file2, line, -1, true);
                    myBookmark.updateHighlighter();
                    return true;
                }
            };
        }

        @NotNull
        public String getAccessibleName() {
            String string = BookmarkBundle.message("accessible.name.icon.bookmark.0", Character.valueOf(this.myBookmark.myMnemonic));
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof MyGutterIconRenderer && Objects.equals(this.getTooltipText(), ((MyGutterIconRenderer)((Object)obj2)).getTooltipText()) && Comparing.equal((Object)this.getIcon(), (Object)((MyGutterIconRenderer)((Object)obj2)).getIcon());
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            return (ActionGroup)ActionManager.getInstance().getAction("popup@BookmarkContextMenu");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bookmark";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

