/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.net.HostAndPort;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStarter {
    private static final Logger LOG = Logger.getInstance(BrowserStarter.class);
    private final StartBrowserSettings mySettings;
    private final RunConfiguration myRunConfiguration;
    private final BooleanSupplier myOutdated;
    private int myMaximumAttempt;
    private boolean myOpenOnMaximumAttempt;

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings2, @NotNull BooleanSupplier outdated) {
        if (runConfiguration == null) {
            BrowserStarter.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            BrowserStarter.$$$reportNull$$$0(1);
        }
        if (outdated == null) {
            BrowserStarter.$$$reportNull$$$0(2);
        }
        this.myMaximumAttempt = 100;
        this.myOpenOnMaximumAttempt = false;
        this.mySettings = settings2;
        this.myRunConfiguration = runConfiguration;
        this.myOutdated = outdated;
    }

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings2, @NotNull ProcessHandler serverProcessHandler) {
        if (runConfiguration == null) {
            BrowserStarter.$$$reportNull$$$0(3);
        }
        if (settings2 == null) {
            BrowserStarter.$$$reportNull$$$0(4);
        }
        if (serverProcessHandler == null) {
            BrowserStarter.$$$reportNull$$$0(5);
        }
        this(runConfiguration, settings2, () -> serverProcessHandler.isProcessTerminating() || serverProcessHandler.isProcessTerminated());
    }

    public BrowserStarter setMaximumAttempts(int value2) {
        this.myMaximumAttempt = value2;
        return this;
    }

    public BrowserStarter setOpenOnMaximumAttempt(boolean value2) {
        this.myOpenOnMaximumAttempt = value2;
        return this;
    }

    public void start() {
        if (!this.mySettings.isSelected() || this.mySettings.getUrl() == null) {
            return;
        }
        HostAndPort hostAndPort = BrowserStarter.getHostAndPort(this.mySettings.getUrl());
        if (hostAndPort != null) {
            this.checkAndOpenPageLater(hostAndPort, 1, 300);
        } else {
            this.openPageLater();
        }
    }

    @Nullable
    private static HostAndPort getHostAndPort(@NotNull String rawUrl) {
        URI url;
        if (rawUrl == null) {
            BrowserStarter.$$$reportNull$$$0(6);
        }
        if ((url = Urls.parseAsJavaUriWithoutParameters((String)rawUrl)) == null) {
            return null;
        }
        int port = url.getPort();
        if (port == -1) {
            port = "https".equals(url.getScheme()) ? 443 : 80;
        }
        return HostAndPort.fromParts((String)StringUtil.notNullize((String)url.getHost(), (String)"127.0.0.1"), (int)port);
    }

    private void checkAndOpenPageLater(@NotNull HostAndPort hostAndPort, int attemptNumber, int delayMillis) {
        if (hostAndPort == null) {
            BrowserStarter.$$$reportNull$$$0(7);
        }
        JobScheduler.getScheduler().schedule(() -> this.checkAndOpenPage(hostAndPort, attemptNumber), (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private void checkAndOpenPage(@NotNull HostAndPort hostAndPort, int attemptNumber) {
        if (hostAndPort == null) {
            BrowserStarter.$$$reportNull$$$0(8);
        }
        if (this.isOutdated()) {
            LOG.info("Opening " + hostAndPort + " aborted");
        } else if (NetUtils.canConnectToRemoteSocket((String)hostAndPort.getHost(), (int)hostAndPort.getPort())) {
            this.openPageNow();
        } else if (attemptNumber < this.myMaximumAttempt) {
            int delayMillis = BrowserStarter.getDelayMillis(attemptNumber);
            LOG.info("#" + attemptNumber + " check " + hostAndPort + " failed, scheduling next check in " + delayMillis + "ms");
            this.checkAndOpenPageLater(hostAndPort, attemptNumber + 1, delayMillis);
        } else if (attemptNumber == this.myMaximumAttempt && this.myOpenOnMaximumAttempt) {
            LOG.info("#" + attemptNumber + " maximum attempt is reached, page opening is forced");
            this.openPageNow();
        } else {
            LOG.info("#" + attemptNumber + " check " + hostAndPort + " failed. Too many failed checks. Failed to open " + hostAndPort);
            this.showBrowserOpenTimeoutNotification();
        }
    }

    private static int getDelayMillis(int attemptNumber) {
        if (attemptNumber < 10) {
            return 500;
        }
        if (attemptNumber < 20) {
            return 1000;
        }
        return 5000;
    }

    private void openPageLater() {
        JobScheduler.getScheduler().schedule(() -> this.openPageNow(), 1000L, TimeUnit.MILLISECONDS);
    }

    private void openPageNow() {
        if (!this.isOutdated()) {
            JavaScriptDebuggerStarter.Util.startDebugOrLaunchBrowser(this.myRunConfiguration, this.mySettings);
        }
    }

    private boolean isOutdated() {
        return this.myOutdated.getAsBoolean();
    }

    private void showBrowserOpenTimeoutNotification() {
        NotificationGroup group2 = NotificationGroup.balloonGroup((String)"URL does not respond notification", (String)IdeBundle.message((String)"browser.notification.timeout.group", (Object[])new Object[0]));
        String url = Objects.requireNonNull(this.mySettings.getUrl());
        String openUrlDescription = "open_url";
        String content2 = IdeBundle.message((String)"browser.notification.timeout.text", (Object[])new Object[]{openUrlDescription, url});
        group2.createNotification(IdeBundle.message((String)"browser.notification.timeout.title", (Object[])new Object[0]), content2, NotificationType.ERROR).setListener((notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(openUrlDescription)) {
                BrowserUtil.open((String)url);
                notification.expire();
            }
        }).notify(this.myRunConfiguration.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outdated";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverProcessHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostAndPort";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/browsers/BrowserStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getHostAndPort";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndOpenPageLater";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndOpenPage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

