/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaScriptDebuggerStarter<RC extends RunConfiguration, U> {
    public boolean isApplicable(@NotNull RunConfiguration var1);

    public void start(@NotNull String var1, @NotNull RC var2, @NotNull U var3, @Nullable WebBrowser var4);

    public static final class Util {
        static final ExtensionPointName<JavaScriptDebuggerStarter> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.javaScriptDebuggerStarter");
        private static final Object NULL_OBJECT = new Object();

        @Nullable
        public static <RC extends RunConfiguration, T> JavaScriptDebuggerStarter<RC, T> get(@NotNull RC runConfiguration) {
            if (runConfiguration == null) {
                Util.$$$reportNull$$$0(0);
            }
            for (JavaScriptDebuggerStarter starter2 : EP_NAME.getExtensionList()) {
                if (!starter2.isApplicable(runConfiguration)) continue;
                return starter2;
            }
            return null;
        }

        public static <RC extends RunConfiguration> boolean start(@NotNull RC runConfiguration, @NotNull String url) {
            if (runConfiguration == null) {
                Util.$$$reportNull$$$0(1);
            }
            if (url == null) {
                Util.$$$reportNull$$$0(2);
            }
            return Util.start(runConfiguration, url, null);
        }

        public static <RC extends RunConfiguration> boolean start(@NotNull RC runConfiguration, @NotNull String url, @Nullable WebBrowser browser2) {
            JavaScriptDebuggerStarter starter2;
            if (runConfiguration == null) {
                Util.$$$reportNull$$$0(3);
            }
            if (url == null) {
                Util.$$$reportNull$$$0(4);
            }
            if ((starter2 = Util.get(runConfiguration)) == null) {
                return false;
            }
            starter2.start(url, runConfiguration, NULL_OBJECT, browser2);
            return true;
        }

        public static <RC extends RunConfiguration> void startDebugOrLaunchBrowser(@NotNull RC runConfiguration, @NotNull StartBrowserSettings settings2) {
            if (runConfiguration == null) {
                Util.$$$reportNull$$$0(5);
            }
            if (settings2 == null) {
                Util.$$$reportNull$$$0(6);
            }
            String url = settings2.getUrl();
            assert (url != null);
            Util.startDebugOrLaunchBrowser(runConfiguration, url, settings2.getBrowser(), settings2.isStartJavaScriptDebugger());
        }

        public static <RC extends RunConfiguration> void startDebugOrLaunchBrowser(@NotNull RC runConfiguration, @NotNull String url, @Nullable WebBrowser browser2, boolean startDebugger) {
            if (runConfiguration == null) {
                Util.$$$reportNull$$$0(7);
            }
            if (url == null) {
                Util.$$$reportNull$$$0(8);
            }
            if (!startDebugger || !Util.start(runConfiguration, url, browser2)) {
                BrowserLauncher.getInstance().browse(url, browser2, runConfiguration.getProject());
            }
        }

        public static boolean hasStarters() {
            return EP_NAME.hasAnyExtensions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/browsers/JavaScriptDebuggerStarter$Util";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "start";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDebugOrLaunchBrowser";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

