/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class FavoritesViewSelectInTarget
extends SelectInTargetPsiWrapper {
    FavoritesViewSelectInTarget(Project project) {
        super(project);
        if (PlatformUtils.isPyCharmEducational()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public String toString() {
        return IdeBundle.message((String)"select.in.favorites", (Object[])new Object[0]);
    }

    public String getToolWindowId() {
        return "Favorites";
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile2, boolean requestFocus) {
        FavoritesViewSelectInTarget.select(this.myProject, selector, virtualFile2, requestFocus);
    }

    @Override
    protected void select(PsiElement element2, boolean requestFocus) {
        PsiElement toSelect2 = FavoritesViewSelectInTarget.findElementToSelect(element2, null);
        if (toSelect2 != null) {
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)toSelect2);
            virtualFile2 = virtualFile2 == null ? null : BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile2);
            this.select(toSelect2, virtualFile2, requestFocus);
        }
    }

    private static ActionCallback select(@NotNull Project project, Object toSelect2, VirtualFile virtualFile2, boolean requestFocus) {
        if (project == null) {
            FavoritesViewSelectInTarget.$$$reportNull$$$0(0);
        }
        ActionCallback result2 = new ActionCallback();
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow favoritesToolWindow = windowManager.getToolWindow("Favorites");
        if (favoritesToolWindow != null) {
            Runnable runnable2 = () -> {
                FavoritesTreeViewPanel panel2 = (FavoritesTreeViewPanel)UIUtil.findComponentOfType((JComponent)favoritesToolWindow.getComponent(), FavoritesTreeViewPanel.class);
                if (panel2 != null) {
                    panel2.selectElement(toSelect2, virtualFile2, requestFocus);
                    result2.setDone();
                }
            };
            if (requestFocus) {
                favoritesToolWindow.activate(runnable2, false);
            } else {
                favoritesToolWindow.show(runnable2);
            }
        }
        return result2;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return FavoritesViewSelectInTarget.findSuitableFavoritesList(file2.getVirtualFile(), this.myProject, null) != null;
    }

    public static String findSuitableFavoritesList(VirtualFile file2, Project project, String currentSubId) {
        FavoritesManager manager2 = FavoritesManager.getInstance(project);
        return manager2 != null ? manager2.getFavoriteListName(currentSubId, file2) : null;
    }

    public String getMinorViewId() {
        return "Favorites";
    }

    public float getWeight() {
        return 1.01f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesViewSelectInTarget", "select"));
    }
}

