/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction
implements UpdateInBackground {
    private static final Logger LOG = Logger.getInstance(BrowseHierarchyActionBase.class);
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(@NotNull LanguageExtension<HierarchyProvider> extension2) {
        if (extension2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(0);
        }
        this.myExtension = extension2;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        HierarchyProvider provider2 = this.getProvider(e);
        if (provider2 == null) {
            return;
        }
        PsiElement target2 = provider2.getTarget(dataContext);
        if (target2 == null) {
            return;
        }
        BrowseHierarchyActionBase.createAndAddToPanel(project, provider2, target2);
    }

    @NotNull
    public static HierarchyBrowser createAndAddToPanel(@NotNull Project project, @NotNull HierarchyProvider provider2, @NotNull PsiElement target2) {
        Content content2;
        if (project == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(4);
        }
        HierarchyBrowser hierarchyBrowser = provider2.createHierarchyBrowser(target2);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project);
        ContentManager contentManager2 = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager2.getSelectedContent();
        JComponent browserComponent = hierarchyBrowser.getComponent();
        if (!DumbService.isDumbAware((Object)hierarchyBrowser)) {
            browserComponent = DumbService.getInstance((Project)project).wrapGently(browserComponent, (Disposable)project);
        }
        if (selectedContent != null && !selectedContent.isPinned()) {
            content2 = selectedContent;
            JComponent component2 = content2.getComponent();
            if (component2 instanceof DumbUnawareHider) {
                component2 = ((DumbUnawareHider)component2).getContent();
            }
            if (component2 instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)component2));
            }
            content2.setComponent(browserComponent);
        } else {
            content2 = ContentFactory.SERVICE.getInstance().createContent(browserComponent, null, true);
            contentManager2.addContent(content2);
        }
        content2.setHelpId("reference.toolWindows.hierarchy");
        contentManager2.setSelectedContent(content2);
        hierarchyBrowser.setContent(content2);
        Runnable runnable2 = () -> {
            if (hierarchyBrowser instanceof HierarchyBrowserBase && ((HierarchyBrowserBase)hierarchyBrowser).isDisposed()) {
                return;
            }
            provider2.browserActivated(hierarchyBrowser);
        };
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Hierarchy");
        toolWindow.activate(runnable2);
        if (hierarchyBrowser instanceof Disposable) {
            Disposer.register((Disposable)toolWindow.getContentManager(), (Disposable)((Disposable)hierarchyBrowser));
        }
        HierarchyBrowser hierarchyBrowser2 = hierarchyBrowser;
        if (hierarchyBrowser2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(5);
        }
        return hierarchyBrowser2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(6);
        }
        if (!this.myExtension.hasAnyExtensions()) {
            e.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e);
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setVisible(true);
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e) {
        HierarchyProvider provider2 = this.getProvider(e);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using provider " + provider2);
        }
        if (provider2 == null) {
            return false;
        }
        PsiElement target2 = provider2.getTarget(e.getDataContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + target2);
        }
        return target2 != null;
    }

    @Nullable
    private HierarchyProvider getProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(7);
        }
        return BrowseHierarchyActionBase.findProvider(this.myExtension, (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT), (PsiFile)e.getData(CommonDataKeys.PSI_FILE), e.getDataContext());
    }

    @Nullable
    public static HierarchyProvider findProvider(@NotNull LanguageExtension<HierarchyProvider> extension2, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile, @NotNull DataContext dataContext) {
        HierarchyProvider provider2;
        if (extension2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(9);
        }
        if ((provider2 = BrowseHierarchyActionBase.findBestHierarchyProvider(extension2, psiElement, dataContext)) == null) {
            return BrowseHierarchyActionBase.findBestHierarchyProvider(extension2, (PsiElement)psiFile, dataContext);
        }
        return provider2;
    }

    @Nullable
    public static HierarchyProvider findBestHierarchyProvider(LanguageExtension<HierarchyProvider> extension2, @Nullable PsiElement element2, DataContext dataContext) {
        if (element2 == null) {
            return null;
        }
        List providers = extension2.allForLanguage(element2.getLanguage());
        for (HierarchyProvider provider2 : providers) {
            PsiElement target2 = provider2.getTarget(dataContext);
            if (target2 == null) continue;
            return provider2;
        }
        return (HierarchyProvider)ContainerUtil.getFirstItem((List)providers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAddToPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddToPanel";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

