/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataValidators;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.BackgroundableDataProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.impl.EdtDataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance(DataManagerImpl.class);
    private static final ThreadLocal<int[]> ourGetDataLevel = ThreadLocal.withInitial(() -> new int[1]);
    private final KeyedExtensionCollector<GetDataRule, String> myDataRuleCollector = new KeyedExtensionCollector(GetDataRule.EP_NAME);

    @ApiStatus.Internal
    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider2, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        if (provider2 == null) {
            DataManagerImpl.$$$reportNull$$$0(0);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(1);
        }
        return this.getDataFromProvider(provider2, dataId, alreadyComputedIds, this.getDataRule(dataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider2, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds, @Nullable GetDataRule dataRule) {
        if (provider2 == null) {
            DataManagerImpl.$$$reportNull$$$0(2);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        int[] depth = ourGetDataLevel.get();
        try {
            depth[0] = depth[0] + 1;
            Object data2 = provider2.getData(dataId);
            if (data2 != null) {
                Object object = DataValidators.validOrNull(data2, dataId, provider2);
                return object;
            }
            if (dataRule != null) {
                HashSet<String> ids = alreadyComputedIds == null ? new HashSet<String>() : alreadyComputedIds;
                ids.add(dataId);
                data2 = dataRule.getData(id2 -> this.getDataFromProvider(provider2, id2, ids));
                if (data2 != null) {
                    Object object = DataValidators.validOrNull(data2, dataId, provider2);
                    return object;
                }
            }
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            depth[0] = depth[0] - 1;
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(@Nullable Object component2) {
        DataProvider dataProvider = null;
        if (component2 instanceof DataProvider) {
            dataProvider = (DataProvider)component2;
        } else if (component2 instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component2);
        } else if (component2 instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)((JComponent)component2));
        }
        if (dataProvider instanceof BackgroundableDataProvider) {
            dataProvider = ((BackgroundableDataProvider)dataProvider).createBackgroundDataProvider();
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        List rules2;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(4);
        }
        String uninjectedId = InjectedDataKeys.uninjectedId((String)dataId);
        GetDataRule slowRule = dataProvider -> DataManagerImpl.getSlowData(dataId, dataProvider);
        List rules1 = (List)ContainerUtil.nullize((Collection)this.myDataRuleCollector.forKey((Object)dataId));
        List list2 = rules2 = uninjectedId == null ? null : (List)ContainerUtil.nullize((Collection)this.myDataRuleCollector.forKey((Object)uninjectedId));
        if (rules1 == null && rules2 == null) {
            return slowRule;
        }
        return dataProvider -> {
            Object data2 = slowRule.getData(dataProvider);
            if (data2 != null) {
                return data2;
            }
            if (rules1 != null) {
                for (GetDataRule rule : rules1) {
                    data2 = rule.getData(dataProvider);
                    if (data2 == null) continue;
                    return data2;
                }
            }
            if (rules2 != null) {
                for (GetDataRule rule : rules2) {
                    data2 = rule.getData(id2 -> {
                        String injectedId = InjectedDataKeys.injectedId((String)id2);
                        return injectedId != null ? dataProvider.getData(injectedId) : null;
                    });
                    if (data2 == null) continue;
                    return data2;
                }
            }
            return null;
        };
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull DataProvider dataProvider) {
        Iterable asyncProviders;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(5);
        }
        if (dataProvider == null) {
            DataManagerImpl.$$$reportNull$$$0(6);
        }
        if ((asyncProviders = (Iterable)PlatformDataKeys.SLOW_DATA_PROVIDERS.getData(dataProvider)) == null) {
            return null;
        }
        for (DataProvider provider2 : asyncProviders) {
            Object data2 = provider2.getData(dataId);
            if (data2 == null) continue;
            return data2;
        }
        return null;
    }

    @NotNull
    public DataContext getDataContext(Component component2) {
        if (Registry.is((String)"actionSystem.dataContextAssertions")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (ourGetDataLevel.get()[0] > 0) {
                LOG.error("DataContext shall not be created and queried inside another getData() call.");
            }
        }
        return new MyDataContext(component2);
    }

    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            DataManagerImpl.$$$reportNull$$$0(7);
        }
        if (x < 0 || x >= component2.getWidth() || y < 0 || y >= component2.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component2;
            int index2 = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            DataContext dataContext = this.getDataContext(index2 != -1 ? tabbedPane.getComponentAt(index2) : tabbedPane);
            if (dataContext == null) {
                DataManagerImpl.$$$reportNull$$$0(8);
            }
            return dataContext;
        }
        DataContext dataContext = this.getDataContext(component2);
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(9);
        }
        return dataContext;
    }

    @NotNull
    public DataContext getDataContext() {
        Component component2 = null;
        if (Registry.is((String)"actionSystem.getContextByRecentMouseEvent")) {
            component2 = SwingHelper.getComponentFromRecentMouseEvent();
        }
        DataContext dataContext = this.getDataContext(component2 != null ? component2 : DataManagerImpl.getFocusedComponent());
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(10);
        }
        return dataContext;
    }

    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> result2.setResult((Object)this.getDataContext()), ModalityState.any());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            DataManagerImpl.$$$reportNull$$$0(11);
        }
        return asyncPromise;
    }

    @Nullable
    private static Component getFocusedComponent() {
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            return null;
        }
        WindowManagerEx windowManagerEx = (WindowManagerEx)windowManager;
        Window activeWindow = windowManagerEx.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = windowManagerEx.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = windowManagerEx.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data2) {
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(12);
        }
        if (dataContext instanceof UserDataHolder && !Utils.isFrozenDataContext(dataContext)) {
            ((UserDataHolder)dataContext).putUserData(dataKey, data2);
        }
    }

    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(13);
        }
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(14);
        }
        return (T)(dataContext instanceof UserDataHolder ? ((UserDataHolder)dataContext).getUserData(dataKey) : null);
    }

    @Nullable
    public static Editor validateEditor(Editor editor, Component contextComponent) {
        JComponent jComponent;
        if (contextComponent instanceof JComponent && (jComponent = (JComponent)contextComponent).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataRule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveInDataContext";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static class MyDataContext
    extends EdtDataContext {
        public MyDataContext(@Nullable Component component2) {
            super(component2);
        }
    }
}

