/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;

final class LightEditDropHandler
implements EditorDropHandler {
    LightEditDropHandler() {
    }

    @Override
    public boolean canHandleDrop(DataFlavor[] transferFlavors) {
        return transferFlavors != null && FileCopyPasteUtil.isFileListFlavorAvailable(transferFlavors);
    }

    @Override
    public void handleDrop(Transferable t, Project project, EditorWindow editorWindow) {
        List<File> fileList = FileCopyPasteUtil.getFileList(t);
        if (fileList == null) {
            return;
        }
        for (File file2 : fileList) {
            VirtualFile obj2 = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
            if (obj2 == null) continue;
            LightEditService.getInstance().openFile(obj2);
            LightEditFeatureUsagesUtil.logFileOpen(project, LightEditFeatureUsagesUtil.OpenPlace.DragAndDrop);
        }
    }
}

