/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditDropHandler;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditorManagerImpl
implements LightEditorManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(LightEditorManagerImpl.class);
    private final List<LightEditorInfo> myEditors = new CopyOnWriteArrayList<LightEditorInfo>();
    private final EventDispatcher<LightEditorListener> myEventDispatcher = EventDispatcher.create(LightEditorListener.class);
    private final LightEditServiceImpl myLightEditService;
    static final Key<Boolean> NO_IMPLICIT_SAVE = Key.create((String)"light.edit.no.implicit.save");
    private static final String DEFAULT_FILE_NAME = "untitled_";

    public LightEditorManagerImpl(LightEditServiceImpl service) {
        this.myLightEditService = service;
    }

    @Nullable
    private LightEditorInfo doCreateEditor(@NotNull VirtualFile file2) {
        Project project;
        Pair<FileEditorProvider, FileEditor> pair;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(0);
        }
        if ((pair = LightEditorManagerImpl.createFileEditor(project = LightEditUtil.requireLightEditProject(this.myLightEditService.getProject()), file2)) == null) {
            return null;
        }
        FileEditor fileEditor = (FileEditor)pair.second;
        LightEditorInfoImpl editorInfo = new LightEditorInfoImpl((FileEditorProvider)pair.first, fileEditor, file2);
        ObjectUtils.consumeIfNotNull((Object)EditorHistoryManager.getInstance(project).getState(file2, (FileEditorProvider)pair.first), state -> {
            fileEditor.getComponent();
            fileEditor.setState(state);
        });
        ObjectUtils.consumeIfCast((Object)LightEditorInfoImpl.getEditor(editorInfo), EditorImpl.class, editorImpl -> editorImpl.setDropHandler(new LightEditDropHandler()));
        this.myEditors.add(editorInfo);
        this.installListener(editorInfo);
        ((FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened(FileEditorManager.getInstance((Project)project), file2);
        return editorInfo;
    }

    private void installListener(@NotNull LightEditorInfo editorInfo) {
        Editor editor;
        FileEditor fileEditor;
        if (editorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(1);
        }
        if ((fileEditor = editorInfo.getFileEditor()) instanceof TextEditor && (editor = ((TextEditor)fileEditor).getEditor()) instanceof EditorEx) {
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LightEditorManagerImpl.this.checkUpdate(editor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/lightEdit/LightEditorManagerImpl$1", "focusGained"));
                }
            }, this);
        }
    }

    @Nullable
    private static Pair<FileEditorProvider, FileEditor> createFileEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        FileEditorProvider[] providers;
        FileEditorProvider[] fileEditorProviderArray;
        int n;
        int n2;
        if (project == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(3);
        }
        if ((n2 = 0) < (n = (fileEditorProviderArray = (providers = FileEditorProviderManager.getInstance().getProviders(project, file2))).length)) {
            FileEditorProvider provider2 = fileEditorProviderArray[n2];
            FileEditor editor = provider2.createEditor(project, file2);
            return Pair.create((Object)provider2, (Object)editor);
        }
        return null;
    }

    @NotNull
    public LightEditorInfo createEmptyEditor(@Nullable String preferredName) {
        String name = preferredName != null ? preferredName : this.getUniqueName();
        LightVirtualFile file2 = new LightVirtualFile(name);
        file2.setFileType(LightEditorManagerImpl.getFileType(preferredName));
        LightEditorInfo lightEditorInfo = Objects.requireNonNull(this.doCreateEditor((VirtualFile)file2));
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(4);
        }
        return lightEditorInfo;
    }

    @NotNull
    private static FileType getFileType(@Nullable String preferredName) {
        int extOffset;
        if (preferredName != null && (extOffset = preferredName.lastIndexOf(".")) >= 0 && preferredName.length() > extOffset + 1) {
            String extension2 = preferredName.substring(extOffset + 1);
            FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension2);
            if (!(fileType instanceof UnknownFileType) && !fileType.isBinary()) {
                FileType fileType2 = fileType;
                if (fileType2 == null) {
                    LightEditorManagerImpl.$$$reportNull$$$0(5);
                }
                return fileType2;
            }
        }
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(6);
        }
        return plainTextFileType;
    }

    @Nullable
    public LightEditorInfo createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(7);
        }
        LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        LightEditorManagerImpl.setImplicitSaveEnabled(file2, false);
        LightEditorInfo editorInfo = this.doCreateEditor(file2);
        Editor editor = LightEditorInfoImpl.getEditor(editorInfo);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).setHighlighter(LightEditorManagerImpl.getHighlighter(file2, editor));
        }
        return editorInfo;
    }

    private static void setImplicitSaveEnabled(@NotNull VirtualFile file2, boolean isEnabled) {
        Document document;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(8);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file2)) != null) {
            document.putUserData(NO_IMPLICIT_SAVE, (Object)(isEnabled ? null : Boolean.valueOf(true)));
        }
    }

    public void dispose() {
        this.releaseEditors();
    }

    public void releaseEditors() {
        this.myEditors.forEach(editorInfo -> ((LightEditorInfoImpl)editorInfo).disposeEditor());
        this.myEditors.clear();
    }

    public void closeAllEditors() {
        this.myEditors.forEach(editorInfo -> this.closeEditor((LightEditorInfo)editorInfo));
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(9);
        }
        EditorHistoryManager.getInstance(this.myLightEditService.getOrCreateProject()).updateHistoryEntry(editorInfo.getFile(), false);
        this.myEditors.remove(editorInfo);
        LightEditorManagerImpl.setImplicitSaveEnabled(editorInfo.getFile(), true);
        ((LightEditorInfoImpl)editorInfo).disposeEditor();
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterClose(editorInfo);
    }

    public void addListener(@NotNull LightEditorListener listener2) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(10);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LightEditorListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(12);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, parent);
    }

    void fireEditorSelected(@Nullable LightEditorInfo editorInfo) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterSelect(editorInfo);
    }

    void fireAutosaveModeChanged(boolean autosaveMode) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).autosaveModeChanged(autosaveMode);
    }

    void fireFileStatusChanged(@NotNull Collection<LightEditorInfo> editorInfos) {
        if (editorInfos == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(13);
        }
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).fileStatusChanged(editorInfos);
    }

    @NotNull
    private static EditorHighlighter getHighlighter(@NotNull VirtualFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(15);
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, editor.getColorsScheme(), null);
        if (editorHighlighter == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(16);
        }
        return editorHighlighter;
    }

    int getEditorCount() {
        return this.myEditors.size();
    }

    @Nullable
    public LightEditorInfo findOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(17);
        }
        return (LightEditorInfo)ContainerUtil.find(this.myEditors, editorInfo -> file2.getPath().equals(editorInfo.getFile().getPath()));
    }

    public boolean isImplicitSaveAllowed(@NotNull Document document) {
        if (document == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(18);
        }
        return LightEditService.getInstance().isAutosaveMode() || (Boolean)ObjectUtils.notNull((Object)((Boolean)document.getUserData(NO_IMPLICIT_SAVE)), (Object)false) == false;
    }

    @NotNull
    public Collection<VirtualFile> getOpenFiles() {
        Collection collection = this.myEditors.stream().map(info2 -> info2.getFile()).collect(Collectors.toSet());
        if (collection == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public Collection<LightEditorInfo> getEditors(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(20);
        }
        List list2 = ContainerUtil.filter(this.myEditors, editorInfo -> virtualFile2.equals(editorInfo.getFile()));
        if (list2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(22);
        }
        return this.myEditors.stream().anyMatch(editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public boolean containsUnsavedDocuments() {
        return this.myEditors.stream().anyMatch(editorInfo -> editorInfo.isSaveRequired());
    }

    @NotNull
    List<LightEditorInfo> getUnsavedEditors() {
        List list2 = ContainerUtil.filter(this.myEditors, editorInfo -> editorInfo.isSaveRequired());
        if (list2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private String getUniqueName() {
        int i2 = 1;
        String candidate;
        while (ContainerUtil.exists(this.myEditors, arg_0 -> LightEditorManagerImpl.lambda$getUniqueName$10(candidate = DEFAULT_FILE_NAME + i2, arg_0))) {
            ++i2;
        }
        return candidate;
    }

    @NotNull
    public LightEditorInfo saveAs(@NotNull LightEditorInfo info2, @NotNull VirtualFile targetFile) {
        LightEditorInfo newInfo;
        if (info2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(24);
        }
        if (targetFile == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if ((newInfo = this.createEditor(targetFile)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager manager2 = FileDocumentManager.getInstance();
                Document source = manager2.getDocument(info2.getFile());
                Document target2 = manager2.getDocument(targetFile);
                if (source == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + info2.getFile());
                    return;
                }
                if (target2 == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + targetFile);
                    return;
                }
                targetFile.refresh(false, false);
                target2.setText(source.getCharsSequence());
                manager2.saveDocument(target2);
            });
            LightEditorInfo lightEditorInfo = newInfo;
            if (lightEditorInfo == null) {
                LightEditorManagerImpl.$$$reportNull$$$0(26);
            }
            return lightEditorInfo;
        }
        LightEditorInfo lightEditorInfo = info2;
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(27);
        }
        return lightEditorInfo;
    }

    @Nullable
    LightEditorInfo getEditorInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(28);
        }
        return (LightEditorInfo)ContainerUtil.find(this.myEditors, editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public void reloadFile(@NotNull VirtualFile file2) {
        LightEditorInfo editorInfo;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(29);
        }
        if ((editorInfo = this.getEditorInfo(file2)) != null) {
            file2.refresh(false, false);
            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file2});
        }
    }

    private void checkUpdate(@NotNull Editor editor) {
        LightEditorInfo editorInfo;
        if (editor == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(30);
        }
        if ((editorInfo = this.findEditor(editor)) != null && !editorInfo.isUnsaved()) {
            this.reloadFile(editorInfo.getFile());
        }
    }

    @Nullable
    private LightEditorInfo findEditor(@NotNull Editor editor) {
        if (editor == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(31);
        }
        for (LightEditorInfo editorInfo : this.myEditors) {
            FileEditor fileEditor = editorInfo.getFileEditor();
            if (!(fileEditor instanceof TextEditor) || editor != ((TextEditor)fileEditor).getEditor()) continue;
            return editorInfo;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getUniqueName$10(String candidate, LightEditorInfo editorInfo) {
        return editorInfo.getFile().getName().equals(candidate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 15: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedEditors";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "saveAs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setImplicitSaveEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "closeEditor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireFileStatusChanged";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findOpen";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitSaveAllowed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "saveAs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEditorInfo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reloadFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkUpdate";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

