/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.BgProgressIndicator;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.wm.ex.StatusBarEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InstallPluginInfo {
    @NotNull
    public final BgProgressIndicator indicator;
    @NotNull
    private final IdeaPluginDescriptor myDescriptor;
    @Nullable
    private MyPluginModel myPluginModel;
    public final boolean install;
    private TaskInfo myStatusBarTaskInfo;
    private boolean myClosed;
    private static boolean myShowRestart;
    private IdeaPluginDescriptorImpl myInstalledDescriptor;

    InstallPluginInfo(@NotNull BgProgressIndicator indicator2, @NotNull IdeaPluginDescriptor descriptor2, @NotNull MyPluginModel pluginModel, boolean install2) {
        if (indicator2 == null) {
            InstallPluginInfo.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            InstallPluginInfo.$$$reportNull$$$0(1);
        }
        if (pluginModel == null) {
            InstallPluginInfo.$$$reportNull$$$0(2);
        }
        this.indicator = indicator2;
        this.myDescriptor = descriptor2;
        this.myPluginModel = pluginModel;
        this.install = install2;
    }

    public synchronized void toBackground(@Nullable StatusBarEx statusBar2) {
        this.myPluginModel = null;
        this.indicator.removeStateDelegates();
        if (statusBar2 != null) {
            String title2 = this.install ? IdeBundle.message((String)"dialog.title.installing.plugin", (Object[])new Object[]{this.myDescriptor.getName()}) : IdeBundle.message((String)"dialog.title.updating.plugin", (Object[])new Object[]{this.myDescriptor.getName()});
            this.myStatusBarTaskInfo = OneLineProgressIndicator.task(title2);
            statusBar2.addProgress(this.indicator, this.myStatusBarTaskInfo);
        }
    }

    public synchronized void fromBackground(@NotNull MyPluginModel pluginModel) {
        if (pluginModel == null) {
            InstallPluginInfo.$$$reportNull$$$0(3);
        }
        this.myPluginModel = pluginModel;
        myShowRestart = false;
        this.closeStatusBarIndicator();
    }

    public static void showRestart() {
        myShowRestart = true;
    }

    public synchronized void finish(boolean success2, boolean cancel, boolean showErrors2, boolean restartRequired) {
        if (this.myClosed) {
            return;
        }
        if (this.myPluginModel == null) {
            MyPluginModel.finishInstall(this.myDescriptor);
            this.closeStatusBarIndicator();
            if (success2 && !cancel && restartRequired) {
                myShowRestart = true;
            }
            if (MyPluginModel.myInstallingInfos.isEmpty() && myShowRestart) {
                myShowRestart = false;
                ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp());
            }
        } else if (!cancel) {
            this.myPluginModel.finishInstall(this.myDescriptor, this.myInstalledDescriptor, success2, showErrors2, restartRequired);
        }
    }

    private void closeStatusBarIndicator() {
        if (this.myStatusBarTaskInfo != null) {
            this.indicator.finish(this.myStatusBarTaskInfo);
            this.myStatusBarTaskInfo = null;
        }
    }

    public void close() {
        this.myClosed = true;
    }

    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public void setInstalledDescriptor(IdeaPluginDescriptorImpl installedDescriptor) {
        this.myInstalledDescriptor = installedDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/InstallPluginInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fromBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

