/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.NewUiUtil;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.ProjectDependentPluginEnabledState;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SelectionBasedPluginModelAction;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPluginComponent
extends JPanel {
    public static final Color DisabledColor = JBColor.namedColor((String)"Plugins.disabledForeground", (Color)new JBColor(0xB1B1B1, 0x696969));
    public static final Color GRAY_COLOR = JBColor.namedColor((String)"Label.infoForeground", (Color)new JBColor((Color)Gray._120, (Color)Gray._135));
    public static final Color SELECTION_COLOR = JBColor.namedColor((String)"Plugins.lightSelectionBackground", (Color)new JBColor(15595262, 4606541));
    public static final Color HOVER_COLOR = JBColor.namedColor((String)"Plugins.hoverBackground", (Color)new JBColor(15595262, 4606541));
    private static final Ref<Boolean> HANDLE_FOCUS_ON_SELECTION = Ref.create((Object)Boolean.TRUE);
    private final MyPluginModel myPluginModel;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    @NotNull
    private IdeaPluginDescriptor myPlugin;
    private boolean myOnlyUpdateMode;
    public IdeaPluginDescriptor myUpdateDescriptor;
    private final JLabel myNameComponent;
    private final JLabel myIconComponent;
    private final BaselineLayout myLayout;
    protected JButton myRestartButton;
    protected InstallButton myInstallButton;
    protected JButton myUpdateButton;
    private JComponent myEnableDisableButton;
    private JCheckBox myChooseUpdateButton;
    private JComponent myAlignButton;
    private JPanel myMetricsPanel;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel myVersion;
    private JLabel myVendor;
    private LicensePanel myLicensePanel;
    private LicensePanel myUpdateLicensePanel;
    private JPanel myErrorPanel;
    private JComponent myErrorComponent;
    private OneLineProgressIndicator myIndicator;
    private EventHandler myEventHandler;
    @NotNull
    protected EventHandler.SelectionType mySelection;

    public ListPluginComponent(@NotNull MyPluginModel pluginModel, @NotNull IdeaPluginDescriptor plugin2, @NotNull LinkListener<Object> searchListener, boolean marketplace) {
        if (pluginModel == null) {
            ListPluginComponent.$$$reportNull$$$0(0);
        }
        if (plugin2 == null) {
            ListPluginComponent.$$$reportNull$$$0(1);
        }
        if (searchListener == null) {
            ListPluginComponent.$$$reportNull$$$0(2);
        }
        this.myNameComponent = new JLabel();
        this.myIconComponent = new JLabel(AllIcons.Plugins.PluginLogo);
        this.myLayout = new BaselineLayout();
        this.mySelection = EventHandler.SelectionType.NONE;
        this.myPlugin = plugin2;
        this.myPluginModel = pluginModel;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        pluginModel.addComponent(this);
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)((Object)this.myLayout));
        this.myIconComponent.setVerticalAlignment(1);
        this.myIconComponent.setOpaque(false);
        this.myLayout.setIconComponent(this.myIconComponent);
        this.myNameComponent.setText(this.myPlugin.getName());
        this.myLayout.setNameComponent((JLabel)RelativeFont.BOLD.install((Component)this.myNameComponent));
        this.createTag();
        this.createButtons();
        this.createMetricsPanel();
        this.createLicensePanel();
        if (marketplace) {
            this.updateIcon(false, false);
        } else {
            this.updateErrors();
        }
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    @NotNull
    EventHandler.SelectionType getSelection() {
        EventHandler.SelectionType selectionType = this.mySelection;
        if (selectionType == null) {
            ListPluginComponent.$$$reportNull$$$0(3);
        }
        return selectionType;
    }

    void setSelection(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(4);
        }
        this.setSelection(type, type == EventHandler.SelectionType.SELECTION);
    }

    void setSelection(@NotNull EventHandler.SelectionType type, boolean scrollAndFocus) {
        JComponent parent;
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(5);
        }
        this.mySelection = type;
        if (scrollAndFocus && (parent = (JComponent)this.getParent()) != null) {
            ListPluginComponent.scrollToVisible(parent, this.getBounds());
            if (type == EventHandler.SelectionType.SELECTION && ((Boolean)HANDLE_FOCUS_ON_SELECTION.get()).booleanValue()) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
            }
        }
        this.updateColors(type);
        this.repaint();
    }

    void onSelection(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ListPluginComponent.$$$reportNull$$$0(6);
        }
        try {
            HANDLE_FOCUS_ON_SELECTION.set((Object)Boolean.FALSE);
            runnable2.run();
        }
        finally {
            HANDLE_FOCUS_ON_SELECTION.set((Object)Boolean.TRUE);
        }
    }

    private static void scrollToVisible(@NotNull JComponent parent, @NotNull Rectangle bounds2) {
        if (parent == null) {
            ListPluginComponent.$$$reportNull$$$0(7);
        }
        if (bounds2 == null) {
            ListPluginComponent.$$$reportNull$$$0(8);
        }
        if (!parent.getVisibleRect().contains(bounds2)) {
            parent.scrollRectToVisible(bounds2);
        }
    }

    private void createButtons() {
        if (this.myMarketplace) {
            if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                this.myInstallButton = new InstallButton(false);
                this.myLayout.addButtonComponent(this.myInstallButton);
                this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, null, ModalityState.stateForComponent((Component)this.myInstallButton)));
                this.myInstallButton.setEnabled(PluginManagerCore.getPlugin(this.myPlugin.getPluginId()) == null, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
                ColorButton.setWidth72(this.myInstallButton);
            }
        } else {
            if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted()) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
                this.myPluginModel.addUninstalled(this.myPlugin);
            } else {
                PluginId id2;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                if (pluginsState.wasInstalled(id2 = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id2)) {
                    this.myRestartButton = new RestartButton(this.myPluginModel);
                    this.myLayout.addButtonComponent(this.myRestartButton);
                } else {
                    if (Registry.is((String)"ide.plugins.per.project", (boolean)false) && !Registry.is((String)"ide.plugins.per.project.use.checkboxes", (boolean)false)) {
                        this.myEnableDisableButton = SelectionBasedPluginModelAction.createGearButton(action2 -> this.createEnableDisableAction((PluginEnableDisableAction)((Object)action2), (List<? extends ListPluginComponent>)List.of(this)), () -> this.createUninstallAction(List.of(this)));
                        this.myEnableDisableButton.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
                        this.myEnableDisableButton.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
                    } else {
                        this.myEnableDisableButton = ListPluginComponent.createEnableDisableButton(__ -> this.myPluginModel.setEnabledState(List.of(this.myPlugin), PluginEnableDisableAction.globally(this.myPluginModel.getState(this.myPlugin).isDisabled())));
                    }
                    this.myLayout.addButtonComponent(this.myEnableDisableButton);
                    this.myEnableDisableButton.setOpaque(false);
                    this.updateEnabledStateUI();
                }
            }
            this.myAlignButton = new JComponent(){

                @Override
                public Dimension getPreferredSize() {
                    return ListPluginComponent.this.myEnableDisableButton instanceof JCheckBox ? ListPluginComponent.this.myEnableDisableButton.getPreferredSize() : super.getPreferredSize();
                }
            };
            this.myLayout.addButtonComponent(this.myAlignButton);
            this.myAlignButton.setOpaque(false);
        }
    }

    @NotNull
    private static JCheckBox createEnableDisableButton(final @NotNull ActionListener listener2) {
        if (listener2 == null) {
            ListPluginComponent.$$$reportNull$$$0(9);
        }
        return new JCheckBox(){
            private int myBaseline = -1;
            {
                this.addActionListener(listener2);
            }

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaseline == -1) {
                    JCheckBox checkBox2 = new JCheckBox("Foo", true);
                    Dimension size2 = checkBox2.getPreferredSize();
                    this.myBaseline = checkBox2.getBaseline(size2.width, size2.height) - JBUIScale.scale((int)1);
                }
                return this.myBaseline;
            }

            @Override
            public void setUI(ButtonUI ui2) {
                this.myBaseline = -1;
                super.setUI(ui2);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                return new Dimension(size2.width + JBUIScale.scale((int)8), size2.height + JBUIScale.scale((int)2));
            }
        };
    }

    private void createMetricsPanel() {
        String vendor;
        this.myMetricsPanel = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(JBUIScale.scale((int)7))));
        this.myMetricsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myLayout.addLineComponent(this.myMetricsPanel);
        if (this.myMarketplace) {
            String rating;
            assert (this.myPlugin instanceof PluginNode);
            PluginNode pluginNode = (PluginNode)this.myPlugin;
            String downloads = pluginNode.getPresentableDownloads();
            if (downloads != null) {
                this.myDownloads = ListPluginComponent.createRatingLabel(this.myMetricsPanel, downloads, AllIcons.Plugins.Downloads);
            }
            if ((rating = pluginNode.getPresentableRating()) != null) {
                this.myRating = ListPluginComponent.createRatingLabel(this.myMetricsPanel, rating, AllIcons.Plugins.Rating);
            }
        } else {
            String version2;
            String string = version2 = this.myPlugin.isBundled() ? IdeBundle.message((String)"plugin.status.bundled", (Object[])new Object[0]) : this.myPlugin.getVersion();
            if (!StringUtil.isEmptyOrSpaces((String)version2)) {
                this.myVersion = ListPluginComponent.createRatingLabel(this.myMetricsPanel, version2, null);
            }
        }
        String string = vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myVendor = ListPluginComponent.createRatingLabel(this.myMetricsPanel, "fix_label", vendor, null, null, true);
        }
    }

    private void createTag() {
        List<String> tags = PluginManagerConfigurable.getTags(this.myPlugin);
        if (!tags.isEmpty()) {
            TagComponent tagComponent = this.createTagComponent(tags.get(0));
            this.myLayout.setTagComponent((JComponent)((Object)PluginManagerConfigurable.setTinyFont(tagComponent)));
        }
    }

    @NotNull
    private TagComponent createTagComponent(@Nls @NotNull String tag2) {
        if (tag2 == null) {
            ListPluginComponent.$$$reportNull$$$0(10);
        }
        TagComponent component2 = new TagComponent(tag2);
        component2.setListener(this.mySearchListener, (Object)component2);
        TagComponent tagComponent = component2;
        if (tagComponent == null) {
            ListPluginComponent.$$$reportNull$$$0(11);
        }
        return tagComponent;
    }

    private void setTagTooltip(@Nullable @Nls String text2) {
        if (this.myLayout.myTagComponent != null) {
            this.myLayout.myTagComponent.setToolTipText(text2);
        }
    }

    private void createLicensePanel() {
        String productCode = this.myPlugin.getProductCode();
        LicensingFacade instance = LicensingFacade.getInstance();
        if (this.myMarketplace || productCode == null || instance == null || this.myPlugin.isBundled() || LicensePanel.isEA2Product(productCode)) {
            return;
        }
        LicensePanel licensePanel = new LicensePanel(true);
        String stamp = instance.getConfirmationStamp(productCode);
        if (stamp == null) {
            if (ApplicationManager.getApplication().isEAP()) {
                this.setTagTooltip(IdeBundle.message((String)"label.text.plugin.eap.license.not.required", (Object[])new Object[0]));
                return;
            }
            licensePanel.setText(IdeBundle.message((String)"label.text.plugin.no.license", (Object[])new Object[0]), true, false);
        } else {
            licensePanel.setTextFromStamp(stamp, instance.getExpirationDate(productCode));
        }
        this.setTagTooltip(licensePanel.getMessage());
        if (licensePanel.isNotification()) {
            licensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
            this.myLayout.addLineComponent((JComponent)((Object)licensePanel));
            this.myLicensePanel = licensePanel;
        }
    }

    public void setOnlyUpdateMode() {
        this.myOnlyUpdateMode = true;
        this.removeButtons(false);
        this.myChooseUpdateButton = new JCheckBox((String)null, true);
        this.myLayout.setCheckBoxComponent(this.myChooseUpdateButton);
        this.myChooseUpdateButton.setOpaque(false);
        IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(this.myPlugin.getPluginId());
        if (descriptor2 != null) {
            if (this.myDownloads != null) {
                this.myMetricsPanel.remove(this.myDownloads);
            }
            if (this.myRating != null) {
                this.myMetricsPanel.remove(this.myRating);
            }
            if (this.myVendor != null) {
                this.myMetricsPanel.remove(this.myVendor);
            }
            if (this.myVersion != null) {
                this.myMetricsPanel.remove(this.myVendor);
            }
            String version2 = NewUiUtil.getVersion(descriptor2, this.myPlugin);
            String size2 = this.myPlugin instanceof PluginNode ? ((PluginNode)this.myPlugin).getPresentableSize() : null;
            this.myVersion = ListPluginComponent.createRatingLabel(this.myMetricsPanel, null, (String)(size2 != null ? version2 + " | " + size2 : version2), null, null, false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    public JCheckBox getChooseUpdateButton() {
        return this.myChooseUpdateButton;
    }

    public void setUpdateDescriptor(@Nullable IdeaPluginDescriptor descriptor2) {
        if (this.myUpdateDescriptor == null && descriptor2 == null) {
            return;
        }
        if (this.myIndicator != null || this.isRestartEnabled()) {
            return;
        }
        this.myUpdateDescriptor = descriptor2;
        if (descriptor2 == null) {
            if (this.myVersion != null) {
                this.myVersion.setText(this.myPlugin.getVersion());
            }
            if (this.myUpdateLicensePanel != null) {
                this.myLayout.removeLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                this.myUpdateLicensePanel = null;
            }
            if (this.myUpdateButton != null) {
                this.myUpdateButton.setVisible(false);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(false);
            }
        } else {
            if (this.myVersion != null) {
                this.myVersion.setText(NewUiUtil.getVersion(this.myPlugin, descriptor2));
            }
            if (this.myPlugin.getProductCode() == null && descriptor2.getProductCode() != null && !this.myPlugin.isBundled() && !LicensePanel.isEA2Product(descriptor2.getProductCode())) {
                if (this.myUpdateLicensePanel == null) {
                    this.myUpdateLicensePanel = new LicensePanel(true);
                    this.myLayout.addLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                    this.myUpdateLicensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
                    this.myUpdateLicensePanel.setVisible(this.myErrorPanel == null);
                    if (this.myEventHandler != null) {
                        this.myEventHandler.addAll((Component)((Object)this.myUpdateLicensePanel));
                    }
                }
                this.myUpdateLicensePanel.setText(IdeBundle.message((String)"label.next.plugin.version.is.paid.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]), true, false);
                this.myUpdateLicensePanel.showBuyPlugin(() -> this.myUpdateDescriptor);
                this.myUpdateLicensePanel.setVisible(true);
            }
            if (this.myUpdateButton == null) {
                this.myUpdateButton = new UpdateButton();
                this.myLayout.addButtonComponent(this.myUpdateButton, 0);
                this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, this.myUpdateDescriptor, ModalityState.stateForComponent((Component)this.myUpdateButton)));
            } else {
                this.myUpdateButton.setEnabled(true);
                this.myUpdateButton.setVisible(true);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(this.myEnableDisableButton != null && !this.myEnableDisableButton.isVisible());
            }
        }
        this.doLayout();
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            ListPluginComponent.$$$reportNull$$$0(12);
        }
        this.myEventHandler = eventHandler;
        eventHandler.addAll(this);
    }

    protected void updateColors(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(13);
        }
        this.updateColors(GRAY_COLOR, type == EventHandler.SelectionType.NONE ? PluginManagerConfigurable.MAIN_BG_COLOR : (type == EventHandler.SelectionType.HOVER ? HOVER_COLOR : SELECTION_COLOR));
    }

    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        Color color;
        if (grayedFg == null) {
            ListPluginComponent.$$$reportNull$$$0(14);
        }
        if (background == null) {
            ListPluginComponent.$$$reportNull$$$0(15);
        }
        this.setBackground(background);
        Color nameForeground = null;
        Color otherForeground = grayedFg;
        boolean calcColor = true;
        if (this.mySelection != EventHandler.SelectionType.NONE && (color = UIManager.getColor("Plugins.selectionForeground")) != null) {
            nameForeground = otherForeground = color;
            calcColor = false;
        }
        if (calcColor && !this.myMarketplace) {
            boolean disabled;
            boolean bl = disabled = this.myPluginModel.isUninstalled(this.myPlugin) || !MyPluginModel.isInstallingOrUpdate(this.myPlugin) && !this.isEnabledState();
            if (disabled) {
                nameForeground = otherForeground = DisabledColor;
            }
        }
        this.myNameComponent.setHorizontalTextPosition(2);
        this.myNameComponent.setForeground(nameForeground);
        if (this.myRating != null) {
            this.myRating.setForeground(otherForeground);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(otherForeground);
        }
        if (this.myVersion != null) {
            this.myVersion.setForeground(otherForeground);
        }
        if (this.myVendor != null) {
            this.myVendor.setForeground(otherForeground);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void updateErrors() {
        @Nls Ref enableAction = new Ref();
        String message2 = this.myOnlyUpdateMode ? null : this.myPluginModel.getErrorMessage(this.myPlugin, (Ref<? super String>)enableAction);
        boolean errors = message2 != null;
        this.updateIcon(errors, this.myPluginModel.isUninstalled(this.myPlugin) || !this.isEnabledState());
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(this.myRestartButton != null);
        }
        if (errors) {
            boolean addListeners2;
            boolean bl = addListeners2 = this.myErrorComponent == null && this.myEventHandler != null;
            if (this.myErrorPanel == null) {
                this.myErrorPanel = new NonOpaquePanel();
                this.myLayout.addLineComponent(this.myErrorPanel);
            }
            this.myErrorComponent = ErrorComponent.show(this.myErrorPanel, "Center", this.myErrorComponent, message2, (String)enableAction.get(), enableAction.isNull() ? null : () -> this.myPluginModel.enableRequiredPlugins(this.myPlugin));
            this.myErrorComponent.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            if (addListeners2) {
                this.myEventHandler.addAll(this.myErrorPanel);
            }
        } else if (this.myErrorPanel != null) {
            this.myLayout.removeLineComponent(this.myErrorPanel);
            this.myErrorPanel = null;
            this.myErrorComponent = null;
        }
        if (this.myLicensePanel != null) {
            this.myLicensePanel.setVisible(!errors);
        }
        if (this.myUpdateLicensePanel != null) {
            this.myUpdateLicensePanel.setVisible(!errors);
        }
    }

    protected void updateIcon(boolean errors, boolean disabled) {
        this.myIconComponent.setIcon(this.myPluginModel.getIcon(this.myPlugin, false, errors, disabled));
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, null, false, false, true));
        this.myLayout.setProgressComponent(this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress(boolean success2, boolean restartRequired) {
        this.myIndicator = null;
        this.myLayout.removeProgressComponent();
        if (success2) {
            if (restartRequired) {
                this.enableRestart();
            } else if (this.myInstallButton != null) {
                this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
            } else if (this.myUpdateButton != null) {
                this.myUpdateButton.setEnabled(false);
                this.myUpdateButton.setText(IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
            }
        }
        this.fullRepaint();
    }

    public void clearProgress() {
        this.myIndicator = null;
    }

    public void enableRestart() {
        this.removeButtons(true);
    }

    private void removeButtons(boolean showRestart) {
        if (this.myInstallButton != null) {
            this.myLayout.removeButtonComponent(this.myInstallButton);
            this.myInstallButton = null;
        }
        if (this.myUpdateButton != null) {
            this.myLayout.removeButtonComponent(this.myUpdateButton);
            this.myUpdateButton = null;
        }
        if (this.myEnableDisableButton != null) {
            this.myLayout.removeButtonComponent(this.myEnableDisableButton);
            this.myEnableDisableButton = null;
        }
        if (showRestart && this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myLayout.addButtonComponent(this.myRestartButton, 0);
        }
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(true);
        }
    }

    public void updateEnabledState() {
        if (!this.myPluginModel.isUninstalled(this.myPlugin)) {
            this.updateEnabledStateUI();
        }
        this.updateErrors();
        this.setSelection(this.mySelection, false);
    }

    private void updateEnabledStateUI() {
        ProjectDependentPluginEnabledState state = this.myPluginModel.getProjectDependentState(this.myPlugin);
        if (this.myEnableDisableButton instanceof JCheckBox) {
            ((JCheckBox)this.myEnableDisableButton).setSelected(state.isEnabled());
        }
        this.myNameComponent.setIcon(state.getIcon());
    }

    public void updateAfterUninstall(boolean needRestartForUninstall) {
        this.myPluginModel.addUninstalled(this.myPlugin);
        this.updateColors(this.mySelection);
        this.removeButtons(needRestartForUninstall);
    }

    public void updatePlugin() {
        if (!this.myMarketplace && this.myUpdateButton != null && this.myUpdateButton.isVisible() && this.myUpdateButton.isEnabled()) {
            this.myUpdateButton.doClick();
        }
    }

    private boolean isEnabledState() {
        return this.myPluginModel.isEnabled(this.myPlugin);
    }

    public boolean isMarketplace() {
        return this.myMarketplace;
    }

    public boolean isRestartEnabled() {
        return this.myRestartButton != null && this.myRestartButton.isVisible();
    }

    public boolean isUpdatedWithoutRestart() {
        return this.myUpdateButton != null && this.myUpdateButton.isVisible() && !this.myUpdateButton.isEnabled();
    }

    public boolean underProgress() {
        return this.myIndicator != null;
    }

    public void close() {
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }

    /*
     * WARNING - void declaration
     */
    public void createPopupMenu(@NotNull DefaultActionGroup group2, @NotNull List<? extends ListPluginComponent> selection) {
        void var5_12;
        if (group2 == null) {
            ListPluginComponent.$$$reportNull$$$0(16);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(17);
        }
        if (this.myOnlyUpdateMode) {
            return;
        }
        for (ListPluginComponent listPluginComponent : selection) {
            if (!MyPluginModel.isInstallingOrUpdate(listPluginComponent.myPlugin)) continue;
            return;
        }
        boolean restart = true;
        for (ListPluginComponent listPluginComponent : selection) {
            if (listPluginComponent.myRestartButton != null) continue;
            restart = false;
            break;
        }
        if (restart) {
            group2.add((AnAction)new ButtonAnAction(selection.get((int)0).myRestartButton));
            return;
        }
        int n = selection.size();
        if (this.myMarketplace) {
            JButton[] jButtonArray = new JButton[n];
            for (int i2 = 0; i2 < n; ++i2) {
                InstallButton button4 = selection.get((int)i2).myInstallButton;
                if (button4 == null || !button4.isVisible() || !button4.isEnabled()) {
                    return;
                }
                jButtonArray[i2] = button4;
            }
            group2.add((AnAction)new ButtonAnAction(jButtonArray));
            return;
        }
        JButton[] jButtonArray = new JButton[n];
        for (int i3 = 0; i3 < n; ++i3) {
            JButton button5 = selection.get((int)i3).myUpdateButton;
            if (button5 == null || !button5.isVisible() || !button5.isEnabled()) {
                Object var5_11 = null;
                break;
            }
            jButtonArray[i3] = button5;
        }
        if (var5_12 != null) {
            group2.add((AnAction)new ButtonAnAction((JButton[])var5_12));
            if (n > 1) {
                return;
            }
        }
        SelectionBasedPluginModelAction.addActionsTo(group2, action2 -> this.createEnableDisableAction((PluginEnableDisableAction)((Object)((Object)action2)), selection), () -> this.createUninstallAction(selection));
    }

    public void handleKeyAction(@NotNull KeyEvent event, @NotNull List<? extends ListPluginComponent> selection) {
        boolean bl;
        if (event == null) {
            ListPluginComponent.$$$reportNull$$$0(18);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(19);
        }
        if (this.myOnlyUpdateMode) {
            if (event.getKeyCode() == 32) {
                for (ListPluginComponent listPluginComponent : selection) {
                    listPluginComponent.myChooseUpdateButton.doClick();
                }
            }
            return;
        }
        for (ListPluginComponent listPluginComponent : selection) {
            if (!MyPluginModel.isInstallingOrUpdate(listPluginComponent.myPlugin)) continue;
            return;
        }
        boolean restart = true;
        for (ListPluginComponent listPluginComponent : selection) {
            if (listPluginComponent.myRestartButton != null) continue;
            restart = false;
            break;
        }
        int n = event.getKeyCode();
        if (this.myMarketplace) {
            if (n == 10) {
                if (restart) {
                    selection.get((int)0).myRestartButton.doClick();
                }
                for (ListPluginComponent listPluginComponent : selection) {
                    InstallButton installButton = listPluginComponent.myInstallButton;
                    if (installButton != null && installButton.isVisible() && installButton.isEnabled()) continue;
                    return;
                }
                for (ListPluginComponent listPluginComponent : selection) {
                    listPluginComponent.myInstallButton.doClick();
                }
            }
            return;
        }
        boolean bl2 = true;
        for (ListPluginComponent listPluginComponent : selection) {
            JButton button5 = listPluginComponent.myUpdateButton;
            if (button5 != null && button5.isVisible() && button5.isEnabled()) continue;
            bl = false;
            break;
        }
        if (n == 10) {
            if (restart) {
                selection.get((int)0).myRestartButton.doClick();
            } else if (bl) {
                for (ListPluginComponent listPluginComponent : selection) {
                    listPluginComponent.myUpdateButton.doClick();
                }
            }
        } else if (!restart && !bl) {
            SelectionBasedPluginModelAction.UninstallAction<ListPluginComponent> uninstallAction;
            SelectionBasedPluginModelAction selectionBasedPluginModelAction = n == 32 && event.getModifiersEx() == 0 ? this.createEnableDisableAction(this.getEnableDisableAction(selection), selection) : (uninstallAction = n == EventHandler.DELETE_CODE ? this.createUninstallAction(selection) : null);
            if (uninstallAction != null) {
                ActionManager.getInstance().tryToExecute(uninstallAction, (InputEvent)event, (Component)this, "unknown", true);
            }
        }
    }

    protected void fullRepaint() {
        Container parent = this.getParent();
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    @NotNull
    public final IdeaPluginDescriptor getPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myPlugin;
        if (ideaPluginDescriptor == null) {
            ListPluginComponent.$$$reportNull$$$0(20);
        }
        return ideaPluginDescriptor;
    }

    public final void setPluginDescriptor(@NotNull IdeaPluginDescriptor plugin2) {
        if (plugin2 == null) {
            ListPluginComponent.$$$reportNull$$$0(21);
        }
        this.myPlugin = plugin2;
    }

    @NotNull
    private PluginEnableDisableAction getEnableDisableAction(@NotNull List<? extends ListPluginComponent> selection) {
        Iterator<? extends ListPluginComponent> iterator2;
        BooleanSupplier isGloballyEnabledGenerator;
        boolean firstDisabled;
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(22);
        }
        boolean bl = firstDisabled = !(isGloballyEnabledGenerator = () -> this.lambda$getEnableDisableAction$11(iterator2 = selection.iterator())).getAsBoolean();
        while (iterator2.hasNext()) {
            if (firstDisabled != isGloballyEnabledGenerator.getAsBoolean()) continue;
            PluginEnableDisableAction pluginEnableDisableAction = PluginEnableDisableAction.ENABLE_GLOBALLY;
            if (pluginEnableDisableAction == null) {
                ListPluginComponent.$$$reportNull$$$0(23);
            }
            return pluginEnableDisableAction;
        }
        PluginEnableDisableAction pluginEnableDisableAction = PluginEnableDisableAction.globally(firstDisabled);
        if (pluginEnableDisableAction == null) {
            ListPluginComponent.$$$reportNull$$$0(24);
        }
        return pluginEnableDisableAction;
    }

    @NotNull
    private SelectionBasedPluginModelAction.EnableDisableAction<ListPluginComponent> createEnableDisableAction(@NotNull PluginEnableDisableAction action2, @NotNull List<? extends ListPluginComponent> selection) {
        if (action2 == null) {
            ListPluginComponent.$$$reportNull$$$0(25);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(26);
        }
        return new SelectionBasedPluginModelAction.EnableDisableAction<ListPluginComponent>(this.myPluginModel, action2, true, selection, ListPluginComponent::getPluginDescriptor);
    }

    @NotNull
    private SelectionBasedPluginModelAction.UninstallAction<ListPluginComponent> createUninstallAction(@NotNull List<? extends ListPluginComponent> selection) {
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(27);
        }
        return new SelectionBasedPluginModelAction.UninstallAction<ListPluginComponent>(this.myPluginModel, true, this, selection, ListPluginComponent::getPluginDescriptor);
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @NotNull @Nls String text2, @Nullable Icon icon2) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(29);
        }
        return ListPluginComponent.createRatingLabel(panel2, null, text2, icon2, null, true);
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @Nullable Object constraints2, @NotNull @Nls String text2, @Nullable Icon icon2, @Nullable Color color, boolean tiny) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(30);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(31);
        }
        JLabel label2 = new JLabel(text2, icon2, 0);
        label2.setOpaque(false);
        label2.setIconTextGap(2);
        if (color != null) {
            label2.setForeground(color);
        }
        panel2.add((Component)(tiny ? PluginManagerConfigurable.setTinyFont(label2) : label2), constraints2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            ListPluginComponent.$$$reportNull$$$0(32);
        }
        return jLabel;
    }

    private /* synthetic */ boolean lambda$getEnableDisableAction$11(Iterator iterator2) {
        return this.myPluginModel.getState(((ListPluginComponent)iterator2.next()).getPluginDescriptor()) == PluginEnabledState.ENABLED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 3: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnableDisableAction";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createRatingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 32: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onSelection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEnableDisableButton";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTagComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEnableDisableAction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEnableDisableAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createUninstallAction";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createRatingLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BaselineLayout
    extends AbstractLayoutManager {
        private final JBValue myHGap = new JBValue.Float(10.0f);
        private final JBValue myHOffset = new JBValue.Float(8.0f);
        private final JBValue myButtonOffset = new JBValue.Float(6.0f);
        private JComponent myIconComponent;
        private JLabel myNameComponent;
        private JComponent myProgressComponent;
        private JComponent myTagComponent;
        private JComponent myCheckBoxComponent;
        private final List<JComponent> myButtonComponents = new ArrayList<JComponent>();
        private final List<JComponent> myLineComponents = new ArrayList<JComponent>();
        private boolean[] myButtonEnableStates;

        private BaselineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension(this.myNameComponent.getPreferredSize());
            if (this.myProgressComponent == null) {
                int count;
                if (this.myCheckBoxComponent != null) {
                    Dimension size2 = this.myCheckBoxComponent.getPreferredSize();
                    result2.width += size2.width + this.myHOffset.get();
                    result2.height = Math.max(result2.height, size2.height);
                }
                if (this.myTagComponent != null) {
                    Dimension size2 = this.myTagComponent.getPreferredSize();
                    result2.width += size2.width + 2 * this.myHOffset.get();
                    result2.height = Math.max(result2.height, size2.height);
                }
                if ((count = this.myButtonComponents.size()) > 0) {
                    int visibleCount = 0;
                    for (Component component2 : this.myButtonComponents) {
                        if (!component2.isVisible()) continue;
                        Dimension size3 = component2.getPreferredSize();
                        result2.width += size3.width;
                        result2.height = Math.max(result2.height, size3.height);
                        ++visibleCount;
                    }
                    if (visibleCount > 0) {
                        result2.width += this.myHOffset.get();
                        result2.width += (visibleCount - 1) * this.myButtonOffset.get();
                    }
                }
            } else {
                Dimension size4 = this.myProgressComponent.getPreferredSize();
                result2.width += this.myHOffset.get() + size4.width;
                result2.height = Math.max(result2.height, size4.height);
            }
            for (JComponent component3 : this.myLineComponents) {
                if (!component3.isVisible()) continue;
                Dimension size5 = component3.getPreferredSize();
                result2.width = Math.max(result2.width, size5.width);
                result2.height += size5.height;
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            result2.width += iconSize.width + this.myHGap.get();
            result2.height = Math.max(result2.height, iconSize.height);
            JBInsets.addTo((Dimension)result2, (Insets)ListPluginComponent.this.getInsets());
            return result2;
        }

        public void layoutContainer(Container parent) {
            Insets insets = ListPluginComponent.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            if (this.myProgressComponent == null && this.myCheckBoxComponent != null) {
                Dimension size2 = this.myCheckBoxComponent.getPreferredSize();
                this.myCheckBoxComponent.setBounds(x, (parent.getHeight() - size2.height) / 2, size2.width, size2.height);
                x += size2.width + this.myHGap.get();
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            this.myIconComponent.setBounds(x, y, iconSize.width, iconSize.height);
            x += iconSize.width + this.myHGap.get();
            int calcNameWidth = this.calculateNameWidth();
            Dimension nameSize = this.myNameComponent.getPreferredSize();
            int baseline = (y += JBUIScale.scale((int)2)) + this.myNameComponent.getBaseline(nameSize.width, nameSize.height);
            this.myNameComponent.setToolTipText(calcNameWidth < nameSize.width ? this.myNameComponent.getText() : null);
            nameSize.width = Math.min(nameSize.width, calcNameWidth);
            this.myNameComponent.setBounds(x, y, nameSize.width, nameSize.height);
            y += nameSize.height;
            int width = ListPluginComponent.this.getWidth();
            if (this.myProgressComponent == null) {
                if (this.myTagComponent != null) {
                    this.setBaselineBounds(x + nameSize.width + this.myHOffset.get(), baseline, this.myTagComponent, this.myTagComponent.getPreferredSize());
                }
                int lastX = width - insets.right;
                for (int i2 = this.myButtonComponents.size() - 1; i2 >= 0; --i2) {
                    Component component2 = this.myButtonComponents.get(i2);
                    if (!component2.isVisible()) continue;
                    Dimension size3 = component2.getPreferredSize();
                    this.setBaselineBounds(lastX -= size3.width, baseline, component2, size3);
                    lastX -= this.myButtonOffset.get();
                }
            } else {
                Dimension size4 = this.myProgressComponent.getPreferredSize();
                this.setBaselineBounds(width - size4.width - insets.right, baseline, this.myProgressComponent, size4);
            }
            int lineWidth = width - x - insets.right;
            for (JComponent jComponent : this.myLineComponents) {
                if (!jComponent.isVisible()) continue;
                int lineHeight = jComponent.getPreferredSize().height;
                jComponent.setBounds(x, y, lineWidth, lineHeight);
                y += lineHeight;
            }
        }

        private int calculateNameWidth() {
            Insets insets = ListPluginComponent.this.getInsets();
            int width = ListPluginComponent.this.getWidth() - insets.left - insets.right - this.myIconComponent.getPreferredSize().width - this.myHGap.get();
            if (this.myProgressComponent != null) {
                return width - this.myProgressComponent.getPreferredSize().width - this.myHOffset.get();
            }
            if (this.myCheckBoxComponent != null) {
                width -= this.myCheckBoxComponent.getPreferredSize().width + this.myHOffset.get();
            }
            if (this.myTagComponent != null) {
                width -= this.myTagComponent.getPreferredSize().width + 2 * this.myHOffset.get();
            }
            int visibleCount = 0;
            for (Component component2 : this.myButtonComponents) {
                if (!component2.isVisible()) continue;
                width -= component2.getPreferredSize().width;
                ++visibleCount;
            }
            width -= this.myButtonOffset.get() * (visibleCount - 1);
            if (visibleCount > 0) {
                width -= this.myHOffset.get();
            }
            return width;
        }

        private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension size2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(0);
            }
            if (size2 == null) {
                BaselineLayout.$$$reportNull$$$0(1);
            }
            if (component2 instanceof ActionToolbar) {
                component2.setBounds(x, ListPluginComponent.this.getInsets().top - JBUI.scale((int)1), size2.width, size2.height);
            } else {
                component2.setBounds(x, y - component2.getBaseline(size2.width, size2.height), size2.width, size2.height);
            }
        }

        public void setIconComponent(@NotNull JComponent iconComponent) {
            if (iconComponent == null) {
                BaselineLayout.$$$reportNull$$$0(2);
            }
            assert (this.myIconComponent == null);
            this.myIconComponent = iconComponent;
            ListPluginComponent.this.add(iconComponent);
        }

        public void setNameComponent(@NotNull JLabel nameComponent) {
            if (nameComponent == null) {
                BaselineLayout.$$$reportNull$$$0(3);
            }
            assert (this.myNameComponent == null);
            this.myNameComponent = nameComponent;
            ListPluginComponent.this.add(this.myNameComponent);
        }

        public void setTagComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(4);
            }
            assert (this.myTagComponent == null);
            this.myTagComponent = component2;
            ListPluginComponent.this.add(this.myTagComponent);
        }

        public void addLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(5);
            }
            this.myLineComponents.add(component2);
            ListPluginComponent.this.add(component2);
        }

        public void removeLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(6);
            }
            this.myLineComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
        }

        public void addButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(7);
            }
            this.addButtonComponent(component2, -1);
        }

        public void addButtonComponent(@NotNull JComponent component2, int index2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(8);
            }
            if (this.myButtonComponents.isEmpty() || index2 == -1) {
                this.myButtonComponents.add(component2);
            } else {
                this.myButtonComponents.add(index2, component2);
            }
            ListPluginComponent.this.add(component2);
            this.updateVisibleOther();
        }

        public void removeButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(9);
            }
            this.myButtonComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
            this.updateVisibleOther();
        }

        public void setCheckBoxComponent(@NotNull JComponent checkBoxComponent) {
            if (checkBoxComponent == null) {
                BaselineLayout.$$$reportNull$$$0(10);
            }
            assert (this.myCheckBoxComponent == null);
            this.myCheckBoxComponent = checkBoxComponent;
            ListPluginComponent.this.add(checkBoxComponent);
            ListPluginComponent.this.doLayout();
        }

        public void setProgressComponent(@NotNull JComponent progressComponent) {
            if (progressComponent == null) {
                BaselineLayout.$$$reportNull$$$0(11);
            }
            assert (this.myProgressComponent == null);
            this.myProgressComponent = progressComponent;
            ListPluginComponent.this.add(progressComponent);
            if (ListPluginComponent.this.myEventHandler != null) {
                ListPluginComponent.this.myEventHandler.addAll(progressComponent);
                ListPluginComponent.this.myEventHandler.updateHover(ListPluginComponent.this);
            }
            this.setVisibleOther(false);
            ListPluginComponent.this.doLayout();
        }

        public void removeProgressComponent() {
            if (this.myProgressComponent == null) {
                return;
            }
            ListPluginComponent.this.remove(this.myProgressComponent);
            this.myProgressComponent = null;
            this.setVisibleOther(true);
            ListPluginComponent.this.doLayout();
        }

        private void updateVisibleOther() {
            if (this.myProgressComponent != null) {
                this.myButtonEnableStates = null;
                this.setVisibleOther(false);
            }
        }

        private void setVisibleOther(boolean value2) {
            if (this.myTagComponent != null) {
                this.myTagComponent.setVisible(value2);
            }
            if (this.myButtonComponents.isEmpty()) {
                return;
            }
            if (value2) {
                assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
                int size2 = this.myButtonComponents.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    this.myButtonComponents.get(i2).setVisible(this.myButtonEnableStates[i2]);
                }
                this.myButtonEnableStates = null;
            } else {
                assert (this.myButtonEnableStates == null);
                this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
                int size3 = this.myButtonComponents.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    Component component2 = this.myButtonComponents.get(i3);
                    this.myButtonEnableStates[i3] = component2.isVisible();
                    component2.setVisible(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkBoxComponent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$BaselineLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBaselineBounds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIconComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setNameComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTagComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLineComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeLineComponent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addButtonComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeButtonComponent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setCheckBoxComponent";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProgressComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ButtonAnAction
    extends DumbAwareAction {
        private final JButton[] myButtons;

        ButtonAnAction(JButton ... buttons) {
            if (buttons == null) {
                ButtonAnAction.$$$reportNull$$$0(0);
            }
            super(buttons[0].getText());
            this.myButtons = buttons;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAnAction.$$$reportNull$$$0(1);
            }
            for (JButton button4 : this.myButtons) {
                button4.doClick();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttons";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$ButtonAnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

