/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SearchQueryParser {
    public String searchQuery;

    protected void addToSearchQuery(@NotNull String query2) {
        if (query2 == null) {
            SearchQueryParser.$$$reportNull$$$0(0);
        }
        this.searchQuery = this.searchQuery == null ? query2 : this.searchQuery + " " + query2;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query2) {
        if (query2 == null) {
            SearchQueryParser.$$$reportNull$$$0(1);
        }
        ArrayList<String> words = new ArrayList<String>();
        int length = query2.length();
        int index2 = 0;
        block0: while (index2 < length) {
            char startCh;
            if ((startCh = query2.charAt(index2++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query2.indexOf(34, index2);
                if (end == -1) break;
                words.add(query2.substring(index2, end));
                index2 = end + 1;
                continue;
            }
            int start2 = index2 - 1;
            while (index2 <= length) {
                char nextCh;
                if (index2 == length) {
                    words.add(query2.substring(start2));
                    continue block0;
                }
                if ((nextCh = query2.charAt(index2++)) != ':' && nextCh != ' ' && index2 != length) continue;
                words.add(query2.substring(start2, nextCh == ' ' ? index2 - 1 : index2));
                continue block0;
            }
        }
        ArrayList<String> arrayList = words;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static String getTagQuery(@NotNull String tag2) {
        if (tag2 == null) {
            SearchQueryParser.$$$reportNull$$$0(3);
        }
        String string = "/tag:" + (tag2.indexOf(32) == -1 ? tag2 : StringUtil.wrapWithDoubleQuote((String)tag2));
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String wrapAttribute(@NotNull String value2) {
        if (value2 == null) {
            SearchQueryParser.$$$reportNull$$$0(5);
        }
        String string = StringUtil.containsAnyChar((String)value2, (String)" ,:") ? StringUtil.wrapWithDoubleQuote((String)value2) : value2;
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitQuery";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagQuery";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToSearchQuery";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitQuery";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTagQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Installed
    extends SearchQueryParser {
        public final Set<String> vendors;
        public final Set<String> tags;
        public boolean enabled;
        public boolean disabled;
        public boolean bundled;
        public boolean downloaded;
        public boolean invalid;
        public boolean needUpdate;
        public boolean attributes;

        public Installed(@NotNull String query2) {
            if (query2 == null) {
                Installed.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.tags = new HashSet<String>();
            this.parse(query2);
        }

        private void parse(@NotNull String query2) {
            List<String> words;
            int size2;
            if (query2 == null) {
                Installed.$$$reportNull$$$0(1);
            }
            if ((size2 = (words = Installed.splitQuery(query2)).size()) == 0) {
                return;
            }
            int index2 = 0;
            while (index2 < size2) {
                String name;
                if ((name = words.get(index2++)).startsWith("/")) {
                    if (name.equals(SearchWords.ORGANIZATION.getValue()) || name.equals(SearchWords.TAG.getValue())) {
                        if (index2 < size2) {
                            this.handleAttribute(name, words.get(index2++));
                            continue;
                        }
                        this.addToSearchQuery(query2);
                        break;
                    }
                    this.handleAttribute(name, "");
                    continue;
                }
                this.addToSearchQuery(name);
            }
            this.attributes = this.enabled || this.disabled || this.bundled || this.downloaded || this.invalid || this.needUpdate;
        }

        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
            if (name == null) {
                Installed.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                Installed.$$$reportNull$$$0(3);
            }
            if ("/enabled".equals(name)) {
                this.enabled = true;
            } else if ("/disabled".equals(name)) {
                this.disabled = true;
            } else if ("/bundled".equals(name)) {
                this.bundled = true;
            } else if ("/downloaded".equals(name)) {
                this.downloaded = true;
            } else if ("/invalid".equals(name)) {
                this.invalid = true;
            } else if ("/outdated".equals(name)) {
                this.needUpdate = true;
            } else if (SearchWords.ORGANIZATION.getValue().equals(name)) {
                this.vendors.add(value2);
            } else if (SearchWords.TAG.getValue().equals(name)) {
                this.tags.add(value2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Installed";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Marketplace
    extends SearchQueryParser {
        public final Set<String> vendors;
        public final Set<String> tags;
        public final Set<String> repositories;
        public String sortBy;

        public Marketplace(@NotNull String query2) {
            if (query2 == null) {
                Marketplace.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.tags = new HashSet<String>();
            this.repositories = new HashSet<String>();
            this.parse(query2);
        }

        private void parse(@NotNull String query2) {
            List<String> words;
            int size2;
            if (query2 == null) {
                Marketplace.$$$reportNull$$$0(1);
            }
            if ((size2 = (words = Marketplace.splitQuery(query2)).size()) == 0) {
                return;
            }
            if (size2 == 1) {
                this.addToSearchQuery(words.get(0));
                return;
            }
            int index2 = 0;
            while (index2 < size2) {
                String name;
                if ((name = words.get(index2++)).endsWith(":")) {
                    if (index2 < size2) {
                        this.handleAttribute(name, words.get(index2++));
                        continue;
                    }
                    this.addToSearchQuery(query2);
                    return;
                }
                this.addToSearchQuery(name);
            }
        }

        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
            if (name == null) {
                Marketplace.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                Marketplace.$$$reportNull$$$0(3);
            }
            if (name.equals(SearchWords.TAG.getValue())) {
                this.tags.add(value2);
            } else if (name.equals(SearchWords.SORT_BY.getValue())) {
                this.sortBy = value2;
            } else if (name.equals(SearchWords.REPOSITORY.getValue())) {
                this.repositories.add(value2);
            } else if (name.equals(SearchWords.ORGANIZATION.getValue())) {
                this.vendors.add(value2);
            }
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if ("featured".equals(this.sortBy)) {
                url.append("is_featured_search=true");
            } else if ("updated".equals(this.sortBy)) {
                url.append("orderBy=update+date");
            } else if ("downloads".equals(this.sortBy)) {
                url.append("orderBy=downloads");
            } else if ("rating".equals(this.sortBy)) {
                url.append("orderBy=rating");
            } else if ("name".equals(this.sortBy)) {
                url.append("orderBy=name");
            }
            for (String tag2 : this.tags) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag2));
            }
            for (String vendor : this.vendors) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("organization=").append(URLUtil.encodeURIComponent((String)vendor));
            }
            if (this.searchQuery != null) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            String string = url.toString();
            if (string == null) {
                Marketplace.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser$Marketplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Marketplace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleAttribute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

