/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.ScopeBasedTodosTreeBuilder;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;

public class ScopeBasedTodosPanel
extends TodoPanel {
    @NonNls
    private static final String SELECTED_SCOPE = "TODO_SCOPE";
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private ScopeChooserCombo myScopes;

    public ScopeBasedTodosPanel(Project project, TodoPanelSettings settings2, Content content2) {
        super(project, settings2, false, content2);
        ((JComboBox)this.myScopes.getChildComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeBasedTodosPanel.this.rebuildWithAlarm(ScopeBasedTodosPanel.this.myAlarm);
                PropertiesComponent.getInstance((Project)ScopeBasedTodosPanel.this.myProject).setValue(ScopeBasedTodosPanel.SELECTED_SCOPE, ScopeBasedTodosPanel.this.myScopes.getSelectedScopeName(), null);
            }
        });
        this.rebuildWithAlarm(this.myAlarm);
    }

    @Override
    protected JComponent createCenterComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JComponent component2 = super.createCenterComponent();
        panel2.add((Component)component2, "Center");
        String preselect = PropertiesComponent.getInstance((Project)this.myProject).getValue(SELECTED_SCOPE);
        this.myScopes = new ScopeChooserCombo(this.myProject, false, true, preselect);
        Disposer.register((Disposable)this, (Disposable)this.myScopes);
        this.myScopes.setCurrentSelection(false);
        this.myScopes.setUsageView(false);
        JPanel chooserPanel = new JPanel(new GridBagLayout());
        JLabel scopesLabel = new JLabel(IdeBundle.message((String)"label.scope", (Object[])new Object[0]));
        scopesLabel.setDisplayedMnemonic('S');
        scopesLabel.setLabelFor((Component)((Object)this.myScopes));
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)8, (int)2, (int)4), 0, 0);
        chooserPanel.add((Component)scopesLabel, gc);
        gc.insets = JBUI.insets((int)2);
        chooserPanel.add((Component)((Object)this.myScopes), gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        chooserPanel.add((Component)Box.createHorizontalBox(), gc);
        panel2.add((Component)chooserPanel, "North");
        return panel2;
    }

    @Override
    protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
        ScopeBasedTodosTreeBuilder builder2 = new ScopeBasedTodosTreeBuilder(tree, project, this.myScopes);
        builder2.init();
        return builder2;
    }
}

