/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.NotABooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class PluginBooleanOptionDescriptor
extends BooleanOptionDescription
implements BooleanOptionDescription.RequiresRebuild,
NotABooleanOptionDescription {
    private static final Notifier ourRestartNeededNotifier = new Notifier();
    private final IdeaPluginDescriptor plugin;

    PluginBooleanOptionDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(0);
        }
        super(IdeBundle.message((String)"search.everywhere.command.plugins", (Object[])new Object[]{descriptor2.getName()}), "preferences.pluginManager");
        this.plugin = descriptor2;
    }

    public boolean isOptionEnabled() {
        return this.plugin.isEnabled();
    }

    public void setOptionState(boolean enabled) {
        PluginBooleanOptionDescriptor.togglePluginState(enabled, Set.of(this.plugin));
    }

    public static void togglePluginState(boolean enabled, @NotNull Set<IdeaPluginDescriptor> plugins2) {
        if (plugins2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(1);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        HashSet<IdeaPluginDescriptor> autoSwitchedIds = new HashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor descriptor2 : plugins2) {
            Set<IdeaPluginDescriptor> descriptors2 = enabled ? PluginBooleanOptionDescriptor.getPluginsIdsToEnable(descriptor2, pluginIdMap) : PluginBooleanOptionDescriptor.getPluginsIdsToDisable(descriptor2, pluginIdMap);
            autoSwitchedIds.addAll(descriptors2);
        }
        boolean enabledWithoutRestart = ProjectPluginTrackerManager.getInstance().updatePluginsState(autoSwitchedIds, PluginEnableDisableAction.globally(enabled));
        if (autoSwitchedIds.size() > plugins2.size()) {
            PluginBooleanOptionDescriptor.showAutoSwitchNotification(plugins2, autoSwitchedIds, enabled);
        }
        if (!enabledWithoutRestart) {
            ourRestartNeededNotifier.showNotification();
        }
    }

    private static void showAutoSwitchNotification(@NotNull Collection<? extends IdeaPluginDescriptor> plugins2, final @NotNull Collection<? extends IdeaPluginDescriptor> autoSwitchedPlugins, final boolean enabled) {
        if (plugins2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(2);
        }
        if (autoSwitchedPlugins == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(3);
        }
        String dependenciesString = PluginBooleanOptionDescriptor.joinPluginNames(autoSwitchedPlugins);
        String titleKey = enabled ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title";
        String contentKey = enabled ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content";
        String pluginString = PluginBooleanOptionDescriptor.joinPluginNames(plugins2);
        final Notification switchNotification = NotificationGroupManager.getInstance().getNotificationGroup("Plugins AutoSwitch").createNotification(IdeBundle.message((String)contentKey, (Object[])new Object[]{pluginString, dependenciesString}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)titleKey, (Object[])new Object[0])).addAction((AnAction)new UndoPluginsSwitchAction(autoSwitchedPlugins, enabled));
        DisabledPluginsState.addDisablePluginListener(new Runnable(){

            @Override
            public void run() {
                Balloon balloon2;
                boolean notificationValid;
                boolean bl = enabled ? !ContainerUtil.exists((Iterable)autoSwitchedPlugins, descriptor2 -> PluginManagerCore.isDisabled(descriptor2.getPluginId())) : (notificationValid = ContainerUtil.and((Iterable)autoSwitchedPlugins, descriptor2 -> PluginManagerCore.isDisabled(descriptor2.getPluginId())));
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon2 = switchNotification.getBalloon()) == null || balloon2.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> DisabledPluginsState.removeDisablePluginListener(this));
                }
            }
        });
        Notifications.Bus.notify((Notification)switchNotification);
    }

    @NotNull
    private static String joinPluginNames(@NotNull Collection<? extends IdeaPluginDescriptor> plugins2) {
        if (plugins2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(4);
        }
        StringBuilder builder2 = new StringBuilder();
        for (IdeaPluginDescriptor ideaPluginDescriptor : plugins2) {
            if (builder2.length() > 0) {
                builder2.append(", ");
            }
            builder2.append('\"').append(ideaPluginDescriptor.getName()).append('\"');
        }
        String string = builder2.toString();
        if (string == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static Set<IdeaPluginDescriptor> getPluginsIdsToEnable(@NotNull IdeaPluginDescriptor rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (rootDescriptor == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(6);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(7);
        }
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        if (rootDescriptor instanceof IdeaPluginDescriptorImpl) {
            PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, pluginIdMap, descriptor2 -> PluginManagerCore.CORE_ID.equals((Object)descriptor2.getPluginId()) || descriptor2.isEnabled() || !result2.add((IdeaPluginDescriptor)descriptor2) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE);
        }
        HashSet<IdeaPluginDescriptor> hashSet = result2;
        if (hashSet == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private static Set<IdeaPluginDescriptor> getPluginsIdsToDisable(@NotNull IdeaPluginDescriptor rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (rootDescriptor == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(9);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(10);
        }
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        for (IdeaPluginDescriptor plugin2 : PluginManagerCore.getPlugins()) {
            IdeaPluginDescriptorImpl pluginDescriptor;
            PluginId pluginId = plugin2.getPluginId();
            if (Objects.equals(pluginId, rootId) || appInfo.isEssentialPlugin(pluginId) || !plugin2.isEnabled() || plugin2.isImplementationDetail() || !(plugin2 instanceof IdeaPluginDescriptorImpl) || (pluginDescriptor = (IdeaPluginDescriptorImpl)plugin2).isDeleted()) continue;
            PluginManagerCore.processAllDependencies(pluginDescriptor, pluginIdMap, descriptor2 -> {
                if (Objects.equals(descriptor2.getPluginId(), rootId)) {
                    result2.add(plugin2);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        HashSet<IdeaPluginDescriptor> hashSet = result2;
        if (hashSet == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoSwitchedPlugins";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPluginNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsIdsToEnable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsIdsToDisable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "togglePluginState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showAutoSwitchNotification";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "joinPluginNames";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsIdsToEnable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsIdsToDisable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Notifier {
        private final AtomicReference<Notification> prevNotification = new AtomicReference();

        private Notifier() {
        }

        public void showNotification() {
            Notification prev2 = this.prevNotification.get();
            if (prev2 != null && prev2.getBalloon() != null && !prev2.getBalloon().isDisposed()) {
                return;
            }
            Notification next = NotificationGroupManager.getInstance().getNotificationGroup("Plugins updates").createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0])).addAction((AnAction)new DumbAwareAction(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().restart();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/PluginBooleanOptionDescriptor$Notifier$1", "actionPerformed"));
                }
            });
            if (this.prevNotification.compareAndSet(prev2, next)) {
                Notifications.Bus.notify((Notification)next);
            }
        }
    }

    private static final class UndoPluginsSwitchAction
    extends NotificationAction {
        @NotNull
        private final Collection<? extends IdeaPluginDescriptor> myDescriptors;
        private final boolean myEnabled;

        UndoPluginsSwitchAction(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, boolean enabled) {
            if (descriptors2 == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0]));
            this.myDescriptors = descriptors2;
            this.myEnabled = enabled;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(2);
            }
            PluginEnabler.HEADLESS.setEnabledState(this.myDescriptors, PluginEnableDisableAction.globally(!this.myEnabled));
            notification.expire();
            ourRestartNeededNotifier.showNotification();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor$UndoPluginsSwitchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

