/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.actions.QuickChangeLookAndFeel;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.LafProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.MenuArrowIcon;
import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.SystemDarkThemeDetector;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.DefaultLinkButtonUI;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FontUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.SVGLoader;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import kotlin.Lazy;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;

@State(name="LafManager", storages={@Storage(value="laf.xml")})
public final class LafManagerImpl
extends LafManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(LafManager.class);
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ELEMENT_PREFERRED_LIGHT_LAF = "preferred-light-laf";
    @NonNls
    private static final String ELEMENT_PREFERRED_DARK_LAF = "preferred-dark-laf";
    @NonNls
    private static final String ATTRIBUTE_AUTODETECT = "autodetect";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    private static final String DEFAULT_LIGHT_THEME_ID = "JetBrainsLightTheme";
    private static final String HIGH_CONTRAST_THEME_ID = "JetBrainsHighContrastTheme";
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.SavedEditorTheme";
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.SavedEditorTheme";
    private static final LafManager.LafReference SEPARATOR = new LafManager.LafReference("", null, null);
    @PropertyKey(resourceBundle="messages.IdeBundle")
    @NonNls
    private static final @PropertyKey(resourceBundle="messages.IdeBundle") @NonNls String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private final EventDispatcher<LafManagerListener> myEventDispatcher = EventDispatcher.create(LafManagerListener.class);
    private final SynchronizedClearableLazy<List<UIManager.LookAndFeelInfo>> myLaFs = new SynchronizedClearableLazy(() -> {
        Activity activity = StartUpMeasurer.startActivity((String)"compute LaF list", (ActivityCategory)ActivityCategory.DEFAULT);
        List<UIManager.LookAndFeelInfo> infos = this.computeLafList();
        activity.end();
        return infos;
    });
    private final SynchronizedClearableLazy<UIManager.LookAndFeelInfo> defaultLightLaf = new SynchronizedClearableLazy(() -> {
        for (UIThemeProvider provider2 : UIThemeProvider.EP_NAME.getIterable()) {
            UITheme theme;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider2.id) || (theme = provider2.createTheme()) == null) continue;
            return new UIThemeBasedLookAndFeelInfo(theme);
        }
        LOG.error("Can't load JetBrainsLightTheme");
        String lafInfoFQN = ApplicationInfoEx.getInstanceEx().getDefaultLightLaf();
        UIManager.LookAndFeelInfo lookAndFeelInfo = lafInfoFQN == null ? null : LafManagerImpl.createLafInfo(lafInfoFQN);
        return lookAndFeelInfo == null ? new IntelliJLookAndFeelInfo() : lookAndFeelInfo;
    });
    private final SynchronizedClearableLazy<UIManager.LookAndFeelInfo> defaultDarkLaf = new SynchronizedClearableLazy(() -> {
        String lafInfoFQN = ApplicationInfoEx.getInstanceEx().getDefaultDarkLaf();
        UIManager.LookAndFeelInfo lookAndFeelInfo = lafInfoFQN == null ? null : LafManagerImpl.createLafInfo(lafInfoFQN);
        return lookAndFeelInfo != null ? lookAndFeelInfo : new DarculaLookAndFeelInfo();
    });
    private final Map<Object, Object> ourDefaults = (UIDefaults)UIManager.getDefaults().clone();
    private UIManager.LookAndFeelInfo myCurrentLaf;
    @Nullable
    private UIManager.LookAndFeelInfo preferredLightLaf;
    @Nullable
    private UIManager.LookAndFeelInfo preferredDarkLaf;
    private final Map<LafManager.LafReference, Map<String, Object>> myStoredDefaults = new HashMap<LafManager.LafReference, Map<String, Object>>();
    private static final String WINDOW_ALPHA = "Window.alpha";
    private static final Map<String, String> ourLafClassesAliases = Map.of("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
    private static Map<String, Integer> lafNameOrder = Map.of("IntelliJ Light", 0, "macOS Light", 1, "Windows 10 Light", 1, "Darcula", 2, "High contrast", 3);
    private final SynchronizedClearableLazy<CollectionComboBoxModel<LafManager.LafReference>> myLafComboBoxModel = new SynchronizedClearableLazy(() -> new LafComboBoxModel());
    private final Lazy<ActionToolbar> settingsToolbar = new SynchronizedClearableLazy(() -> {
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{new PreferredLafAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group2, true);
        toolbar.getComponent().setOpaque(false);
        return toolbar;
    });
    @Nullable
    private SystemDarkThemeDetector lafDetector;
    private boolean myFirstSetup = true;
    private boolean myUpdatingPlugin = false;
    @Nullable
    private String myThemeIdBeforePluginUpdate = null;
    private boolean autodetect;
    private static LafManagerImpl ourTestInstance;

    @NotNull
    public static Map<String, Integer> getLafNameOrder() {
        Map<String, Integer> map2 = lafNameOrder;
        if (map2 == null) {
            LafManagerImpl.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public static void setLafNameOrder(@NotNull Map<String, Integer> value2) {
        if (value2 == null) {
            LafManagerImpl.$$$reportNull$$$0(1);
        }
        lafNameOrder = value2;
    }

    public UIManager.LookAndFeelInfo getDefaultLightLaf() {
        return (UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue();
    }

    public UIManager.LookAndFeelInfo getDefaultDarkLaf() {
        return (UIManager.LookAndFeelInfo)this.defaultDarkLaf.getValue();
    }

    @Nullable
    private static UIManager.LookAndFeelInfo createLafInfo(@NotNull String fqn) {
        if (fqn == null) {
            LafManagerImpl.$$$reportNull$$$0(2);
        }
        try {
            Class<?> lafInfoClass = Class.forName(fqn);
            return (UIManager.LookAndFeelInfo)lafInfoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NotNull
    private List<UIManager.LookAndFeelInfo> computeLafList() {
        ArrayList<UIManager.LookAndFeelInfo> lafList = new ArrayList<UIManager.LookAndFeelInfo>();
        lafList.add((UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue());
        lafList.add((UIManager.LookAndFeelInfo)this.defaultDarkLaf.getValue());
        if (!SystemInfoRt.isMac) {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || name.startsWith("Windows") || "GTK+".equalsIgnoreCase(name) || name.startsWith("JGoodies")) continue;
                lafList.add(laf);
            }
        }
        LafProvider.EP_NAME.forEachExtensionSafe(provider2 -> lafList.add(provider2.getLookAndFeelInfo()));
        UIThemeProvider.EP_NAME.forEachExtensionSafe(provider2 -> {
            UITheme theme;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider2.id) && (theme = provider2.createTheme()) != null) {
                lafList.add(new UIThemeBasedLookAndFeelInfo(theme));
            }
        });
        LafManagerImpl.sortThemes(lafList);
        ArrayList<UIManager.LookAndFeelInfo> arrayList = lafList;
        if (arrayList == null) {
            LafManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void sortThemes(@NotNull List<? extends UIManager.LookAndFeelInfo> list2) {
        if (list2 == null) {
            LafManagerImpl.$$$reportNull$$$0(4);
        }
        list2.sort((t1, t2) -> {
            String n2;
            String n1 = t1.getName();
            if (Objects.equals(n1, n2 = t2.getName())) {
                return 0;
            }
            Integer o1 = lafNameOrder.get(n1);
            Integer o2 = lafNameOrder.get(n2);
            if (o1 != null && o2 != null) {
                return o1 - o2;
            }
            if (o1 != null) {
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return n1.compareToIgnoreCase(n2);
        });
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(6);
        }
        if (disposable2 == null) {
            LafManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(LafManagerListener.TOPIC, (Object)listener2);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(8);
        }
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public void initializeComponent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            UIManager.LookAndFeelInfo currentLaf = this.myCurrentLaf;
            assert (currentLaf != null);
            if (currentLaf instanceof UIThemeBasedLookAndFeelInfo) {
                if (!((UIThemeBasedLookAndFeelInfo)currentLaf).isInitialised()) {
                    this.doSetLaF(currentLaf, false);
                }
            } else {
                UIManager.LookAndFeelInfo laf = this.findLaf(currentLaf.getClassName());
                if (laf != null) {
                    boolean needUninstall = StartupUiUtil.isUnderDarcula();
                    this.doSetLaF(laf, false);
                    this.updateWizardLAF(needUninstall);
                }
            }
            this.selectComboboxModel();
            this.myFirstSetup = false;
            this.updateUI();
            this.detectAndSyncLaf();
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).initScheme(this.myCurrentLaf);
            this.addThemeAndDynamicPluginListeners();
        }, ModalityState.any());
    }

    private void addThemeAndDynamicPluginListeners() {
        UIThemeProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new UIThemeEPListener(), (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                LafManagerImpl.this.myUpdatingPlugin = isUpdate;
                LafManagerImpl.this.myThemeIdBeforePluginUpdate = LafManagerImpl.this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo ? ((UIThemeBasedLookAndFeelInfo)LafManagerImpl.this.myCurrentLaf).getTheme().getId() : null;
            }

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                LafManagerImpl.this.myUpdatingPlugin = false;
                LafManagerImpl.this.myThemeIdBeforePluginUpdate = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void detectAndSyncLaf() {
        SystemDarkThemeDetector lafDetector;
        if (this.autodetect && (lafDetector = this.getOrCreateLafDetector()).getDetectionSupported()) {
            lafDetector.check();
        }
    }

    private void syncLaf(boolean systemIsDark) {
        UIManager.LookAndFeelInfo expectedLaf;
        boolean currentIsDark;
        if (!this.autodetect) {
            return;
        }
        boolean bl = currentIsDark = this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().isDark() || StartupUiUtil.isUnderDarcula();
        if (systemIsDark) {
            expectedLaf = this.preferredDarkLaf;
            if (expectedLaf == null) {
                expectedLaf = this.getDefaultDarkLaf();
            }
        } else {
            expectedLaf = this.preferredLightLaf;
            if (expectedLaf == null) {
                expectedLaf = this.getDefaultLightLaf();
            }
        }
        if (currentIsDark != systemIsDark || this.myCurrentLaf != expectedLaf) {
            QuickChangeLookAndFeel.switchLafAndUpdateUI(this, expectedLaf, true);
        }
    }

    public void updateWizardLAF(boolean wasUnderDarcula) {
        if (WelcomeWizardUtil.getWizardLAF() == null) {
            return;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            DarculaInstaller.install();
        } else if (wasUnderDarcula) {
            DarculaInstaller.uninstall();
        }
        WelcomeWizardUtil.setWizardLAF(null);
    }

    public void dispose() {
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(9);
        }
        this.myCurrentLaf = this.loadLafState(element2, ELEMENT_LAF);
        if (this.myCurrentLaf == null) {
            this.myCurrentLaf = this.loadDefaultLaf();
        }
        this.autodetect = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_AUTODETECT));
        this.preferredLightLaf = this.loadLafState(element2, ELEMENT_PREFERRED_LIGHT_LAF);
        this.preferredDarkLaf = this.loadLafState(element2, ELEMENT_PREFERRED_DARK_LAF);
        if (this.autodetect) {
            this.getOrCreateLafDetector();
        }
    }

    @Nullable
    private UIManager.LookAndFeelInfo loadLafState(@NotNull Element element2, @NotNull @NonNls String attrName) {
        Element lafElement;
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            LafManagerImpl.$$$reportNull$$$0(11);
        }
        if ((lafElement = element2.getChild(attrName)) == null) {
            return null;
        }
        return this.findLaf(lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME), lafElement.getAttributeValue(ATTRIBUTE_THEME_NAME));
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@Nullable String lafClassName, @Nullable String themeId) {
        if (DEFAULT_LIGHT_THEME_ID.equals(themeId)) {
            return (UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue();
        }
        if (lafClassName != null && ourLafClassesAliases.containsKey(lafClassName)) {
            lafClassName = ourLafClassesAliases.get(lafClassName);
        }
        if ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lafClassName)) {
            return (UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue();
        }
        if (themeId != null) {
            for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
                if (!(l instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)l).getTheme().getId().equals(themeId)) continue;
                return l;
            }
        }
        UIManager.LookAndFeelInfo laf = null;
        if (lafClassName != null) {
            laf = this.findLaf(lafClassName);
        }
        if (laf == null && ("com.intellij.laf.win10.WinIntelliJLaf".equals(lafClassName) || "com.intellij.laf.macos.MacIntelliJLaf".equals(lafClassName))) {
            return (UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue();
        }
        return laf;
    }

    public void noStateLoaded() {
        this.myCurrentLaf = this.loadDefaultLaf();
        this.preferredLightLaf = null;
        this.preferredDarkLaf = null;
        this.autodetect = false;
    }

    public Element getState() {
        Element element2 = new Element("state");
        element2.setAttribute(ATTRIBUTE_AUTODETECT, Boolean.toString(this.autodetect));
        LafManagerImpl.getLafState(element2, ELEMENT_LAF, this.getCurrentLookAndFeel());
        if (this.preferredLightLaf != null && this.preferredLightLaf != this.defaultLightLaf.getValue()) {
            LafManagerImpl.getLafState(element2, ELEMENT_PREFERRED_LIGHT_LAF, this.preferredLightLaf);
        }
        if (this.preferredDarkLaf != null && this.preferredDarkLaf != this.defaultDarkLaf.getValue()) {
            LafManagerImpl.getLafState(element2, ELEMENT_PREFERRED_DARK_LAF, this.preferredDarkLaf);
        }
        return element2;
    }

    private static void getLafState(@NotNull Element element2, @NonNls String attrName, UIManager.LookAndFeelInfo laf) {
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(12);
        }
        if (laf instanceof TempUIThemeBasedLookAndFeelInfo) {
            laf = ((TempUIThemeBasedLookAndFeelInfo)laf).getPreviousLaf();
        }
        if (laf == null) {
            return;
        }
        String className = laf.getClassName();
        if (className != null) {
            Element child2 = new Element(attrName);
            child2.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            if (laf instanceof UIThemeBasedLookAndFeelInfo) {
                child2.setAttribute(ATTRIBUTE_THEME_NAME, ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId());
            }
            element2.addContent(child2);
        }
    }

    public UIManager.LookAndFeelInfo @NotNull [] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = ((List)this.myLaFs.getValue()).toArray(new UIManager.LookAndFeelInfo[0]);
        if (lookAndFeelInfoArray == null) {
            LafManagerImpl.$$$reportNull$$$0(13);
        }
        return lookAndFeelInfoArray;
    }

    @NotNull
    public CollectionComboBoxModel<LafManager.LafReference> getLafComboBoxModel() {
        CollectionComboBoxModel collectionComboBoxModel = (CollectionComboBoxModel)this.myLafComboBoxModel.getValue();
        if (collectionComboBoxModel == null) {
            LafManagerImpl.$$$reportNull$$$0(14);
        }
        return collectionComboBoxModel;
    }

    @NotNull
    private List<LafManager.LafReference> getAllReferences() {
        ArrayList<LafManager.LafReference> result2 = new ArrayList<LafManager.LafReference>();
        boolean addSeparator = false;
        int maxNameOrder = Collections.max(lafNameOrder.values());
        for (UIManager.LookAndFeelInfo info2 : (List)this.myLaFs.getValue()) {
            if (addSeparator) {
                result2.add(SEPARATOR);
                addSeparator = false;
            }
            result2.add(LafManagerImpl.createLafReference(info2));
            if (!Objects.equals(lafNameOrder.get(info2.getName()), maxNameOrder)) continue;
            addSeparator = true;
        }
        ArrayList<LafManager.LafReference> arrayList = result2;
        if (arrayList == null) {
            LafManagerImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void updateLafComboboxModel() {
        this.myLafComboBoxModel.drop();
    }

    private void selectComboboxModel() {
        if (this.myLafComboBoxModel.isInitialized()) {
            ((CollectionComboBoxModel)this.myLafComboBoxModel.getValue()).setSelectedItem((Object)LafManagerImpl.createLafReference(this.myCurrentLaf));
        }
    }

    @NotNull
    private static LafManager.LafReference createLafReference(UIManager.LookAndFeelInfo laf) {
        String themeId = null;
        if (laf instanceof UIThemeBasedLookAndFeelInfo) {
            themeId = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId();
        }
        return new LafManager.LafReference(laf.getName(), laf.getClassName(), themeId);
    }

    public UIManager.LookAndFeelInfo findLaf(@NotNull LafManager.LafReference reference2) {
        if (reference2 == null) {
            LafManagerImpl.$$$reportNull$$$0(16);
        }
        return this.findLaf(reference2.getClassName(), reference2.getThemeId());
    }

    @Nullable
    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    public LafManager.LafReference getLookAndFeelReference() {
        return LafManagerImpl.createLafReference(this.getCurrentLookAndFeel());
    }

    public ListCellRenderer<LafManager.LafReference> getLookAndFeelCellRenderer() {
        return new LafCellRenderer();
    }

    @NotNull
    public JComponent getSettingsToolbar() {
        JComponent jComponent = ((ActionToolbar)this.settingsToolbar.getValue()).getComponent();
        if (jComponent == null) {
            LafManagerImpl.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    @NotNull
    private UIManager.LookAndFeelInfo loadDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf4;
        String appLafName;
        Object laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf3;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(18);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfoRt.isMac) {
            String className = DarculaLaf.class.getName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf2;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(19);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf2;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(20);
                }
                return lookAndFeelInfo;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if (SystemInfoRt.isWindows && Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on") == Boolean.TRUE) {
            for (UIManager.LookAndFeelInfo laf4 : (List)this.myLaFs.getValue()) {
                if (!(laf4 instanceof UIThemeBasedLookAndFeelInfo) || !HIGH_CONTRAST_THEME_ID.equals(((UIThemeBasedLookAndFeelInfo)laf4).getTheme().getId())) continue;
                UIManager.LookAndFeelInfo lookAndFeelInfo = laf4;
                if (lookAndFeelInfo == null) {
                    LafManagerImpl.$$$reportNull$$$0(21);
                }
                return lookAndFeelInfo;
            }
        }
        if ((laf4 = this.findLaf(defaultLafName = DarculaLaf.class.getName())) != null) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = laf4;
            if (lookAndFeelInfo == null) {
                LafManagerImpl.$$$reportNull$$$0(22);
            }
            return lookAndFeelInfo;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@NotNull String className) {
        if (className == null) {
            LafManagerImpl.$$$reportNull$$$0(23);
        }
        if (((UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue()).getClassName().equals(className)) {
            return (UIManager.LookAndFeelInfo)this.defaultLightLaf.getValue();
        }
        if (((UIManager.LookAndFeelInfo)this.defaultDarkLaf.getValue()).getClassName().equals(className)) {
            return (UIManager.LookAndFeelInfo)this.defaultDarkLaf.getValue();
        }
        for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
            if (l instanceof UIThemeBasedLookAndFeelInfo || !className.equals(l.getClassName())) continue;
            return l;
        }
        return null;
    }

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean lockEditorScheme) {
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(24);
        }
        this.setLookAndFeelImpl(lookAndFeelInfo, !lockEditorScheme, true);
    }

    private void setLookAndFeelImpl(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean installEditorScheme, boolean processChangeSynchronously) {
        UIManager.LookAndFeelInfo oldLaf;
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(25);
        }
        if ((oldLaf = this.myCurrentLaf) != lookAndFeelInfo && oldLaf instanceof UIThemeBasedLookAndFeelInfo) {
            ((UIThemeBasedLookAndFeelInfo)oldLaf).dispose();
        }
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        if (this.doSetLaF(lookAndFeelInfo, installEditorScheme)) {
            return;
        }
        this.myCurrentLaf = lookAndFeelInfo;
        this.selectComboboxModel();
        if (!this.myFirstSetup && installEditorScheme) {
            if (processChangeSynchronously) {
                this.updateEditorSchemeIfNecessary(oldLaf, true);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.updateEditorSchemeIfNecessary(oldLaf, false));
            }
        }
        this.myFirstSetup = false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean doSetLaF(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean installEditorScheme) {
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(26);
        }
        defaults = UIManager.getDefaults();
        defaults.clear();
        defaults.putAll(this.ourDefaults);
        if (!this.myFirstSetup) {
            SVGLoader.setColorPatcherForSelection(null);
        }
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            laf /* !! */  = new IdeaLaf(null);
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf /* !! */ );
                LafManagerImpl.updateIconsUnderSelection(false);
            }
            catch (Exception e) {
                LafManagerImpl.LOG.error((Throwable)e);
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return true;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            laf /* !! */  = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf /* !! */ );
                AppUIUtil.updateForDarcula(true);
                if (!LafManagerImpl.lafNameOrder.containsKey(lookAndFeelInfo.getName())) ** GOTO lbl51
                LafManagerImpl.updateIconsUnderSelection(true);
            }
            catch (Exception e) {
                LafManagerImpl.LOG.error((Throwable)e);
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return true;
            }
        } else {
            try {
                if (lookAndFeelInfo instanceof PluggableLafInfo) {
                    laf /* !! */  = ((PluggableLafInfo)lookAndFeelInfo).createLookAndFeel();
                } else {
                    laf /* !! */  = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (laf /* !! */  instanceof MetalLookAndFeel) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
                        if (laf /* !! */  instanceof UserDataHolder) {
                            userDataHolder = (UserDataHolder)laf /* !! */ ;
                            userDataHolder.putUserData(UIUtil.LAF_WITH_THEME_KEY, (Object)Boolean.TRUE);
                        }
                        if (LafManagerImpl.lafNameOrder.containsKey(lookAndFeelInfo.getName()) && lookAndFeelInfo.getName().endsWith("Light")) {
                            LafManagerImpl.updateIconsUnderSelection(false);
                        }
                    }
                }
                UIManager.setLookAndFeel(laf /* !! */ );
            }
            catch (Exception e) {
                LafManagerImpl.LOG.error((Throwable)e);
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return true;
            }
        }
lbl51:
        // 4 sources

        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
            try {
                themeInfo = (UIThemeBasedLookAndFeelInfo)lookAndFeelInfo;
                themeInfo.installTheme(UIManager.getLookAndFeelDefaults(), installEditorScheme == false);
                if (!themeInfo.getName().equals("IntelliJ Light")) {
                    defaults.put("Theme.name", themeInfo.getName());
                }
            }
            catch (Exception e) {
                LafManagerImpl.LOG.error((Throwable)e);
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return true;
            }
        }
        if (SystemInfoRt.isMac) {
            LafManagerImpl.installMacOSXFonts(UIManager.getLookAndFeelDefaults());
        }
        return false;
    }

    private static void updateIconsUnderSelection(boolean darcula) {
        final HashMap<String, String> map2 = new HashMap<String, String>();
        if (darcula) {
            map2.put("#5e5e5e", "#5778ad");
            map2.put("#c75450", "#a95768");
            map2.put("#6e6e6e", "#afb1b3");
            map2.put("#f26522b3", "#bc6b43");
            map2.put("#f2652299", "#bc6b43");
            map2.put("#62b54399", "#579b41");
            map2.put("#f98b9e99", "#ba7481");
            map2.put("#f4af3d99", "#aa823f");
            map2.put("#b99bf899", "#977fca");
            map2.put("#9aa7b0cc", "#97acc6");
            map2.put("#9aa7b099", "#97acc6");
        } else {
            map2.put("#6e6e6e", "#afb1b3");
            map2.put("#db5860", "#b75e73");
            map2.put("#f26522b3", "#d38369");
            map2.put("#f2652299", "#d38369");
            map2.put("#40b6e099", "#5eb6d4");
            map2.put("#62b54399", "#7ebe65");
            map2.put("#f98b9e99", "#f1a4b2");
            map2.put("#f4af3d99", "#ecc27d");
            map2.put("#b99bf899", "#b49ee2");
            map2.put("#9aa7b0cc", "#aebdc6");
            map2.put("#9aa7b099", "#aebdc6");
            map2.put("#40b6e0b3", "#5eb6d4");
            map2.put("#62b543b3", "#7ebe65");
            map2.put("#f98b9eb3", "#f1a4b2");
            map2.put("#f4af3db3", "#ecc27d");
            map2.put("#b99bf8b3", "#b49ee2");
        }
        final HashMap alpha = new HashMap(map2.size());
        map2.forEach((key, value2) -> alpha.put(value2, 255));
        SVGLoader.setColorPatcherForSelection((SVGLoader.SvgElementColorPatcherProvider)new SVGLoader.SvgElementColorPatcherProvider(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable SVGLoader.SvgElementColorPatcher forPath(@Nullable String path2) {
                return SVGLoader.newPatcher(null, (Map)map2, (Map)alpha);
            }
        });
    }

    private void updateEditorSchemeIfNecessary(UIManager.LookAndFeelInfo oldLaf, boolean processChangeSynchronously) {
        if (oldLaf instanceof TempUIThemeBasedLookAndFeelInfo || this.myCurrentLaf instanceof TempUIThemeBasedLookAndFeelInfo) {
            return;
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().getEditorSchemeName() != null) {
            return;
        }
        boolean dark = StartupUiUtil.isUnderDarcula();
        EditorColorsManager editorColorManager = EditorColorsManager.getInstance();
        EditorColorsScheme current2 = editorColorManager.getGlobalScheme();
        boolean wasUITheme = oldLaf instanceof UIThemeBasedLookAndFeelInfo;
        if (dark != ColorUtil.isDark((Color)current2.getDefaultBackground()) || wasUITheme) {
            EditorColorsScheme scheme2;
            String targetScheme = dark ? "Darcula" : "Default";
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String savedEditorThemeKey = dark ? DARCULA_EDITOR_THEME_KEY : DEFAULT_EDITOR_THEME_KEY;
            String toSavedEditorThemeKey = dark ? DEFAULT_EDITOR_THEME_KEY : DARCULA_EDITOR_THEME_KEY;
            String themeName = properties.getValue(savedEditorThemeKey);
            if (themeName != null && editorColorManager.getScheme(themeName) != null) {
                targetScheme = themeName;
            }
            if (!wasUITheme) {
                properties.setValue(toSavedEditorThemeKey, current2.getName(), dark ? "Default" : "Darcula");
            }
            if ((scheme2 = editorColorManager.getScheme(targetScheme)) != null) {
                ((EditorColorsManagerImpl)editorColorManager).setGlobalScheme(scheme2, processChangeSynchronously);
            }
        }
        UISettings.getShadowInstance().fireUISettingsChanged();
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        uiDefaults.put("LinkButtonUI", DefaultLinkButtonUI.class.getName());
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixMenuIssues(uiDefaults);
        StartupUiUtil.initInputMapDefaults((UIDefaults)uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        uiDefaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchListUI(uiDefaults);
        LafManagerImpl.patchTreeUI(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        uiDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
        uiDefaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)UIUtil.getLcdContrastValue());
        uiDefaults.put(RenderingHints.KEY_FRACTIONALMETRICS, AppUIUtil.adjustFractionalMetrics(UISettings.Companion.getPreferredFractionalMetricsValue()));
        for (Frame frame : Frame.getFrames()) {
            LafManagerImpl.updateUI(frame);
        }
        ((LafManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LafManagerListener.TOPIC)).lookAndFeelChanged((LafManager)this);
        ((LafManagerListener)this.myEventDispatcher.getMulticaster()).lookAndFeelChanged((LafManager)this);
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size2, @JdkConstants.FontStyle int style) {
        Font font;
        if (SystemInfoRt.isMac && !StartupUiUtil.isDialogFont((Font)(font = FontUtil.enableKerning((Font)new Font(SystemInfo.isMacOSCatalina ? ".AppleSystemUIFont" : ".SF NS Text", style, size2))))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size2);
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = "Helvetica Neue";
        StartupUiUtil.initFontDefaults((UIDefaults)defaults, (FontUIResource)LafManagerImpl.getFont("Helvetica Neue", 13, 0));
        for (Object key : new ArrayList(defaults.keySet())) {
            FontUIResource font;
            Object value2;
            if (!(key instanceof String) || !Strings.endsWithIgnoreCase((CharSequence)((String)key), (String)"font") || !((value2 = defaults.get(key)) instanceof FontUIResource) || !(font = (FontUIResource)value2).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, LafManagerImpl.getFont("Helvetica Neue", font.getSize(), font.getStyle()));
        }
        defaults.put("TableHeader.font", LafManagerImpl.getFont("Helvetica Neue", 11, 0));
        FontUIResource buttonFont = LafManagerImpl.getFont("Helvetica Neue", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImpl.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    private static void patchBorder(UIDefaults defaults, String key) {
        if (defaults.getBorder(key) == null) {
            defaults.put(key, JBUI.Borders.empty((int)1, (int)0).asUIResource());
        }
    }

    private static void patchListUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "List.border");
    }

    private static void patchTreeUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "Tree.border");
        defaults.put("TreeUI", DefaultTreeUI.class.getName());
        defaults.put("Tree.repaintWholeRow", (Object)true);
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.collapsedIcon"))) {
            defaults.put("Tree.collapsedIcon", LafIconLookup.getIcon((String)"treeCollapsed"));
            defaults.put("Tree.collapsedSelectedIcon", LafIconLookup.getSelectedIcon((String)"treeCollapsed"));
        }
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.expandedIcon"))) {
            defaults.put("Tree.expandedIcon", LafIconLookup.getIcon((String)"treeExpanded"));
            defaults.put("Tree.expandedSelectedIcon", LafIconLookup.getSelectedIcon((String)"treeExpanded"));
        }
    }

    private static boolean isUnsupported(@Nullable Icon icon2) {
        String name = icon2 == null ? null : icon2.getClass().getName();
        return name == null || name.startsWith("javax.swing.plaf.") || name.startsWith("com.sun.java.swing.plaf.");
    }

    private static void patchHiDPI(UIDefaults defaults) {
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : 1.0f;
        float prevRowHeightScale = prevScaleVal != null || SystemInfoRt.isMac || SystemInfoRt.isWindows ? prevScale : JBUIScale.getFontScale((float)12.0f);
        LafManagerImpl.patchRowHeight(defaults, "List.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Table.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Tree.rowHeight", prevRowHeightScale);
        if (prevScale == JBUIScale.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        Set<String> myIntKeys = Set.of("Tree.leftChildIndent", "Tree.rightChildIndent", "SettingsTree.rowHeight");
        Set<String> myDimensionKeys = Set.of("Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize");
        for (Map.Entry entry2 : defaults.entrySet()) {
            Object value2 = entry2.getValue();
            String key = entry2.getKey().toString();
            if (value2 instanceof Dimension) {
                if (!(value2 instanceof UIResource) && !myDimensionKeys.contains(key)) continue;
                entry2.setValue(JBUI.size((Dimension)((Dimension)value2)).asUIResource());
                continue;
            }
            if (value2 instanceof Insets) {
                if (!(value2 instanceof UIResource)) continue;
                entry2.setValue(JBUI.insets((Insets)((Insets)value2)).asUIResource());
                continue;
            }
            if (!(value2 instanceof Integer) || !key.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key)) continue;
            int normValue = (int)((float)((Integer)value2).intValue() / prevScale);
            entry2.setValue(JBUIScale.scale((int)normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUIScale.scale((float)1.0f)));
    }

    private static void patchRowHeight(UIDefaults defaults, String key, float prevScale) {
        int custom;
        int rowHeight;
        Object value2 = defaults.get(key);
        int n = rowHeight = value2 instanceof Integer ? (Integer)value2 : 0;
        if (!(SystemInfoRt.isMac || SystemInfoRt.isWindows || LoadingState.APP_STARTED.isOccurred() && !Registry.is((String)"linux.row.height.disabled", (boolean)true))) {
            rowHeight = 0;
        } else if (rowHeight <= 0) {
            LOG.warn(key + " = " + value2 + " in " + UIManager.getLookAndFeel().getName() + "; it may lead to performance degradation");
        }
        int n2 = custom = LoadingState.APP_STARTED.isOccurred() ? Registry.intValue((String)("ide.override." + key), (int)-1) : -1;
        defaults.put(key, (Object)(custom >= 0 ? custom : (rowHeight <= 0 ? 0 : JBUIScale.scale((int)((int)((float)rowHeight / prevScale))))));
    }

    private static void fixMenuIssues(@NotNull UIDefaults uiDefaults) {
        if (uiDefaults == null) {
            LafManagerImpl.$$$reportNull$$$0(27);
        }
        uiDefaults.put("Menu.arrowIcon", new DefaultMenuArrowIcon());
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property2 = System.getProperty("idea.popup.weight");
        if (property2 != null) {
            property2 = Strings.toLowerCase((String)property2).trim();
        }
        if (SystemInfoRt.isMac) {
            popupWeight = 2;
        } else if (property2 == null) {
            if (SystemInfoRt.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property2)) {
            popupWeight = 0;
        } else if ("heavy".equals(property2)) {
            popupWeight = 2;
        } else if (!"medium".equals(property2)) {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property2);
        }
        PopupFactory factory2 = PopupFactory.getSharedInstance();
        if (!(factory2 instanceof OurPopupFactory)) {
            factory2 = new OurPopupFactory(factory2);
            PopupFactory.setSharedInstance(factory2);
        }
        PopupUtil.setPopupType((PopupFactory)factory2, (int)popupWeight);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message((String)key, (Object[])new Object[0]));
            }
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            this.storeOriginalFontDefaults(uiDefaults);
            StartupUiUtil.initFontDefaults((UIDefaults)uiDefaults, (FontUIResource)StartupUiUtil.getFontWithFallback((String)uiSettings.getFontFace(), (int)0, (int)uiSettings.getFontSize()));
            JBUIScale.setUserScaleFactor((float)JBUIScale.getFontScale((float)uiSettings.getFontSize()));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getLookAndFeelReference();
        Map<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : StartupUiUtil.ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUIScale.setUserScaleFactor((float)JBUIScale.getFontScale((float)JBFont.label().getSize()));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getLookAndFeelReference();
        Map<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap<String, Object>();
            for (String resource : StartupUiUtil.ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(@NotNull Window window) {
        if (window == null) {
            LafManagerImpl.$$$reportNull$$$0(28);
        }
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    public boolean getAutodetect() {
        return this.autodetect;
    }

    public void setAutodetect(boolean value2) {
        this.autodetect = value2;
        if (this.autodetect) {
            this.detectAndSyncLaf();
        }
    }

    public boolean getAutodetectSupported() {
        return this.getOrCreateLafDetector().getDetectionSupported();
    }

    @NotNull
    private SystemDarkThemeDetector getOrCreateLafDetector() {
        SystemDarkThemeDetector result2 = this.lafDetector;
        if (result2 == null) {
            this.lafDetector = result2 = SystemDarkThemeDetector.createDetector(this::syncLaf);
        }
        SystemDarkThemeDetector systemDarkThemeDetector = result2;
        if (systemDarkThemeDetector == null) {
            LafManagerImpl.$$$reportNull$$$0(29);
        }
        return systemDarkThemeDetector;
    }

    public void setPreferredDarkLaf(@NotNull UIManager.LookAndFeelInfo value2) {
        if (value2 == null) {
            LafManagerImpl.$$$reportNull$$$0(30);
        }
        this.preferredDarkLaf = value2;
    }

    public void setPreferredLightLaf(@NotNull UIManager.LookAndFeelInfo value2) {
        if (value2 == null) {
            LafManagerImpl.$$$reportNull$$$0(31);
        }
        this.preferredLightLaf = value2;
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    @TestOnly
    public static LafManagerImpl getTestInstance() {
        if (ourTestInstance == null) {
            ourTestInstance = new LafManagerImpl();
        }
        return ourTestInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 1: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookAndFeelInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDefaults";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLafNameOrder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLafList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledLookAndFeels";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLafComboBoxModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsToolbar";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultLaf";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLafDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLafNameOrder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLafInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortThemes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLafManagerListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLafManagerListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadLafState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLafState";
                break;
            }
            case 16: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findLaf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLookAndFeel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setLookAndFeelImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doSetLaF";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fixMenuIssues";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredDarkLaf";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredLightLaf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LafToggleAction
    extends ToggleAction {
        private final UIManager.LookAndFeelInfo lafInfo;
        private final boolean isDark;

        private LafToggleAction(String name, UIManager.LookAndFeelInfo lafInfo, boolean isDark) {
            super(name);
            this.lafInfo = lafInfo;
            this.isDark = isDark;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                LafToggleAction.$$$reportNull$$$0(0);
            }
            return this.isDark ? this.lafInfo == LafManagerImpl.this.preferredDarkLaf : this.lafInfo == LafManagerImpl.this.preferredLightLaf;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                LafToggleAction.$$$reportNull$$$0(1);
            }
            if (this.isDark) {
                if (LafManagerImpl.this.preferredDarkLaf != this.lafInfo) {
                    LafManagerImpl.this.preferredDarkLaf = this.lafInfo;
                    LafManagerImpl.this.detectAndSyncLaf();
                }
            } else if (LafManagerImpl.this.preferredLightLaf != this.lafInfo) {
                LafManagerImpl.this.preferredLightLaf = this.lafInfo;
                LafManagerImpl.this.detectAndSyncLaf();
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$LafToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PreferredLafAction
    extends DefaultActionGroup {
        private PreferredLafAction() {
            this.setPopup(true);
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText(IdeBundle.message((String)"preferred.theme.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setDescription(IdeBundle.message((String)"preferred.theme.description", (Object[])new Object[0]));
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context2) {
            if (context2 == null) {
                PreferredLafAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PreferredLafAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"preferred.theme.text", (Object[])new Object[0]), this.getLafGroups(), e.getDataContext(), true, null, Integer.MAX_VALUE);
            HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)popup2);
            Component component2 = e.getInputEvent().getComponent();
            if (component2 instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInCenterOf(component2);
            }
        }

        @NotNull
        private ActionGroup getLafGroups() {
            ArrayList<UIManager.LookAndFeelInfo> lightLafs = new ArrayList<UIManager.LookAndFeelInfo>();
            ArrayList<UIManager.LookAndFeelInfo> darkLafs = new ArrayList<UIManager.LookAndFeelInfo>();
            for (UIManager.LookAndFeelInfo lafInfo : (List)LafManagerImpl.this.myLaFs.getValue()) {
                if (lafInfo instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)lafInfo).getTheme().isDark() || lafInfo.getName().equals("Darcula")) {
                    darkLafs.add(lafInfo);
                    continue;
                }
                lightLafs.add(lafInfo);
            }
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.addAll(this.createThemeActions(IdeBundle.message((String)"preferred.theme.light.header", (Object[])new Object[0]), lightLafs, false));
            group2.addAll(this.createThemeActions(IdeBundle.message((String)"preferred.theme.dark.header", (Object[])new Object[0]), darkLafs, true));
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                PreferredLafAction.$$$reportNull$$$0(2);
            }
            return defaultActionGroup;
        }

        @NotNull
        private Collection<AnAction> createThemeActions(@NotNull @NlsContexts.Separator String separatorText, @NotNull List<? extends UIManager.LookAndFeelInfo> lafs, boolean isDark) {
            if (separatorText == null) {
                PreferredLafAction.$$$reportNull$$$0(3);
            }
            if (lafs == null) {
                PreferredLafAction.$$$reportNull$$$0(4);
            }
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            if (!lafs.isEmpty()) {
                result2.add((AnAction)Separator.create((String)separatorText));
                for (UIManager.LookAndFeelInfo lookAndFeelInfo : lafs) {
                    result2.add((AnAction)new LafToggleAction(lookAndFeelInfo.getName(), lookAndFeelInfo, isDark));
                }
            }
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                PreferredLafAction.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/laf/LafManagerImpl$PreferredLafAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separatorText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lafs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$PreferredLafAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLafGroups";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createThemeActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createThemeActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class LafComboBoxModel
    extends CollectionComboBoxModel<LafManager.LafReference> {
        private LafComboBoxModel() {
            super(LafManagerImpl.this.getAllReferences());
        }

        public void setSelectedItem(@Nullable Object item) {
            if (item != SEPARATOR) {
                super.setSelectedItem(item);
            }
        }
    }

    private static final class LafCellRenderer
    extends SimpleListCellRenderer<LafManager.LafReference> {
        private static final SeparatorWithText separator = new SeparatorWithText(){

            protected void paintComponent(Graphics g) {
                g.setColor(this.getForeground());
                Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getInsets());
                this.paintLine(g, bounds2.x, bounds2.y + bounds2.height / 2, bounds2.width);
            }
        };

        private LafCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends LafManager.LafReference> list2, LafManager.LafReference value2, int index2, boolean isSelected, boolean cellHasFocus) {
            return value2 == SEPARATOR ? separator : super.getListCellRendererComponent(list2, (Object)value2, index2, isSelected, cellHasFocus);
        }

        public void customize(@NotNull JList<? extends LafManager.LafReference> list2, LafManager.LafReference value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                LafCellRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/ui/laf/LafManagerImpl$LafCellRenderer", "customize"));
        }
    }

    private final class UIThemeEPListener
    implements ExtensionPointListener<UIThemeProvider> {
        private UIThemeEPListener() {
        }

        public void extensionAdded(@NotNull UIThemeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider2 == null) {
                UIThemeEPListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(1);
            }
            for (UIManager.LookAndFeelInfo feel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                if (!(feel instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)feel).getTheme().getId().equals(provider2.id)) continue;
                return;
            }
            UITheme theme = provider2.createTheme();
            if (theme == null) {
                return;
            }
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeAdded(theme);
            List lafList = (List)LafManagerImpl.this.myLaFs.getValue();
            ArrayList<UIThemeBasedLookAndFeelInfo> newLaFs = new ArrayList<UIThemeBasedLookAndFeelInfo>(lafList.size() + 1);
            newLaFs.addAll(lafList);
            UIThemeBasedLookAndFeelInfo newTheme = new UIThemeBasedLookAndFeelInfo(theme);
            newLaFs.add(newTheme);
            LafManagerImpl.sortThemes(newLaFs);
            LafManagerImpl.this.myLaFs.setValue(newLaFs);
            LafManagerImpl.this.updateLafComboboxModel();
            if (!(LafManagerImpl.this.autodetect || LafManagerImpl.this.myUpdatingPlugin && !newTheme.getTheme().getId().equals(LafManagerImpl.this.myThemeIdBeforePluginUpdate))) {
                LafManagerImpl.this.setLookAndFeelImpl(newTheme, true, false);
                JBColor.setDark((boolean)newTheme.getTheme().isDark());
                LafManagerImpl.this.updateUI();
            }
        }

        public void extensionRemoved(@NotNull UIThemeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider2 == null) {
                UIThemeEPListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(3);
            }
            UIManager.LookAndFeelInfo switchLafTo = null;
            ArrayList<UIManager.LookAndFeelInfo> list2 = new ArrayList<UIManager.LookAndFeelInfo>();
            for (UIManager.LookAndFeelInfo lookAndFeel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                UITheme theme;
                if (lookAndFeel instanceof UIThemeBasedLookAndFeelInfo && (theme = ((UIThemeBasedLookAndFeelInfo)lookAndFeel).getTheme()).getId().equals(provider2.id)) {
                    if (lookAndFeel == LafManagerImpl.this.getCurrentLookAndFeel()) {
                        switchLafTo = theme.isDark() ? (UIManager.LookAndFeelInfo)LafManagerImpl.this.defaultDarkLaf.getValue() : (UIManager.LookAndFeelInfo)LafManagerImpl.this.defaultLightLaf.getValue();
                    }
                    ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeRemoved(theme);
                    continue;
                }
                list2.add(lookAndFeel);
            }
            LafManagerImpl.this.myLaFs.setValue(list2);
            LafManagerImpl.this.updateLafComboboxModel();
            if (switchLafTo != null) {
                LafManagerImpl.this.setLookAndFeelImpl(switchLafTo, true, true);
                JBColor.setDark((LafManagerImpl.this.defaultDarkLaf.isInitialized() && switchLafTo == LafManagerImpl.this.defaultDarkLaf.getValue() ? 1 : 0) != 0);
                LafManagerImpl.this.updateUI();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$UIThemeEPListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultMenuArrowIcon
    extends MenuArrowIcon {
        private static final BooleanSupplier dark = () -> ColorUtil.isDark((Color)UIManager.getColor("MenuItem.selectionBackground"));

        private DefaultMenuArrowIcon() {
            super((Function0<? extends Icon>)((Function0)() -> AllIcons.Icons.Ide.MenuArrow), (Function0<? extends Icon>)((Function0)() -> dark.getAsBoolean() ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow), (Function0<? extends Icon>)((Function0)() -> IconLoader.getDisabledIcon((Icon)AllIcons.Icons.Ide.MenuArrow)));
        }
    }

    private static final class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        OurPopupFactory(PopupFactory delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) {
            boolean isHeavyWeightPopup;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int popupType = PopupUtil.getPopupType((PopupFactory)this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType((PopupFactory)this.myDelegate, (int)popupType);
            }
            Popup popup2 = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            final Window window = ComponentUtil.getWindow((Component)contents);
            final String cleanupKey = "LafManagerImpl.rootPaneCleanup";
            boolean bl = isHeavyWeightPopup = window instanceof RootPaneContainer && window != ComponentUtil.getWindow((Component)owner);
            if (isHeavyWeightPopup) {
                UIUtil.markAsTypeAheadAware((Window)window);
                window.setMinimumSize(null);
            }
            if (isHeavyWeightPopup && ((RootPaneContainer)((Object)window)).getRootPane().getClientProperty(cleanupKey) == null) {
                final JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.setGlassPane(new IdeGlassPaneImpl(rootPane, false));
                rootPane.putClientProperty(LafManagerImpl.WINDOW_ALPHA, Float.valueOf(1.0f));
                rootPane.putClientProperty(cleanupKey, cleanupKey);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (PopupUtil.getPopupContainerFor((Component)rootPane) != null) {
                            window.removeWindowListener(this);
                            rootPane.putClientProperty(cleanupKey, null);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeWindowListener(this);
                        rootPane.putClientProperty(cleanupKey, null);
                        DialogWrapper.cleanupRootPane((JRootPane)rootPane);
                        DialogWrapper.cleanupWindowListeners((Window)window);
                    }
                });
            }
            return popup2;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info2;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info2 = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info2 != null) {
                Point mouse = info2.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size2 = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size2);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }
    }
}

