/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.DarculaMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;

public class DarculaLaf
extends BasicLookAndFeel
implements UserDataHolder {
    private static final Object SYSTEM = new Object();
    @NlsSafe
    public static final String NAME = "Darcula";
    @NlsSafe
    private static final String DESCRIPTION = "IntelliJ Dark Look and Feel";
    private LookAndFeel base;
    private boolean isBaseInitialized;
    protected Disposable myDisposable;
    private final UserDataHolderBase myUserData;
    private static boolean myAltPressed;

    public DarculaLaf(@NotNull LookAndFeel base) {
        if (base == null) {
            DarculaLaf.$$$reportNull$$$0(0);
        }
        this.myUserData = new UserDataHolderBase();
        this.base = base;
        this.isBaseInitialized = true;
    }

    public DarculaLaf() {
        this.myUserData = new UserDataHolderBase();
    }

    private void callInit(String method2, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method2, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DarculaLaf.$$$reportNull$$$0(1);
        }
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            DarculaLaf.$$$reportNull$$$0(2);
        }
        this.myUserData.putUserData(key, value2);
    }

    protected static void log(Exception e) {
        Logger.getInstance(DarculaLaf.class).error((Throwable)e);
    }

    @NotNull
    private static Font toFont(UIDefaults defaults, Object key) {
        Object value2 = defaults.get(key);
        if (value2 instanceof Font) {
            Font font = (Font)value2;
            if (font == null) {
                DarculaLaf.$$$reportNull$$$0(3);
            }
            return font;
        }
        if (value2 instanceof UIDefaults.ActiveValue && (value2 = ((UIDefaults.ActiveValue)value2).createValue(defaults)) instanceof Font) {
            Font font = (Font)value2;
            if (font == null) {
                DarculaLaf.$$$reportNull$$$0(4);
            }
            return font;
        }
        throw new UnsupportedOperationException("Unable to extract Font from \"" + key + "\"");
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
            UIDefaults defaults = this.base.getDefaults();
            if (SystemInfoRt.isLinux && Arrays.asList("CN", "JP", "KR", "TW").contains(Locale.getDefault().getCountry())) {
                defaults.keySet().stream().filter(key -> key.toString().endsWith(".font")).forEach(key -> {
                    Font font = DarculaLaf.toFont(defaults, key);
                    FontUIResource uiFont = new FontUIResource("Dialog", font.getStyle(), font.getSize());
                    defaults.put(key, uiFont);
                });
            }
            StartupUiUtil.initInputMapDefaults((UIDefaults)defaults);
            this.initIdeaDefaults(defaults);
            this.patchStyledEditorKit(defaults);
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            defaults.remove("Spinner.arrowButtonBorder");
            defaults.put("Spinner.arrowButtonSize", JBUI.size((int)16, (int)5).asUIResource());
            MetalLookAndFeel.setCurrentTheme(this.createMetalTheme());
            if (SystemInfoRt.isMac) {
                defaults.put("RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release", "meta ENTER", "press", "meta released ENTER", "release"});
            }
            defaults.put("EditorPane.font", DarculaLaf.toFont(defaults, "TextField.font"));
            return defaults;
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return super.getDefaults();
        }
    }

    protected DefaultMetalTheme createMetalTheme() {
        return new DarculaMetalTheme();
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private void patchStyledEditorKit(UIDefaults defaults) {
        URL url = this.getClass().getResource(this.getPrefix() + (JBUIScale.isUsrHiDPI() ? "@2x.css" : ".css"));
        StyleSheet styleSheet = StartupUiUtil.loadStyleSheet((URL)url);
        defaults.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        try {
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            AppContext.getAppContext().put(keyField.get(null), StartupUiUtil.loadStyleSheet((URL)url));
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    @NotNull
    protected String getPrefix() {
        return "darcula";
    }

    @Nullable
    protected String getSystemPrefix() {
        if (DarculaLaf.isLoadFromJsonEnabled()) {
            return null;
        }
        String osSuffix = SystemInfoRt.isMac ? "mac" : (SystemInfoRt.isWindows ? "windows" : "linux");
        return this.getPrefix() + "_" + osSuffix;
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        this.callInit("initComponentDefaults", defaults);
    }

    protected void initIdeaDefaults(UIDefaults defaults) {
        this.loadDefaults(defaults);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "meta C", "copy", "ctrl V", "paste", "meta V", "paste", "ctrl X", "cut", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
    }

    protected void loadDefaults(UIDefaults defaults) {
        if (DarculaLaf.isLoadFromJsonEnabled()) {
            this.loadDefaultsFromJson(defaults);
        } else {
            this.loadDefaultsFromProperties(defaults);
        }
    }

    private static boolean isLoadFromJsonEnabled() {
        return Boolean.parseBoolean(System.getProperty("ide.load.laf.as.json", "true"));
    }

    protected void loadDefaultsFromJson(UIDefaults defaults) {
        this.loadDefaultsFromJson(defaults, this.getPrefix());
        if (this.getSystemPrefix() != null) {
            this.loadDefaultsFromJson(defaults, this.getSystemPrefix());
        }
    }

    private void loadDefaultsFromJson(UIDefaults defaults, String prefix2) {
        String filename = prefix2 + ".theme.json";
        try (InputStream stream = this.getClass().getResourceAsStream(filename);){
            assert (stream != null) : "Can't load " + filename;
            UITheme theme = UITheme.loadFromJson(stream, NAME, this.getClass().getClassLoader(), Function.identity());
            theme.applyProperties(defaults);
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    protected void loadDefaultsFromProperties(UIDefaults defaults) {
        try {
            final HashMap map2 = new HashMap(300);
            Properties properties = new Properties(){

                @Override
                public Object put(Object key, Object value2) {
                    return map2.put((String)key, (String)value2);
                }
            };
            try (InputStream stream = this.getClass().getResourceAsStream(this.getPrefix() + ".properties");){
                properties.load(stream);
            }
            String systemPrefix = this.getSystemPrefix();
            if (systemPrefix != null && !systemPrefix.isEmpty()) {
                try (InputStream stream = this.getClass().getResourceAsStream(systemPrefix + ".properties");){
                    properties.load(stream);
                }
            }
            HashMap<String, Object> darculaGlobalSettings = new HashMap<String, Object>(32);
            Object prefix2 = this.getPrefix();
            prefix2 = ((String)prefix2).substring(((String)prefix2).lastIndexOf("/") + 1) + ".";
            for (String key : map2.keySet()) {
                if (!key.startsWith((String)prefix2)) continue;
                Object object = this.parseValue(key, (String)map2.get(key));
                String darculaKey = key.substring(((String)prefix2).length());
                if (object == SYSTEM) {
                    darculaGlobalSettings.remove(darculaKey);
                    continue;
                }
                darculaGlobalSettings.put(darculaKey, object);
            }
            UIDefaults multiUiDefaults = UIManager.getDefaults();
            for (Object k : defaults.keySet()) {
                String s;
                String darculaKey;
                if (!(k instanceof String) || !((String)k).contains(".") || !darculaGlobalSettings.containsKey(darculaKey = (s = (String)k).substring(s.lastIndexOf(46) + 1))) continue;
                multiUiDefaults.remove(k);
                defaults.put(k, darculaGlobalSettings.get(darculaKey));
            }
            for (Map.Entry entry2 : map2.entrySet()) {
                multiUiDefaults.remove(entry2.getKey());
                defaults.put(entry2.getKey(), this.parseValue((String)entry2.getKey(), (String)entry2.getValue()));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    protected Object parseValue(String key, @NotNull String value2) {
        if (value2 == null) {
            DarculaLaf.$$$reportNull$$$0(5);
        }
        if ("system".equals(value2)) {
            return SYSTEM;
        }
        return UITheme.parseValue(key, value2, this.getClass().getClassLoader());
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        if (!this.isBaseInitialized) {
            try {
                if (this.base == null) {
                    this.base = DarculaLaf.createBaseLaF();
                }
                this.base.initialize();
            }
            catch (Throwable e) {
                Logger.getInstance(DarculaLaf.class).error(e);
            }
        }
        if (LoadingState.LAF_INITIALIZED.isOccurred()) {
            this.ideEventQueueInitialized(IdeEventQueue.getInstance());
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static LookAndFeel createBaseLaF() throws Throwable {
        if (SystemInfoRt.isMac) {
            Class<?> aClass = DarculaLaf.class.getClassLoader().loadClass(UIManager.getSystemLookAndFeelClassName());
            BasicLookAndFeel basicLookAndFeel = MethodHandles.lookup().findConstructor(aClass, MethodType.methodType(Void.TYPE)).invoke();
            if (basicLookAndFeel == null) {
                DarculaLaf.$$$reportNull$$$0(6);
            }
            return basicLookAndFeel;
        }
        HashMap<Object, Object> fontDefaults = new HashMap<Object, Object>();
        if (SystemInfoRt.isLinux) {
            try {
                String name = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                Class<?> aClass = DarculaLaf.class.getClassLoader().loadClass(name);
                LookAndFeel gtk = MethodHandles.lookup().findConstructor(aClass, MethodType.methodType(Void.TYPE)).invoke();
                if (gtk.isSupportedLookAndFeel()) {
                    gtk.initialize();
                    UIDefaults gtkDefaults = gtk.getDefaults();
                    for (Object key : gtkDefaults.keySet()) {
                        if (!key.toString().endsWith(".font")) continue;
                        fontDefaults.put(key, gtkDefaults.get(key));
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance(DarculaLaf.class).debug((Throwable)e);
            }
        }
        return new IdeaLaf(fontDefaults.isEmpty() ? null : fontDefaults);
    }

    @ApiStatus.Internal
    public void appCreated(@NotNull Disposable parent) {
        if (parent == null) {
            DarculaLaf.$$$reportNull$$$0(7);
        }
        if (this.myDisposable != null) {
            Disposer.register((Disposable)parent, (Disposable)this.myDisposable);
        }
    }

    @ApiStatus.Internal
    public final void ideEventQueueInitialized(@NotNull IdeEventQueue eventQueue) {
        if (eventQueue == null) {
            DarculaLaf.$$$reportNull$$$0(8);
        }
        if (this.myDisposable == null) {
            Application application;
            this.myDisposable = Disposer.newDisposable();
            if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && (application = ApplicationManager.getApplication()) != null) {
                Disposer.register((Disposable)application, (Disposable)this.myDisposable);
            }
        }
        eventQueue.addDispatcher(new IdeEventQueue.EventDispatcher(){
            private Alarm mnemonicAlarm;

            @Override
            public boolean dispatch(@NotNull AWTEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(e instanceof KeyEvent) || ((KeyEvent)e).getKeyCode() != 18) {
                    return false;
                }
                myAltPressed = e.getID() == 401;
                Alarm mnemonicAlarm = this.mnemonicAlarm;
                if (mnemonicAlarm == null) {
                    this.mnemonicAlarm = mnemonicAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, DarculaLaf.this.myDisposable);
                }
                mnemonicAlarm.cancelAllRequests();
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner != null) {
                    mnemonicAlarm.addRequest(() -> DarculaLaf.repaintMnemonics(focusOwner, myAltPressed), 10);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/laf/darcula/DarculaLaf$2", "dispatch"));
            }
        }, this.myDisposable);
    }

    public static boolean isAltPressed() {
        return myAltPressed;
    }

    private static void repaintMnemonics(@NotNull Component focusOwner, boolean pressed) {
        if (focusOwner == null) {
            DarculaLaf.$$$reportNull$$$0(9);
        }
        if (pressed != myAltPressed) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(focusOwner);
        if (window == null) {
            return;
        }
        for (Component component2 : window.getComponents()) {
            if (!(component2 instanceof JComponent)) continue;
            for (JComponent c : ComponentUtil.findComponentsOfType((JComponent)((JComponent)component2), JComponent.class)) {
                if ((!(c instanceof JLabel) || ((JLabel)c).getDisplayedMnemonicIndex() == -1) && (!(c instanceof AbstractButton) || ((AbstractButton)c).getDisplayedMnemonicIndex() == -1)) continue;
                c.repaint();
            }
        }
    }

    @Override
    public void uninitialize() {
        try {
            this.isBaseInitialized = false;
            this.base.uninitialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    @Override
    protected final void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    @Override
    public final Icon getDisabledIcon(JComponent component2, Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        ScaleContext ctx = ScaleContext.create((Component)component2);
        icon2 = MultiResolutionImageProvider.convertFromJBIcon((Icon)icon2, (ScaleContext)ctx);
        Icon disabledIcon = super.getDisabledIcon(component2, icon2);
        if ((disabledIcon = MultiResolutionImageProvider.convertFromMRIcon((Icon)disabledIcon, (ScaleContext)ctx)) != null) {
            return disabledIcon;
        }
        return IconLoader.getDisabledIcon((Icon)icon2, (Component)component2);
    }

    @Override
    public final boolean getSupportsWindowDecorations() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/DarculaLaf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/DarculaLaf";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toFont";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseLaF";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appCreated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ideEventQueueInitialized";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "repaintMnemonics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

