/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/DialogsCounterUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.platform.ide.impl"})
public final class DialogsCounterUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    @NotNull
    private static final PrimitiveEventField<Integer> EXIT_CODE;
    @NotNull
    private static final StringEventField DIALOG_CLASS;
    @NotNull
    private static final VarargEventId SHOW;
    @NotNull
    private static final VarargEventId CLOSE;
    @NotNull
    private static final VarargEventId HELP;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("ui.dialogs", 59);
        EXIT_CODE = (PrimitiveEventField)new PrimitiveEventField<Integer>(){
            @NotNull
            private final String name;

            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object)"{enum:0|1|2}");
            }

            public void addData(@NotNull FeatureUsageData fuData, int value2) {
                Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
                int toReport = this.getExitCodeToReport(value2);
                fuData.addData(this.getName(), toReport);
            }

            private final int getExitCodeToReport(int exitCode) {
                if (exitCode == 0 || exitCode == 1) {
                    return exitCode;
                }
                return 2;
            }
            {
                this.name = "code";
            }
        };
        DIALOG_CLASS = EventFields.StringValidatedByCustomRule((String)"dialog_class", (String)"dialog_class");
        SHOW = GROUP.registerVarargEvent("show", new EventField[]{(EventField)DIALOG_CLASS, (EventField)EventFields.PluginInfo});
        CLOSE = GROUP.registerVarargEvent("close", new EventField[]{(EventField)DIALOG_CLASS, (EventField)EXIT_CODE, (EventField)EventFields.PluginInfo});
        HELP = GROUP.registerVarargEvent("help.clicked", new EventField[]{(EventField)DIALOG_CLASS, (EventField)EventFields.PluginInfo});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/DialogsCounterUsagesCollector$Companion;", "", "()V", "CLOSE", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getCLOSE", "()Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "DIALOG_CLASS", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getDIALOG_CLASS", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "EXIT_CODE", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "getEXIT_CODE", "()Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HELP", "getHELP", "SHOW", "getSHOW", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final PrimitiveEventField<Integer> getEXIT_CODE() {
            return EXIT_CODE;
        }

        @NotNull
        public final StringEventField getDIALOG_CLASS() {
            return DIALOG_CLASS;
        }

        @NotNull
        public final VarargEventId getSHOW() {
            return SHOW;
        }

        @NotNull
        public final VarargEventId getCLOSE() {
            return CLOSE;
        }

        @NotNull
        public final VarargEventId getHELP() {
            return HELP;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

