/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eJ$\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0004J \u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u001aH\u0014J0\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0014J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%2\u0006\u0010#\u001a\u00020\u001aH\u0014J\u001c\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/javascript/debugger/NameMapper;", "", "document", "Lcom/intellij/openapi/editor/Document;", "transpiledDocument", "sourceMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/debugger/sourcemap/Mappings;Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;)V", "<set-?>", "", "", "rawNameToSource", "getRawNameToSource", "()Ljava/util/Map;", "getSourceMap", "()Lorg/jetbrains/debugger/sourcemap/SourceMap;", "addMapping", "", "generatedName", "sourceName", "doMap", "identifierOrNamedElement", "Lcom/intellij/psi/PsiElement;", "mapBySourceCode", "", "saveMapping", "extractName", "rawGeneratedName", "", "context", "getGeneratedName", "element", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getMappingsForElement", "map", "Companion", "intellij.platform.scriptDebugger.ui"})
public class NameMapper {
    @Nullable
    private Map<String, String> rawNameToSource;
    private final Document document;
    private final Document transpiledDocument;
    private final Mappings sourceMappings;
    @NotNull
    private final SourceMap sourceMap;
    private final VirtualFile transpiledFile;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    @JvmOverloads
    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement, boolean saveMapping) {
        Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        return this.doMap(identifierOrNamedElement, false, saveMapping);
    }

    public static /* synthetic */ String map$default(NameMapper nameMapper, PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: map");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return nameMapper.map(psiElement, bl);
    }

    @JvmOverloads
    @Nullable
    public final String map(@NotNull PsiElement identifierOrNamedElement) {
        return NameMapper.map$default(this, identifierOrNamedElement, false, 2, null);
    }

    @Nullable
    protected final String doMap(@NotNull PsiElement identifierOrNamedElement, boolean mapBySourceCode, boolean saveMapping) {
        String generatedName;
        MappingEntry sourceEntry;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
                List<MappingEntry> mappings = this.getMappingsForElement(identifierOrNamedElement);
                if (mappings == null || mappings.isEmpty()) {
                    return null;
                }
                sourceEntry = mappings.get(0);
                generatedName = null;
                try {
                    generatedName = this.extractName(this.getGeneratedName(identifierOrNamedElement, this.transpiledDocument, this.sourceMap, mappings), identifierOrNamedElement);
                }
                catch (IndexOutOfBoundsException e) {
                    VirtualFile virtualFile2 = this.transpiledFile;
                    CommandProcessorKt.getLOG().warn("Cannot get generated name: source entry (" + sourceEntry.getGeneratedLine() + ",  " + sourceEntry.getGeneratedColumn() + "). Transpiled File: " + (virtualFile2 != null ? virtualFile2.getPath() : null));
                    return null;
                }
                if (generatedName == null) break block12;
                CharSequence e = generatedName;
                boolean bl = false;
                if (!(e.length() == 0)) break block13;
            }
            return null;
        }
        String sourceName = sourceEntry.getName();
        if (sourceName == null || mapBySourceCode) {
            Object object;
            Object object2;
            PsiElement psiElement = identifierOrNamedElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            if ((object2 = (PsiNamedElement)psiElement) == null || (object2 = object2.getName()) == null) {
                object2 = object = identifierOrNamedElement.getText();
            }
            if (object2 == null) {
                object = sourceName;
            }
            if (object == null) {
                return null;
            }
            sourceName = object;
        }
        if (saveMapping) {
            this.addMapping(generatedName, sourceName);
        }
        return generatedName;
    }

    public static /* synthetic */ String doMap$default(NameMapper nameMapper, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doMap");
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return nameMapper.doMap(psiElement, bl, bl2);
    }

    @Nullable
    protected List<MappingEntry> getMappingsForElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        boolean bl = false;
        List mappings = new ArrayList();
        int offset = element2.getTextOffset();
        int line = this.document.getLineNumber(offset);
        int elementColumn = offset - this.document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element2.getTextLength() - 1;
        int sourceEntryIndex = this.sourceMappings.indexOf(line, elementColumn);
        if (sourceEntryIndex == -1) {
            return null;
        }
        MappingEntry sourceEntry = this.sourceMappings.getByIndex(sourceEntryIndex);
        MappingEntry next = this.sourceMappings.getNextOnTheSameLine(sourceEntryIndex, false);
        if (next != null && this.sourceMappings.getColumn(next) == this.sourceMappings.getColumn(sourceEntry)) {
            NameMapperKt.warnSeveralMapping(element2);
            return null;
        }
        PsiFile file2 = element2.getContainingFile();
        AtomicInteger namedElementsCounter = new AtomicInteger(0);
        MappingsProcessorInLine processor2 = new MappingsProcessorInLine(this, elementColumn, elementEndColumn, line, mappings, file2, namedElementsCounter){
            final /* synthetic */ NameMapper this$0;
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ int $line;
            final /* synthetic */ List $mappings;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ AtomicInteger $namedElementsCounter;

            public boolean process(@NotNull MappingEntry entry2, @Nullable MappingEntry nextEntry) {
                int n;
                boolean isSuitable;
                Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                int entryColumn = entry2.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : (isSuitable = this.$elementColumn <= (n = entryColumn) && this.$elementEndColumn >= n);
                if (isSuitable) {
                    int endOffset;
                    int startOffset = NameMapper.access$getDocument$p(this.this$0).getLineStartOffset(this.$line) + entryColumn;
                    int n2 = endOffset = nextEntry != null ? NameMapper.access$getDocument$p(this.this$0).getLineStartOffset(this.$line) + nextEntry.getSourceColumn() : NameMapper.access$getDocument$p(this.this$0).getLineEndOffset(this.$line);
                    if (this.collectNamedElementsInRange(new TextRange(startOffset, endOffset))) {
                        return false;
                    }
                    this.$mappings.add(entry2);
                }
                return true;
            }

            private final boolean collectNamedElementsInRange(TextRange range2) {
                JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.$file)).onRange(range2).filter(new Condition(this, range2){
                    final /* synthetic */ getMappingsForElement.processor.1 this$0;
                    final /* synthetic */ TextRange $range;

                    public final boolean value(PsiElement it) {
                        return it instanceof PsiNamedElement && this.$range.contains(((PsiNamedElement)it).getTextRange()) && this.this$0.$namedElementsCounter.incrementAndGet() > 1;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$range = textRange;
                    }
                })).traverse();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u20261 }\n          .traverse()");
                return jBIterable.isNotEmpty();
            }
            {
                this.this$0 = this$0;
                this.$elementColumn = $captured_local_variable$1;
                this.$elementEndColumn = $captured_local_variable$2;
                this.$line = $captured_local_variable$3;
                this.$mappings = $captured_local_variable$4;
                this.$file = $captured_local_variable$5;
                this.$namedElementsCounter = $captured_local_variable$6;
            }

            public boolean processIterable(@NotNull Iterable<? extends MappingEntry> mappingsInLine) {
                Intrinsics.checkNotNullParameter(mappingsInLine, (String)"mappingsInLine");
                return MappingsProcessorInLine.DefaultImpls.processIterable(this, mappingsInLine);
            }
        };
        if (!this.sourceMap.processSourceMappingsInLine(sourceEntry.getSource(), sourceEntry.getSourceLine(), processor2)) {
            return null;
        }
        return mappings;
    }

    public final void addMapping(@NotNull String generatedName, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter((Object)generatedName, (String)"generatedName");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        if (this.rawNameToSource == null) {
            this.rawNameToSource = new HashMap();
        }
        Map<String, String> map2 = this.rawNameToSource;
        Intrinsics.checkNotNull(map2);
        map2.put(generatedName, sourceName);
    }

    @Nullable
    protected String extractName(@Nullable CharSequence rawGeneratedName, @Nullable PsiElement context2) {
        String string;
        CharSequence charSequence = rawGeneratedName;
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence2;
            boolean bl3 = false;
            string = NameMapperKt.getNAME_TRIMMER().trimFrom(it);
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String extractName$default(NameMapper nameMapper, CharSequence charSequence, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractName");
        }
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return nameMapper.extractName(charSequence, psiElement);
    }

    @Nullable
    protected CharSequence getGeneratedName(@NotNull PsiElement element2, @NotNull Document document, @NotNull SourceMap sourceMap, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        MappingEntry sourceEntry = mappings.get(0);
        int lineStartOffset = document.getLineStartOffset(sourceEntry.getGeneratedLine());
        MappingEntry nextGeneratedMapping = sourceMap.getGeneratedMappings().getNextOnTheSameLine(sourceEntry);
        int endOffset = 0;
        endOffset = nextGeneratedMapping == null ? document.getLineEndOffset(sourceEntry.getGeneratedLine()) : lineStartOffset + nextGeneratedMapping.getGeneratedColumn();
        return document.getImmutableCharSequence().subSequence(lineStartOffset + sourceEntry.getGeneratedColumn(), endOffset);
    }

    @NotNull
    protected final SourceMap getSourceMap() {
        return this.sourceMap;
    }

    public NameMapper(@NotNull Document document, @NotNull Document transpiledDocument, @NotNull Mappings sourceMappings, @NotNull SourceMap sourceMap, @Nullable VirtualFile transpiledFile) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)transpiledDocument, (String)"transpiledDocument");
        Intrinsics.checkNotNullParameter((Object)sourceMappings, (String)"sourceMappings");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        this.document = document;
        this.transpiledDocument = transpiledDocument;
        this.sourceMappings = sourceMappings;
        this.sourceMap = sourceMap;
        this.transpiledFile = transpiledFile;
    }

    public /* synthetic */ NameMapper(Document document, Document document2, Mappings mappings, SourceMap sourceMap, VirtualFile virtualFile2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            virtualFile2 = null;
        }
        this(document, document2, mappings, sourceMap, virtualFile2);
    }

    public static final /* synthetic */ Document access$getDocument$p(NameMapper $this) {
        return $this.document;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/NameMapper$Companion;", "", "()V", "trimName", "", "rawGeneratedName", "", "isLastToken", "", "intellij.platform.scriptDebugger.ui"})
    public static final class Companion {
        @Nullable
        public final String trimName(@NotNull CharSequence rawGeneratedName, boolean isLastToken) {
            Intrinsics.checkNotNullParameter((Object)rawGeneratedName, (String)"rawGeneratedName");
            return (isLastToken ? NameMapperKt.getNAME_TRIMMER() : NameMapperKt.access$getOPERATOR_TRIMMER$p()).trimFrom(rawGeneratedName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

