/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> cls) {
        if (cls == null) {
            JsonUtil.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression.getClass())) {
            return (T)expression;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        JsonProperty property2;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JsonUtil.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            JsonUtil.$$$reportNull$$$0(3);
        }
        if ((property2 = object.findProperty(name)) == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property2.getValue(), clazz));
    }

    public static boolean isArrayElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonUtil.$$$reportNull$$$0(4);
        }
        return element2 instanceof JsonValue && element2.getParent() instanceof JsonArray;
    }

    public static int getArrayIndexOfItem(@NotNull PsiElement e) {
        PsiElement parent;
        if (e == null) {
            JsonUtil.$$$reportNull$$$0(5);
        }
        if (!((parent = e.getParent()) instanceof JsonArray)) {
            return -1;
        }
        List<JsonValue> elements = ((JsonArray)parent).getValueList();
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            if (e != elements.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JsonObject getTopLevelObject(@Nullable JsonFile jsonFile) {
        return jsonFile != null ? (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class) : null;
    }

    public static boolean isJsonFile(@NotNull VirtualFile file2, @Nullable Project project) {
        FileType type;
        if (file2 == null) {
            JsonUtil.$$$reportNull$$$0(6);
        }
        if ((type = file2.getFileType()) instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof JsonLanguage) {
            return true;
        }
        if (project == null || !ScratchUtil.isScratch((VirtualFile)file2)) {
            return false;
        }
        RootType rootType = ScratchFileService.findRootType((VirtualFile)file2);
        return rootType != null && rootType.substituteLanguage(project, file2) instanceof JsonLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/JsonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "as";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyValueOfType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayIndexOfItem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isJsonFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

