/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.smartEnter;

import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public static final Logger LOG = Logger.getInstance(JsonSmartEnterProcessor.class);
    private boolean myShouldAddNewline = false;

    public JsonSmartEnterProcessor() {
        this.addFixers(new JsonObjectPropertyFixer(), new JsonArrayElementFixer());
        this.addEnterProcessors(new JsonEnterProcessor());
    }

    @Override
    protected void collectAdditionalElements(@NotNull PsiElement element2, @NotNull List<PsiElement> result2) {
        if (element2 == null) {
            JsonSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JsonSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        for (PsiElement parent = element2.getParent(); parent != null && !(parent instanceof JsonFile); parent = parent.getParent()) {
            result2.add(parent);
        }
    }

    private static boolean terminatedOnCurrentLine(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JsonSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            JsonSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getCurrentCaret().getOffset();
        int elementEndOffset = element2.getTextRange().getEndOffset();
        if (document.getLineNumber(elementEndOffset) != document.getLineNumber(caretOffset)) {
            return false;
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element2, (boolean)true);
        return nextLeaf == null || nextLeaf instanceof PsiWhiteSpace && nextLeaf.getText().contains("\n");
    }

    private static boolean isFollowedByTerminal(@NotNull PsiElement element2, IElementType type) {
        PsiElement nextLeaf;
        if (element2 == null) {
            JsonSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        return (nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)element2)) != null && nextLeaf.getNode().getElementType() == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/editor/smartEnter/JsonSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "terminatedOnCurrentLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFollowedByTerminal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JsonEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private JsonEnterProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doEnter(PsiElement atCaret, PsiFile file2, @NotNull Editor editor, boolean modified) {
            if (editor == null) {
                JsonEnterProcessor.$$$reportNull$$$0(0);
            }
            if (JsonSmartEnterProcessor.this.myShouldAddNewline) {
                try {
                    this.plainEnter(editor);
                }
                finally {
                    JsonSmartEnterProcessor.this.myShouldAddNewline = false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/json/editor/smartEnter/JsonSmartEnterProcessor$JsonEnterProcessor", "doEnter"));
        }
    }

    private static class JsonObjectPropertyFixer
    extends SmartEnterProcessorWithFixers.Fixer<JsonSmartEnterProcessor> {
        private JsonObjectPropertyFixer() {
        }

        @Override
        public void apply(@NotNull Editor editor, @NotNull JsonSmartEnterProcessor processor2, @NotNull PsiElement element2) throws IncorrectOperationException {
            if (editor == null) {
                JsonObjectPropertyFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                JsonObjectPropertyFixer.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                JsonObjectPropertyFixer.$$$reportNull$$$0(2);
            }
            if (element2 instanceof JsonProperty) {
                JsonValue propertyValue = ((JsonProperty)element2).getValue();
                if (propertyValue != null) {
                    if (JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, propertyValue) && !JsonSmartEnterProcessor.isFollowedByTerminal(propertyValue, JsonElementTypes.COMMA)) {
                        editor.getDocument().insertString(propertyValue.getTextRange().getEndOffset(), (CharSequence)",");
                        processor2.myShouldAddNewline = true;
                    }
                } else {
                    JsonValue propertyKey = ((JsonProperty)element2).getNameElement();
                    TextRange keyRange = propertyKey.getTextRange();
                    int keyStartOffset = keyRange.getStartOffset();
                    int keyEndOffset = keyRange.getEndOffset();
                    if (JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, propertyKey) && !JsonSmartEnterProcessor.isFollowedByTerminal(propertyKey, JsonElementTypes.COLON)) {
                        boolean shouldQuoteKey;
                        boolean bl = shouldQuoteKey = propertyKey instanceof JsonReferenceExpression && JsonDialectUtil.isStandardJson(propertyKey);
                        if (shouldQuoteKey) {
                            editor.getDocument().insertString(keyStartOffset, (CharSequence)"\"");
                            editor.getDocument().insertString(++keyEndOffset, (CharSequence)"\"");
                            ++keyEndOffset;
                        }
                        processor2.myFirstErrorOffset = keyEndOffset + 2;
                        editor.getDocument().insertString(keyEndOffset, (CharSequence)": ");
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/json/editor/smartEnter/JsonSmartEnterProcessor$JsonObjectPropertyFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JsonArrayElementFixer
    extends SmartEnterProcessorWithFixers.Fixer<JsonSmartEnterProcessor> {
        private JsonArrayElementFixer() {
        }

        @Override
        public void apply(@NotNull Editor editor, @NotNull JsonSmartEnterProcessor processor2, @NotNull PsiElement element2) throws IncorrectOperationException {
            JsonValue arrayElement;
            if (editor == null) {
                JsonArrayElementFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                JsonArrayElementFixer.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                JsonArrayElementFixer.$$$reportNull$$$0(2);
            }
            if (element2 instanceof JsonValue && element2.getParent() instanceof JsonArray && JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, arrayElement = (JsonValue)element2) && !JsonSmartEnterProcessor.isFollowedByTerminal(element2, JsonElementTypes.COMMA)) {
                editor.getDocument().insertString(arrayElement.getTextRange().getEndOffset(), (CharSequence)",");
                processor2.myShouldAddNewline = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/json/editor/smartEnter/JsonSmartEnterProcessor$JsonArrayElementFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

