/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath;

import com.intellij.jsonpath.lexer.JsonPathLexer;
import com.intellij.jsonpath.psi.JsonPathTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class JsonPathSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey JSONPATH_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey JSONPATH_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey JSONPATH_CONTEXT = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.CONTEXT", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
    public static final TextAttributesKey JSONPATH_OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey JSONPATH_NUMBER = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey JSONPATH_BOOLEAN = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.BOOLEAN", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey JSONPATH_STRING = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey JSONPATH_PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey JSONPATH_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey JSONPATH_BRACES = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey JSONPATH_COMMA = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey JSONPATH_DOT = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey JSONPATH_COLON = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey JSONPATH_FUNCTION_CALL = TextAttributesKey.createTextAttributesKey((String)"JSONPATH.FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
    private static final Map<IElementType, TextAttributesKey> ourMap = new HashMap<IElementType, TextAttributesKey>();

    JsonPathSyntaxHighlighter() {
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new JsonPathLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = JsonPathSyntaxHighlighter.pack((TextAttributesKey)ourMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            JsonPathSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_KEYWORD, (IElementType[])new IElementType[]{JsonPathTypes.WILDCARD, JsonPathTypes.FILTER_OPERATOR, JsonPathTypes.NULL, JsonPathTypes.NAMED_OP});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_IDENTIFIER, (IElementType[])new IElementType[]{JsonPathTypes.IDENTIFIER});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_CONTEXT, (IElementType[])new IElementType[]{JsonPathTypes.ROOT_CONTEXT, JsonPathTypes.EVAL_CONTEXT});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_BRACKETS, (IElementType[])new IElementType[]{JsonPathTypes.LBRACKET, JsonPathTypes.RBRACKET});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_PARENTHESES, (IElementType[])new IElementType[]{JsonPathTypes.LPARENTH, JsonPathTypes.RPARENTH});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_DOT, (IElementType[])new IElementType[]{JsonPathTypes.DOT, JsonPathTypes.RECURSIVE_DESCENT});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_COMMA, (IElementType[])new IElementType[]{JsonPathTypes.COMMA});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_COLON, (IElementType[])new IElementType[]{JsonPathTypes.COLON});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_NUMBER, (IElementType[])new IElementType[]{JsonPathTypes.INTEGER_NUMBER, JsonPathTypes.DOUBLE_NUMBER});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_BOOLEAN, (IElementType[])new IElementType[]{JsonPathTypes.TRUE, JsonPathTypes.FALSE});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_STRING, (IElementType[])new IElementType[]{JsonPathTypes.SINGLE_QUOTED_STRING, JsonPathTypes.DOUBLE_QUOTED_STRING, JsonPathTypes.REGEX_STRING});
        JsonPathSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)JSONPATH_OPERATIONS, (IElementType[])new IElementType[]{JsonPathTypes.OR_OP, JsonPathTypes.AND_OP, JsonPathTypes.NOT_OP, JsonPathTypes.EQ_OP, JsonPathTypes.NE_OP, JsonPathTypes.RE_OP, JsonPathTypes.GT_OP, JsonPathTypes.LT_OP, JsonPathTypes.GE_OP, JsonPathTypes.LE_OP, JsonPathTypes.MINUS_OP, JsonPathTypes.PLUS_OP, JsonPathTypes.MULTIPLY_OP, JsonPathTypes.DIVIDE_OP});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsonpath/JsonPathSyntaxHighlighter", "getTokenHighlights"));
    }
}

