/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.jsonpath.JsonPathLanguage;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateIntentionAction;", "Lcom/intellij/codeInsight/intention/AbstractIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/util/Iconable;", "()V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "intellij.json"})
public final class JsonPathEvaluateIntentionAction
extends AbstractIntentionAction
implements HighPriorityAction,
Iconable {
    @NotNull
    public String getText() {
        String string = JsonBundle.message("jsonpath.evaluate.intention", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JsonBundle.message(\"jsonpath.evaluate.intention\")");
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2 == null) {
            return;
        }
        InjectedLanguageManager manager2 = InjectedLanguageManager.getInstance((Project)project);
        String jsonPath = manager2.isInjectedFragment(file2) ? manager2.getUnescapedText((PsiElement)file2) : file2.getText();
        JsonPathEvaluateManager.Companion.getInstance(project).evaluateExpression(jsonPath);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file2 == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)file2.getLanguage(), (Object)((Object)JsonPathLanguage.INSTANCE)) && Intrinsics.areEqual((Object)((Boolean)file2.getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY)), (Object)true) ^ true;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon2 = AllIcons.FileTypes.Json;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.FileTypes.Json");
        return icon2;
    }
}

