/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CustomFoldingSurroundDescriptor
implements SurroundDescriptor {
    public static final CustomFoldingSurroundDescriptor INSTANCE = new CustomFoldingSurroundDescriptor();
    private static final String DEFAULT_DESC_TEXT = "Description";

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        if (startOffset >= endOffset) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CustomFoldingSurroundDescriptor.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage());
        if (commenter == null || commenter.getLineCommentPrefix() == null && (commenter.getBlockCommentPrefix() == null || commenter.getBlockCommentSuffix() == null)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CustomFoldingSurroundDescriptor.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement startElement = file2.findElementAt(startOffset);
        PsiElement endElement = file2.findElementAt(endOffset - 1);
        if (startElement instanceof PsiWhiteSpace) {
            if (startElement == endElement) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CustomFoldingSurroundDescriptor.$$$reportNull$$$0(2);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            startElement = startElement.getNextSibling();
        }
        if (endElement instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        if (startElement != null && endElement != null && (startElement = CustomFoldingSurroundDescriptor.findClosestParentAfterLineBreak(startElement)) != null && (endElement = CustomFoldingSurroundDescriptor.findClosestParentBeforeLineBreak(endElement)) != null) {
            return CustomFoldingSurroundDescriptor.adjustRange(startElement, endElement);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(3);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement @NotNull [] adjustRange(@NotNull PsiElement start2, @NotNull PsiElement end) {
        PsiElement newEndParent;
        if (start2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(4);
        }
        if (end == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(5);
        }
        PsiElement newStart = CustomFoldingSurroundDescriptor.lowerStartElementIfNeeded(start2, end);
        PsiElement newEnd = CustomFoldingSurroundDescriptor.lowerEndElementIfNeeded(start2, end);
        if (newStart == null || newEnd == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CustomFoldingSurroundDescriptor.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement commonParent = CustomFoldingSurroundDescriptor.findCommonAncestorForWholeRange(newStart, newEnd);
        if (commonParent != null) {
            PsiElement[] psiElementArray = new PsiElement[]{commonParent};
            if (psiElementArray == null) {
                CustomFoldingSurroundDescriptor.$$$reportNull$$$0(7);
            }
            return psiElementArray;
        }
        PsiElement newStartParent = CustomFoldingSurroundDescriptor.getParent(newStart);
        if (newStartParent != null && newStartParent.getFirstChild() == newStart && newStart.getFirstChild() == null) {
            newStart = newStartParent;
        }
        if ((newEndParent = CustomFoldingSurroundDescriptor.getParent(newEnd)) != null && newEndParent.getLastChild() == newEnd && newEnd.getFirstChild() == null) {
            newEnd = newEndParent;
        }
        if (CustomFoldingSurroundDescriptor.getParent(newStart) == CustomFoldingSurroundDescriptor.getParent(newEnd)) {
            PsiElement[] psiElementArray = new PsiElement[]{newStart, newEnd};
            if (psiElementArray == null) {
                CustomFoldingSurroundDescriptor.$$$reportNull$$$0(8);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(9);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiElement getParent(@Nullable PsiElement e) {
        return e instanceof PsiFile ? e : PsiTreeUtil.skipParentsOfType((PsiElement)e, (Class[])new Class[]{GeneratedParserUtilBase.DummyBlock.class});
    }

    @Nullable
    private static PsiElement lowerEndElementIfNeeded(@NotNull PsiElement start2, @NotNull PsiElement end) {
        if (start2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(10);
        }
        if (end == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(11);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)end, (PsiElement)start2, (boolean)true)) {
            PsiElement o = end.getLastChild();
            while (o != null && o.getParent() != start2.getParent()) {
                PsiElement last = o.getLastChild();
                if (last == null) {
                    return o;
                }
                o = last;
            }
            return o;
        }
        return end;
    }

    @Nullable
    private static PsiElement lowerStartElementIfNeeded(@NotNull PsiElement start2, @NotNull PsiElement end) {
        if (start2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(12);
        }
        if (end == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(13);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)start2, (PsiElement)end, (boolean)true)) {
            PsiElement o = start2.getFirstChild();
            while (o != null && o.getParent() != end.getParent()) {
                PsiElement first = o.getFirstChild();
                if (first == null) {
                    return o;
                }
                o = first;
            }
            return o;
        }
        return start2;
    }

    @Nullable
    private static PsiElement findCommonAncestorForWholeRange(@NotNull PsiElement start2, @NotNull PsiElement end) {
        if (start2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(14);
        }
        if (end == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(15);
        }
        if (start2.getContainingFile() != end.getContainingFile()) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)end);
        if (parent == null) {
            return null;
        }
        TextRange parentRange = parent.getTextRange();
        if (parentRange.getStartOffset() == start2.getTextRange().getStartOffset() && parentRange.getEndOffset() == end.getTextRange().getEndOffset()) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement findClosestParentAfterLineBreak(PsiElement element2) {
        for (PsiElement parent = element2; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement prev2;
            for (prev2 = parent.getPrevSibling(); prev2 != null && prev2.getTextLength() <= 0; prev2 = prev2.getPrevSibling()) {
            }
            if (CustomFoldingSurroundDescriptor.firstElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(prev2)) continue;
            return parent;
        }
        return null;
    }

    private static boolean firstElementInFile(@NotNull PsiElement element2) {
        if (element2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(16);
        }
        return element2.getTextOffset() == 0;
    }

    @Nullable
    private static PsiElement findClosestParentBeforeLineBreak(PsiElement element2) {
        for (PsiElement parent = element2; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement next = parent.getNextSibling();
            if (CustomFoldingSurroundDescriptor.lastElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(next)) continue;
            return parent;
        }
        return null;
    }

    private static boolean lastElementInFile(@NotNull PsiElement element2) {
        if (element2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(17);
        }
        return element2.getTextRange().getEndOffset() == element2.getContainingFile().getTextRange().getEndOffset();
    }

    private static boolean isWhiteSpaceWithLineFeed(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof PsiWhiteSpace) {
            return element2.textContains('\n');
        }
        ASTNode node2 = element2.getNode();
        if (node2 == null) {
            return false;
        }
        CharSequence text2 = node2.getChars();
        boolean lineFeedFound = false;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            lineFeedFound |= c == '\n';
        }
        return lineFeedFound;
    }

    public Surrounder @NotNull [] getSurrounders() {
        Surrounder[] surrounderArray = CustomFoldingSurroundDescriptor.getAllSurrounders().toArray(new CustomFoldingRegionSurrounder[0]);
        if (surrounderArray == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(18);
        }
        return surrounderArray;
    }

    @TestOnly
    @NotNull
    public static List<CustomFoldingRegionSurrounder> getAllSurrounders() {
        List list2 = ContainerUtil.map((Collection)CustomFoldingProvider.getAllProviders(), provider2 -> new CustomFoldingRegionSurrounder((CustomFoldingProvider)provider2));
        if (list2 == null) {
            CustomFoldingSurroundDescriptor.$$$reportNull$$$0(19);
        }
        return list2;
    }

    public boolean isExclusive() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CustomFoldingSurroundDescriptor";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CustomFoldingSurroundDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustRange";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSurrounders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lowerEndElementIfNeeded";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lowerStartElementIfNeeded";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestorForWholeRange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "firstElementInFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lastElementInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomFoldingRegionSurrounder
    implements Surrounder {
        private final CustomFoldingProvider myProvider;

        CustomFoldingRegionSurrounder(@NotNull CustomFoldingProvider provider2) {
            if (provider2 == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(0);
            }
            this.myProvider = provider2;
        }

        public String getTemplateDescription() {
            return this.myProvider.getDescription();
        }

        public boolean isApplicable(@NotNull @NotNull PsiElement @NotNull [] elements) {
            if (elements == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(1);
            }
            if (elements.length == 0) {
                return false;
            }
            if (elements[0].getContainingFile() instanceof PsiCodeFragment) {
                return false;
            }
            for (FoldingBuilder each : LanguageFolding.INSTANCE.allForLanguage(elements[0].getLanguage())) {
                if (!this.myProvider.isSupportedBy(each)) continue;
                return true;
            }
            return false;
        }

        public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
            String lineSuffix;
            String linePrefix;
            if (project == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(3);
            }
            if (elements == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(4);
            }
            if (elements.length == 0) {
                return null;
            }
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            PsiFile psiFile = firstElement.getContainingFile();
            Language language = psiFile.getLanguage();
            if (this.myProvider.wrapStartEndMarkerTextInLanguageSpecificComment()) {
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
                if (commenter == null) {
                    return null;
                }
                linePrefix = commenter.getLineCommentPrefix();
                lineSuffix = "";
                if (linePrefix == null) {
                    linePrefix = commenter.getBlockCommentPrefix();
                    lineSuffix = StringUtil.notNullize((String)commenter.getBlockCommentSuffix());
                }
                if (linePrefix == null) {
                    return null;
                }
            } else {
                linePrefix = "";
                lineSuffix = "";
            }
            int prefixLength = linePrefix.length();
            int startOffset = firstElement.getTextRange().getStartOffset();
            Document document = editor.getDocument();
            int startLineNumber = document.getLineNumber(startOffset);
            String startIndent = document.getText(new TextRange(document.getLineStartOffset(startLineNumber), startOffset));
            int endOffset = lastElement.getTextRange().getEndOffset();
            int delta = 0;
            TextRange rangeToSelect = TextRange.create((int)startOffset, (int)startOffset);
            String startText = this.myProvider.getStartString();
            int descPos = startText.indexOf("?");
            if (descPos >= 0) {
                startText = startText.replace("?", CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT);
                rangeToSelect = TextRange.from((int)(startOffset + descPos), (int)CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT.length());
            }
            String startString = linePrefix + startText + lineSuffix + "\n" + startIndent;
            String endString = "\n" + startIndent + linePrefix + this.myProvider.getEndString() + lineSuffix;
            document.insertString(endOffset, (CharSequence)endString);
            delta += endString.length();
            document.insertString(startOffset, (CharSequence)startString);
            RangeMarker rangeMarkerToSelect = document.createRangeMarker(rangeToSelect.shiftRight(prefixLength));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, TextRange.from((int)(endOffset + (delta += startString.length()) - endString.length()), (int)endString.length()));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, TextRange.from((int)startOffset, (int)startString.length()));
            rangeToSelect = TextRange.create((int)rangeMarkerToSelect.getStartOffset(), (int)rangeMarkerToSelect.getEndOffset());
            rangeMarkerToSelect.dispose();
            return rangeToSelect;
        }

        private static void adjustLineIndent(@NotNull Project project, PsiFile file2, Language language, TextRange range2) {
            if (project == null) {
                CustomFoldingRegionSurrounder.$$$reportNull$$$0(5);
            }
            CommonCodeStyleSettings formatSettings = CodeStyle.getLanguageSettings((PsiFile)file2, (Language)language);
            boolean keepAtFirstCol = formatSettings.KEEP_FIRST_COLUMN_COMMENT;
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = false;
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, range2);
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = keepAtFirstCol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "surroundElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "adjustLineIndent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

