/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.InternalDecoratorImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private static final Logger LOG = Logger.getInstance(ActionPopupMenuImpl.class);
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private Supplier<? extends DataContext> myDataContextProvider;
    private MessageBusConnection myConnection;
    private IdeFrame myFrame;
    private boolean myIsToolWindowContextMenu;

    ActionPopupMenuImpl(@NotNull String place, @NotNull ActionGroup group2, @NotNull ActionManagerImpl actionManager, @Nullable PresentationFactory factory2) {
        if (place == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(0);
        }
        if (group2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(1);
        }
        if (actionManager == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(2);
        }
        if ("unknown".equals(place) || place.isEmpty()) {
            LOG.warn("Please do not use ActionPlaces.UNKNOWN or the empty place. Any string unique enough to deduce the popup menu location will do.", new Throwable("popup menu creation trace"));
        }
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group2, factory2);
    }

    @NotNull
    public JPopupMenu getComponent() {
        MyMenu myMenu = this.myMenu;
        if (myMenu == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(3);
        }
        return myMenu;
    }

    @NotNull
    public String getPlace() {
        String string = this.myMenu.myPlace;
        if (string == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ActionGroup getActionGroup() {
        ActionGroup actionGroup2 = this.myMenu.myGroup;
        if (actionGroup2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(5);
        }
        return actionGroup2;
    }

    void setDataContextProvider(@NotNull Supplier<? extends DataContext> dataContextProvider) {
        if (dataContextProvider == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(6);
        }
        this.myDataContextProvider = dataContextProvider;
    }

    public void setTargetComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(7);
        }
        this.myDataContextProvider = () -> DataManager.getInstance().getDataContext((Component)component2);
        this.myIsToolWindowContextMenu = ComponentUtil.getParentOfType(InternalDecoratorImpl.class, (Component)component2) != null;
    }

    boolean isToolWindowContextMenu() {
        return this.myIsToolWindowContextMenu;
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(8);
        }
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDataContextProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTargetComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applicationDeactivated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMenu
    extends JBPopupMenu {
        @NotNull
        private final String myPlace;
        @NotNull
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        MyMenu(@NotNull String place, @Nullable ActionGroup group2, PresentationFactory factory2) {
            if (place == null) {
                MyMenu.$$$reportNull$$$0(0);
            }
            if (group2 == null) {
                MyMenu.$$$reportNull$$$0(1);
            }
            this.myPlace = place;
            this.myGroup = group2;
            this.myPresentationFactory = factory2 != null ? factory2 : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
            this.addPropertyChangeListener("updateChildren", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MyMenu.this.updateChildren(null);
                }
            });
            UiInspectorUtil.registerProvider((JComponent)((Object)this), () -> UiInspectorUtil.collectActionGroupInfo("Menu", this.myGroup, this.myPlace));
        }

        public void show(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                MyMenu.$$$reportNull$$$0(2);
            }
            if (!component2.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen (" + component2 + ")");
            }
            int x2 = Math.max(0, Math.min(x, component2.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component2.getHeight() - 1));
            this.myContext = Utils.wrapDataContext(ActionPopupMenuImpl.this.myDataContextProvider != null ? ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component2, x2, y2));
            this.updateChildren(new RelativePoint(component2, new Point(x, y)));
            if (this.getComponentCount() == 0) {
                LOG.warn("no components in popup menu " + this.myPlace);
                return;
            }
            if (!component2.isShowing()) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isActive()) {
                Component parent = ComponentUtil.findUltimateParent((Component)component2);
                IdeFrame ideFrame = ActionPopupMenuImpl.this.myFrame = parent instanceof IdeFrame ? (IdeFrame)parent : null;
                if (ActionPopupMenuImpl.this.myConnection == null) {
                    ActionPopupMenuImpl.this.myConnection = application.getMessageBus().connect();
                    ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
                }
            }
            super.show(component2, x, y);
        }

        public void addNotify() {
            super.addNotify();
            if (Registry.is((String)"ide.diagnostics.show.context.menu.invocation.time")) {
                long time = System.currentTimeMillis() - IdeEventQueue.getInstance().getPopupTriggerTime();
                new Notification("", "Context menu invocation took " + time + "ms", NotificationType.INFORMATION).notify(null);
            }
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private void updateChildren(@Nullable RelativePoint point) {
            this.removeAll();
            TimeoutUtil.run(() -> Utils.fillMenu(this.myGroup, (JComponent)((Object)this), !UISettings.getInstance().getDisableMnemonics(), this.myPresentationFactory, this.myContext, this.myPlace, false, false, point), (long)1000L, ms -> LOG.warn(ms + " ms to fill popup menu " + this.myPlace));
        }

        private void disposeMenu() {
            MessageBusConnection connection = ActionPopupMenuImpl.this.myConnection;
            ActionPopupMenuImpl.this.myFrame = null;
            ActionPopupMenuImpl.this.myConnection = null;
            ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
            this.removeAll();
            if (connection != null) {
                connection.disconnect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                MyMenu.this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MyMenu.this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (MyMenu.this.getComponentCount() == 0) {
                    MyMenu.this.updateChildren(null);
                }
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

