/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.jackson.JacksonUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.IoErrorText;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class OldDirectoryCleaner {
    private final Logger myLogger = Logger.getInstance(OldDirectoryCleaner.class);
    private final long myBestBefore;

    public OldDirectoryCleaner(long bestBefore) {
        this.myBestBefore = bestBefore;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public void seekAndDestroy(@Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
        void project2;
        void indicator2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ConfigImportHelper.ConfigDirsSearchResult result2 = ConfigImportHelper.findConfigDirectories(PathManager.getConfigDir());
        List<DirectoryGroup> groups2 = this.collectDirectoryData(result2, (ProgressIndicator)indicator2);
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug("configs: " + result2.getPaths());
            this.myLogger.debug("groups: " + groups2);
        }
        if (this.myBestBefore != 0L) {
            this.deleteCowardly(groups2);
            Stats.completed(groups2.size(), groups2.stream().mapToLong(g -> g.size).sum());
        } else if (!groups2.isEmpty()) {
            UpdateChecker.getNotificationGroup().createNotification(IdeBundle.message((String)"old.dirs.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"old.dirs.notification.action", (Object[])new Object[0]), () -> this.lambda$seekAndDestroy$1((Project)project2, groups2))).notify((Project)project2);
        } else {
            UpdateChecker.getNotificationGroup().createNotification(IdeBundle.message((String)"old.dirs.not.found.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).notify((Project)project2);
        }
    }

    private List<DirectoryGroup> collectDirectoryData(ConfigImportHelper.ConfigDirsSearchResult result2, @Nullable ProgressIndicator indicator2) {
        List<Path> configs = result2.getPaths();
        ArrayList<DirectoryGroup> groups2 = new ArrayList<DirectoryGroup>(configs.size());
        String productInfoFileName = SystemInfo.isMac ? "Resources/product-info.json" : "product-info.json";
        for (Path config2 : configs) {
            List<Path> directories = result2.findRelatedDirectories(config2, this.myBestBefore != 0L);
            if (directories.isEmpty()) continue;
            String nameAndVersion = result2.getNameAndVersion(config2);
            long lastUpdated = 0L;
            long size2 = 0L;
            int entriesToDelete = 0;
            boolean isInstalled = false;
            for (Path directory : directories) {
                CollectingVisitor visitor;
                block19: {
                    visitor = new CollectingVisitor(indicator2);
                    try {
                        Files.walkFileTree(directory, visitor);
                        Path homeDir = Path.of(Files.readString(directory.resolve(".home")), new String[0]);
                        if (!Files.exists(homeDir, new LinkOption[0])) break block19;
                        try (BufferedReader reader = Files.newBufferedReader(homeDir.resolve(productInfoFileName));
                             JsonParser parser = new JsonFactory().createParser((Reader)reader);){
                            if (nameAndVersion.equals(JacksonUtil.readSingleField((JsonParser)parser, (String)"dataDirectoryName"))) {
                                isInstalled = true;
                            }
                        }
                        catch (NoSuchFileException e) {
                            this.myLogger.debug((Throwable)e);
                            isInstalled = true;
                        }
                    }
                    catch (IOException | InvalidPathException e) {
                        this.myLogger.debug((Throwable)e);
                    }
                }
                lastUpdated = Math.max(lastUpdated, visitor.lastUpdated);
                size2 += visitor.size;
                entriesToDelete += visitor.entriesToDelete;
            }
            if (this.myBestBefore != 0L && lastUpdated > this.myBestBefore) continue;
            groups2.add(new DirectoryGroup(nameAndVersion, directories, lastUpdated, size2, entriesToDelete, isInstalled));
        }
        return groups2;
    }

    private void deleteCowardly(List<DirectoryGroup> groups2) {
        for (DirectoryGroup group2 : groups2) {
            for (Path directory : group2.directories) {
                this.myLogger.info("deleting " + directory);
                try {
                    NioFiles.deleteRecursively((Path)directory);
                }
                catch (IOException e) {
                    this.myLogger.info((Throwable)e);
                }
            }
        }
    }

    private void confirmAndDelete(final Project project, List<DirectoryGroup> groups2) {
        List<DirectoryGroup> selectedGroups;
        MenuDialog dialog2 = new MenuDialog(project, groups2);
        if (dialog2.showAndGet() && !(selectedGroups = dialog2.getSelectedGroups()).isEmpty()) {
            new Task.Backgroundable(project, IdeBundle.message((String)"old.dirs.delete.progress", (Object[])new Object[0])){
                private Path currentRoot;
                private int progress;
                {
                    super(arg0, arg1);
                    this.progress = 0;
                }

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator2.setIndeterminate(false);
                    int total = selectedGroups.stream().mapToInt(g -> g.entriesToDelete).sum();
                    ArrayList<CallSite> errors = new ArrayList<CallSite>();
                    for (DirectoryGroup group2 : selectedGroups) {
                        for (Path directory : group2.directories) {
                            indicator2.checkCanceled();
                            indicator2.setText(directory.toString());
                            if (OldDirectoryCleaner.this.myLogger.isDebugEnabled()) {
                                OldDirectoryCleaner.this.myLogger.debug("deleting " + directory);
                            }
                            this.currentRoot = directory;
                            try {
                                NioFiles.deleteRecursively((Path)directory, p -> {
                                    indicator2.checkCanceled();
                                    indicator2.setFraction((double)this.progress++ / (double)total);
                                    indicator2.setText2(this.currentRoot.relativize((Path)p).toString());
                                });
                            }
                            catch (IOException e) {
                                OldDirectoryCleaner.this.myLogger.info((Throwable)e);
                                errors.add((CallSite)((Object)(directory + " (" + IoErrorText.message((Throwable)e) + ")")));
                            }
                        }
                    }
                    if (!errors.isEmpty()) {
                        @NlsSafe String content2 = String.join((CharSequence)"<br>", errors);
                        UpdateChecker.getNotificationGroup().createNotification(IdeBundle.message((String)"old.dirs.delete.error", (Object[])new Object[0]), content2, NotificationType.WARNING).addAction((AnAction)ShowLogAction.notificationAction()).notify(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/OldDirectoryCleaner$1", "run"));
                }
            }.queue();
        }
    }

    private /* synthetic */ void lambda$seekAndDestroy$1(Project project, List groups2) {
        this.confirmAndDelete(project, groups2);
    }

    private static class MenuDialog
    extends DialogWrapper {
        private final MenuTableModel myModel;

        MenuDialog(Project project, List<DirectoryGroup> groups2) {
            super(project, false);
            this.myModel = new MenuTableModel(groups2);
            this.setTitle(IdeBundle.message((String)"old.dirs.dialog.title", (Object[])new Object[0]));
            this.updateOkButton();
            this.init();
        }

        List<DirectoryGroup> getSelectedGroups() {
            return this.myModel.getSelectedGroups();
        }

        protected JComponent createCenterPanel() {
            JBTable table = new JBTable((TableModel)this.myModel);
            table.setShowGrid(false);
            table.getColumnModel().getColumn(0).setPreferredWidth(JBUI.scale((int)30));
            table.getColumnModel().getColumn(1).setPreferredWidth(JBUI.scale((int)300));
            table.getColumnModel().getColumn(2).setPreferredWidth(JBUI.scale((int)120));
            table.getColumnModel().getColumn(3).setPreferredWidth(JBUI.scale((int)120));
            final JBEmptyBorder border = JBUI.Borders.empty((int)0, (int)5);
            DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected2, boolean focused, int row2, int col) {
                    JLabel label2 = (JLabel)super.getTableCellRendererComponent(table, value2, selected2, focused, row2, col);
                    label2.setBorder((Border)border);
                    label2.setHorizontalAlignment(col == 1 ? 2 : 4);
                    if (row2 >= 0) {
                        DirectoryGroup group2 = myModel.myGroups.get(row2);
                        if (col == 1) {
                            @NlsSafe String paths2 = group2.directories.stream().map(Path::toString).collect(Collectors.joining("<br>", "<html>", "</html>"));
                            label2.setToolTipText(paths2);
                        } else if (col == 2) {
                            @NlsSafe String isoDate = FileTime.fromMillis(group2.lastUpdated).toString();
                            label2.setToolTipText(isoDate);
                        }
                    }
                    return label2;
                }
            };
            table.getColumnModel().getColumn(1).setHeaderRenderer(renderer2);
            table.getColumnModel().getColumn(1).setCellRenderer(renderer2);
            table.getColumnModel().getColumn(2).setHeaderRenderer(renderer2);
            table.getColumnModel().getColumn(2).setCellRenderer(renderer2);
            table.getColumnModel().getColumn(3).setHeaderRenderer(renderer2);
            table.getColumnModel().getColumn(3).setCellRenderer(renderer2);
            this.myModel.addTableModelListener(e -> this.updateOkButton());
            JPanel panel2 = new JPanel(new BorderLayout(0, JBUI.scale((int)5)));
            panel2.add((Component)new JBLabel(IdeBundle.message((String)"old.dirs.dialog.text", (Object[])new Object[0])), "North");
            JBScrollPane tableScroll = new JBScrollPane((Component)table);
            table.setFillsViewportHeight(true);
            panel2.add((Component)tableScroll, "Center");
            return panel2;
        }

        private void updateOkButton() {
            int n = this.myModel.mySelected.cardinality();
            this.setOKButtonText(IdeBundle.message((String)"old.dirs.dialog.delete.button", (Object[])new Object[]{n}));
            this.setOKActionEnabled(n > 0);
        }

        private static class MenuTableModel
        extends AbstractTableModel {
            private final List<DirectoryGroup> myGroups;
            private final BitSet mySelected = new BitSet();
            @PropertyKey(resourceBundle="messages.IdeBundle")
            private final @PropertyKey(resourceBundle="messages.IdeBundle") String[] myColumnNames = new String[]{"old.dirs.column.name", "old.dirs.column.updated", "old.dirs.column.size"};
            private final long myNow = System.currentTimeMillis();

            MenuTableModel(List<DirectoryGroup> groups2) {
                this.myGroups = groups2;
                for (int i2 = 0; i2 < groups2.size(); ++i2) {
                    this.mySelected.set(i2, !groups2.get((int)i2).isInstalled);
                }
            }

            List<DirectoryGroup> getSelectedGroups() {
                return IntStream.range(0, this.myGroups.size()).filter(this.mySelected::get).mapToObj(this.myGroups::get).collect(Collectors.toList());
            }

            @Override
            public int getRowCount() {
                return this.myGroups.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int column2) {
                return column2 == 0 ? "" : IdeBundle.message((String)this.myColumnNames[column2 - 1], (Object[])new Object[0]);
            }

            @Override
            public Class<?> getColumnClass(int column2) {
                return column2 == 0 ? Boolean.class : String.class;
            }

            @Override
            public Object getValueAt(int row2, int column2) {
                switch (column2) {
                    case 0: {
                        return this.mySelected.get(row2);
                    }
                    case 1: {
                        return this.myGroups.get((int)row2).name;
                    }
                    case 2: {
                        return DateFormatUtil.formatBetweenDates((long)this.myGroups.get((int)row2).lastUpdated, (long)this.myNow);
                    }
                    case 3: {
                        return StringUtil.formatFileSize((long)this.myGroups.get((int)row2).size);
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row2, int column2) {
                return column2 == 0;
            }

            @Override
            public void setValueAt(Object value2, int row2, int column2) {
                this.mySelected.set(row2, (Boolean)value2);
                this.fireTableCellUpdated(row2, column2);
            }
        }
    }

    private static class CollectingVisitor
    extends SimpleFileVisitor<Path> {
        @Nullable
        private final ProgressIndicator indicator;
        long lastUpdated = 0L;
        long size = 0L;
        int entriesToDelete = 0;

        CollectingVisitor(@Nullable ProgressIndicator indicator2) {
            this.indicator = indicator2;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.lastUpdated = Math.max(this.lastUpdated, attrs.lastModifiedTime().toMillis());
            ++this.entriesToDelete;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
            if (this.indicator != null) {
                this.indicator.checkCanceled();
            }
            this.lastUpdated = Math.max(this.lastUpdated, attrs.lastModifiedTime().toMillis());
            this.size += attrs.size();
            ++this.entriesToDelete;
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DirectoryGroup {
        @NlsSafe
        private final String name;
        private final List<Path> directories;
        private final long lastUpdated;
        private final long size;
        private final int entriesToDelete;
        private final boolean isInstalled;

        private DirectoryGroup(String name, List<Path> directories, long lastUpdated, long size2, int entriesToDelete, boolean isInstalled) {
            this.name = name;
            this.directories = directories;
            this.lastUpdated = lastUpdated;
            this.size = size2;
            this.entriesToDelete = entriesToDelete;
            this.isInstalled = isInstalled;
        }

        public String toString() {
            return "{" + this.directories + " " + this.lastUpdated + "}";
        }
    }

    @ApiStatus.Internal
    public static final class Stats
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("leftover.dirs", 1);
        private static final EventId SCHEDULED = GROUP.registerEvent("scan.scheduled");
        private static final EventId1<Integer> STARTED = GROUP.registerEvent("scan.started", (EventField)EventFields.Int((String)"delay_days"));
        private static final EventId2<Integer, Long> COMPLETE = GROUP.registerEvent("cleanup.complete", (EventField)EventFields.Int((String)"groups"), (EventField)EventFields.Long((String)"total_mb"));

        public EventLogGroup getGroup() {
            return GROUP;
        }

        public static void scheduled() {
            SCHEDULED.log();
        }

        public static void started(int actualDelayDays) {
            STARTED.log((Object)actualDelayDays);
        }

        public static void completed(int groups2, long totalBytes) {
            COMPLETE.log((Object)groups2, (Object)((totalBytes + 500000L) / 1000000L));
        }
    }
}

