/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.ActionChangeRangeImpl;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CompressionUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class EditorChangeAction
extends BasicUndoableAction
implements AdjustableUndoableAction {
    private final int myMoveOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    private final ActionChangeRangeImpl myChangeRange;

    EditorChangeAction(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorChangeAction.$$$reportNull$$$0(0);
        }
        this((DocumentImpl)e.getDocument(), e.getOffset(), e.getMoveOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    private EditorChangeAction(@NotNull DocumentImpl document, int offset, int moveOffset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        if (document == null) {
            EditorChangeAction.$$$reportNull$$$0(1);
        }
        if (oldString == null) {
            EditorChangeAction.$$$reportNull$$$0(2);
        }
        if (newString == null) {
            EditorChangeAction.$$$reportNull$$$0(3);
        }
        super(new Document[]{document});
        this.myMoveOffset = moveOffset;
        this.myOldString = CompressionUtil.compressStringRawBytes((CharSequence)oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes((CharSequence)newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
        int newDocumentLength = document.getTextLength();
        int oldDocumentLength = newDocumentLength - newString.length() + oldString.length();
        this.myChangeRange = new ActionChangeRangeImpl(offset, oldString.length(), newString.length(), oldDocumentLength, newDocumentLength, this);
    }

    public void undo() throws UnexpectedUndoException {
        long timeStamp = this.myChangeRange.isMoved() ? EditorChangeAction.createNextTimeStamp() : this.myOldTimeStamp;
        this.doChange(this.myChangeRange.getNewDocumentLength(), this.myOldString, this.myChangeRange.getOldDocumentLength(), timeStamp);
    }

    public void redo() throws UnexpectedUndoException {
        long timeStamp = this.myChangeRange.isMoved() ? EditorChangeAction.createNextTimeStamp() : this.myNewTimeStamp;
        this.doChange(this.myChangeRange.getOldDocumentLength(), this.myNewString, this.myChangeRange.getNewDocumentLength(), timeStamp);
    }

    private static long createNextTimeStamp() {
        return LocalTimeCounter.currentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(int fromLength, Object to, int toLength, long toTimeStamp) throws UnexpectedUndoException {
        DocumentImpl document = (DocumentImpl)this.getAffectedDocuments()[0].getDocument();
        assert (document != null);
        if (document.getTextLength() != fromLength) {
            throw new UnexpectedUndoException("Unexpected document state");
        }
        DocumentUndoProvider.startDocumentUndo(document);
        try {
            CharSequence toString2 = CompressionUtil.uncompressStringRawBytes((Object)to);
            int fromStringLength = toString2.length() - toLength + fromLength;
            int offset = this.myChangeRange.getOffset();
            int moveOffset = this.myChangeRange.isMoved() ? offset : this.myMoveOffset;
            document.replaceString(offset, offset + fromStringLength, moveOffset, toString2, toTimeStamp, false);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(document);
        }
    }

    @NotNull
    public List<ActionChangeRange> getChangeRanges(@NotNull DocumentReference reference2) {
        if (reference2 == null) {
            EditorChangeAction.$$$reportNull$$$0(4);
        }
        List<Object> list2 = this.isAffected(reference2) ? Collections.singletonList(this.myChangeRange) : Collections.emptyList();
        if (list2 == null) {
            EditorChangeAction.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private boolean isAffected(@NotNull DocumentReference reference2) {
        DocumentReference affected;
        VirtualFile affectedFile;
        if (reference2 == null) {
            EditorChangeAction.$$$reportNull$$$0(6);
        }
        if ((affectedFile = (affected = this.getAffectedDocuments()[0]).getFile()) != null) {
            return affectedFile.equals(reference2.getFile());
        }
        return affected.getDocument() == reference2.getDocument();
    }

    public void invalidateChangeRanges() {
        this.myChangeRange.invalidate();
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "' at: " + this.myChangeRange.getOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/EditorChangeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/EditorChangeAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangeRanges";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAffected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

